package com.zurrtum.create.content.equipment.goggles;

import com.zurrtum.create.AllItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1792;

public class GogglesItem extends class_1792 {
    private static final List<Predicate<class_1657>> IS_WEARING_PREDICATES = new ArrayList<>();

    static {
        addIsWearingPredicate(player -> player.method_6118(class_1304.field_6169).method_31574(AllItems.GOGGLES));
    }

    public GogglesItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public static boolean isWearingGoggles(class_1657 player) {
        for (Predicate<class_1657> predicate : IS_WEARING_PREDICATES) {
            if (predicate.test(player)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Use this method to add custom entry points to the goggles overlay, e.g. custom
     * armor, handheld alternatives, etc.
     */
    public static synchronized void addIsWearingPredicate(Predicate<class_1657> predicate) {
        IS_WEARING_PREDICATES.add(predicate);
    }
}