package com.zurrtum.create.content.equipment.toolbox;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.animatedContainer.AnimatedContainerBehaviour;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.foundation.utility.ResetableLazy;
import java.util.*;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1275;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4844;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9323.class_9324;
import net.minecraft.class_9473;

public class ToolboxBlockEntity extends SmartBlockEntity implements MenuProvider, class_1275 {

    public LerpedFloat lid = LerpedFloat.linear().startWithValue(0);

    public LerpedFloat drawers = LerpedFloat.linear().startWithValue(0);

    UUID uniqueId;
    public ToolboxInventory inventory;
    ResetableLazy<class_1767> colorProvider;

    Map<Integer, WeakHashMap<class_1657, Integer>> connectedPlayers;

    private class_2561 customName;

    private AnimatedContainerBehaviour<ToolboxMenu> openTracker;
    private boolean keepAlive;

    public ToolboxBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.TOOLBOX, pos, state);
        connectedPlayers = new HashMap<>();
        inventory = new ToolboxInventory(this);
        colorProvider = ResetableLazy.of(() -> {
            class_2680 blockState = method_11010();
            if (blockState != null && blockState.method_26204() instanceof ToolboxBlock)
                return ((ToolboxBlock) blockState.method_26204()).getColor();
            return class_1767.field_7957;
        });
        setLazyTickRate(10);
    }

    public class_1767 getColor() {
        return colorProvider.get();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(openTracker = new AnimatedContainerBehaviour<>(this, ToolboxMenu.class));
    }

    @Override
    public void initialize() {
        super.initialize();
        ToolboxHandler.onLoad(this);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        ToolboxHandler.onUnload(this);
    }

    @Override
    public void tick() {
        super.tick();

        if (field_11863.method_8608()) {
            tickAudio();
        } else {
            tickPlayers();
        }

        lid.chase(openTracker.openCount > 0 ? 1 : 0, 0.2f, Chaser.LINEAR);
        drawers.chase(openTracker.openCount > 0 ? 1 : 0, 0.2f, Chaser.EXP);
        lid.tickChaser();
        drawers.tickChaser();
    }

    private void tickPlayers() {
        boolean update = false;

        for (Iterator<Map.Entry<Integer, WeakHashMap<class_1657, Integer>>> toolboxSlots = connectedPlayers.entrySet()
            .iterator(); toolboxSlots.hasNext(); ) {

            Map.Entry<Integer, WeakHashMap<class_1657, Integer>> toolboxSlotEntry = toolboxSlots.next();
            WeakHashMap<class_1657, Integer> set = toolboxSlotEntry.getValue();
            int slot = toolboxSlotEntry.getKey();

            class_1799 referenceItem = inventory.filters.get(slot);
            boolean clear = referenceItem.method_7960();

            for (Iterator<Map.Entry<class_1657, Integer>> playerEntries = set.entrySet().iterator(); playerEntries.hasNext(); ) {
                Map.Entry<class_1657, Integer> playerEntry = playerEntries.next();

                class_1657 player = playerEntry.getKey();
                int hotbarSlot = playerEntry.getValue();

                if (!clear && !ToolboxHandler.withinRange(player, this))
                    continue;

                class_1661 playerInv = player.method_31548();
                class_1799 playerStack = playerInv.method_5438(hotbarSlot);

                if (clear || !playerStack.method_7960() && !ToolboxInventory.canItemsShareCompartment(playerStack, referenceItem)) {
                    class_2487 compound = AllSynchedDatas.TOOLBOX.get(player);
                    compound.method_10551(String.valueOf(hotbarSlot));
                    playerEntries.remove();
                    if (player instanceof class_3222)
                        ToolboxHandler.syncData(player, compound);
                    continue;
                }

                int count = playerStack.method_7947();
                int targetAmount = (referenceItem.method_7914() + 1) / 2;

                if (count < targetAmount) {
                    int amountToReplenish = targetAmount - count;

                    if (isOpenInContainer(player)) {
                        class_1799 extracted = inventory.takeFromCompartment(amountToReplenish, slot, true);
                        if (!extracted.method_7960()) {
                            ToolboxHandler.unequip(player, hotbarSlot, false);
                            ToolboxHandler.syncData(player, AllSynchedDatas.TOOLBOX.get(player));
                            continue;
                        }
                    }

                    class_1799 extracted = inventory.takeFromCompartment(amountToReplenish, slot, false);
                    if (!extracted.method_7960()) {
                        update = true;
                        class_1799 template = playerStack.method_7960() ? extracted : playerStack;
                        playerInv.method_5447(hotbarSlot, template.method_46651(count + extracted.method_7947()));
                    }
                }

                if (count > targetAmount) {
                    int amountToDeposit = count - targetAmount;
                    class_1799 toDistribute = playerStack.method_46651(amountToDeposit);

                    if (isOpenInContainer(player)) {
                        int deposited = inventory.distributeToCompartment(toDistribute, slot, true);
                        if (deposited > 0) {
                            ToolboxHandler.unequip(player, hotbarSlot, true);
                            ToolboxHandler.syncData(player, AllSynchedDatas.TOOLBOX.get(player));
                            continue;
                        }
                    }

                    int deposited = inventory.distributeToCompartment(toDistribute, slot, false);
                    if (deposited > 0) {
                        update = true;
                        playerInv.method_5447(hotbarSlot, playerStack.method_46651(count - deposited));
                    }
                }
            }

            if (clear)
                toolboxSlots.remove();
        }

        if (update)
            sendData();

    }

    private boolean isOpenInContainer(class_1657 player) {
        return player.field_7512 instanceof ToolboxMenu toolboxMenu && toolboxMenu.contentHolder == this;
    }

    public void unequipTracked() {
        if (field_11863.method_8608())
            return;

        Set<class_3222> affected = new HashSet<>();

        for (Map.Entry<Integer, WeakHashMap<class_1657, Integer>> toolboxSlotEntry : connectedPlayers.entrySet()) {

            WeakHashMap<class_1657, Integer> set = toolboxSlotEntry.getValue();

            for (Map.Entry<class_1657, Integer> playerEntry : set.entrySet()) {
                class_1657 player = playerEntry.getKey();
                int hotbarSlot = playerEntry.getValue();

                ToolboxHandler.unequip(player, hotbarSlot, false);
                if (player instanceof class_3222 serverPlayer)
                    affected.add(serverPlayer);
            }
        }

        for (class_3222 player : affected)
            ToolboxHandler.syncData(player, AllSynchedDatas.TOOLBOX.get(player));
        connectedPlayers.clear();
    }

    public void unequip(int slot, class_1657 player, int hotbarSlot, boolean keepItems) {
        if (!connectedPlayers.containsKey(slot))
            return;
        connectedPlayers.get(slot).remove(player);
        if (keepItems)
            return;

        class_1661 playerInv = player.method_31548();
        class_1799 playerStack = playerInv.method_5438(hotbarSlot);
        class_1799 toInsert = ToolboxInventory.cleanItemNBT(playerStack.method_7972());
        int insert = inventory.distributeToCompartment(toInsert, slot, false);

        if (insert != 0) {
            int count = playerStack.method_7947();
            if (insert == count) {
                playerInv.method_5447(hotbarSlot, class_1799.field_8037);
            } else {
                playerStack.method_7939(count - insert);
            }
        }
    }

    private void tickAudio() {
        class_243 vec = VecHelper.getCenterOf(field_11867);
        if (lid.settled()) {
            if (openTracker.openCount > 0 && lid.getChaseTarget() == 0) {
                field_11863.method_8486(
                    vec.field_1352,
                    vec.field_1351,
                    vec.field_1350,
                    class_3417.field_14567,
                    class_3419.field_15245,
                    0.25F,
                    field_11863.field_9229.method_43057() * 0.1F + 1.2F,
                    true
                );
                field_11863.method_8486(
                    vec.field_1352,
                    vec.field_1351,
                    vec.field_1350,
                    class_3417.field_14982,
                    class_3419.field_15245,
                    0.1F,
                    field_11863.field_9229.method_43057() * 0.1F + 1.1F,
                    true
                );
            }
            if (openTracker.openCount == 0 && lid.getChaseTarget() == 1)
                field_11863.method_8486(
                    vec.field_1352,
                    vec.field_1351,
                    vec.field_1350,
                    class_3417.field_14823,
                    class_3419.field_15245,
                    0.1F,
                    field_11863.field_9229.method_43057() * 0.1F + 1.1F,
                    true
                );

        } else if (openTracker.openCount == 0 && lid.getChaseTarget() == 0 && lid.getValue(0) > 1 / 16f && lid.getValue(1) < 1 / 16f)
            field_11863.method_8486(
                vec.field_1352,
                vec.field_1351,
                vec.field_1350,
                class_3417.field_14819,
                class_3419.field_15245,
                0.25F,
                field_11863.field_9229.method_43057() * 0.1F + 1.2F,
                true
            );
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        inventory.read(view.method_71434("Inventory"));
        super.read(view, clientPacket);
        view.method_71426("UniqueId", class_4844.field_25122).ifPresent(uuid -> uniqueId = uuid);
        view.method_71426("CustomName", class_8824.field_46597).ifPresent(name -> customName = name);
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        if (uniqueId == null)
            uniqueId = UUID.randomUUID();

        inventory.write(view.method_71461("Inventory"));
        view.method_71468("UniqueId", class_4844.field_25122, uniqueId);

        if (customName != null)
            view.method_71468("CustomName", class_8824.field_46597, customName);
        super.write(view, clientPacket);
    }

    @Override
    public ToolboxMenu createMenu(int id, class_1661 inv, class_1657 player, class_9129 extraData) {
        sendToMenu(extraData);
        return new ToolboxMenu(id, inv, this);
    }

    @Override
    public void lazyTick() {
        // keep re-advertising active TEs
        ToolboxHandler.onLoad(this);
        super.lazyTick();
    }

    public void connectPlayer(int slot, class_1657 player, int hotbarSlot) {
        if (field_11863.method_8608())
            return;
        WeakHashMap<class_1657, Integer> map = connectedPlayers.computeIfAbsent(slot, WeakHashMap::new);
        Integer previous = map.get(player);
        if (previous != null) {
            if (previous == hotbarSlot)
                return;
            ToolboxHandler.unequip(player, previous, false);
        }
        map.put(player, hotbarSlot);
    }

    public void readInventory(ToolboxInventory inv) {
        if (inv != null) {
            class_2371<class_1799> filters = inv.filters;
            for (int i = 0, size = filters.size(); i < size; i++) {
                inventory.filters.set(i, filters.get(i));
            }
            for (int i = 0, size = inv.method_5439(); i < size; i++)
                inventory.method_5447(i, inv.method_5438(i));
        }
    }

    public void setUniqueId(UUID uniqueId) {
        this.uniqueId = uniqueId;
    }

    public UUID getUniqueId() {
        return uniqueId;
    }

    public boolean isFullyInitialized() {
        // returns true when uniqueId has been initialized
        return uniqueId != null;
    }

    public void setCustomName(class_2561 customName) {
        this.customName = customName;
    }

    @Override
    public class_2561 method_5476() {
        return customName != null ? customName : method_11010().method_26204().method_9518();
    }

    @Override
    public class_2561 method_5797() {
        return customName;
    }

    @Override
    public boolean method_16914() {
        return customName != null;
    }

    @Override
    public class_2561 method_5477() {
        return customName;
    }

    @SuppressWarnings("deprecation")
    @Override
    public void method_31664(class_2680 state) {
        super.method_31664(state);
        colorProvider.reset();
    }

    @Override
    protected void method_57568(class_9473 componentInput) {
        setUniqueId(componentInput.method_58694(AllDataComponents.TOOLBOX_UUID));
        readInventory(componentInput.method_58694(AllDataComponents.TOOLBOX_INVENTORY));
    }

    @Override
    protected void method_57567(class_9324 components) {
        components.method_57840(AllDataComponents.TOOLBOX_UUID, uniqueId);
        components.method_57840(AllDataComponents.TOOLBOX_INVENTORY, inventory);
    }

    @Override
    public void method_66473(class_2338 pos, class_2680 oldState) {
        class_2680 state = field_11863.method_8320(pos);
        if (method_11017().method_20526(state)) {
            keepAlive = true;
            method_31664(state);
        } else {
            super.method_66473(pos, oldState);
        }
    }

    @Override
    public void method_11012() {
        if (keepAlive) {
            keepAlive = false;
            field_11863.method_22350(field_11867).method_12007(this);
        } else {
            super.method_11012();
        }
    }
}