package com.zurrtum.create.content.equipment.zapper.terrainzapper;


import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.component.TerrainTools;
import java.util.*;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;

public class DynamicBrush extends Brush {

    public static final int MAX_RADIUS = 10;

    private final boolean surface;

    public DynamicBrush(boolean surface) {
        super(1);
        this.surface = surface;
    }

    @Override
    public TerrainTools[] getSupportedTools() {
        return surface ? new TerrainTools[]{TerrainTools.Overlay, TerrainTools.Replace, TerrainTools.Clear} : new TerrainTools[]{TerrainTools.Replace, TerrainTools.Clear};
    }

    @Override
    public boolean hasPlacementOptions() {
        return false;
    }

    @Override
    public boolean hasConnectivityOptions() {
        return true;
    }

    @Override
    public int getMax(int paramIndex) {
        return MAX_RADIUS;
    }

    @Override
    public int getMin(int paramIndex) {
        return 1;
    }

    @Override
    public TerrainTools redirectTool(TerrainTools tool) {
        if (tool == TerrainTools.Overlay)
            return TerrainTools.Place;
        return super.redirectTool(tool);
    }

    @Override
    public Collection<class_2338> addToGlobalPositions(
        class_1936 world,
        class_2338 targetPos,
        class_2350 targetFace,
        Collection<class_2338> affectedPositions,
        TerrainTools usedTool
    ) {

        boolean searchDiagonals = param1 == 0;
        boolean fuzzy = param2 == 0;
        boolean replace = usedTool != TerrainTools.Overlay;
        int searchRange = param0;

        Set<class_2338> visited = new HashSet<>();
        List<class_2338> frontier = new LinkedList<>();

        class_2680 state = world.method_8320(targetPos);
        List<class_2338> offsets = new LinkedList<>();

        for (int x = -1; x <= 1; x++)
            for (int y = -1; y <= 1; y++)
                for (int z = -1; z <= 1; z++)
                    if (Math.abs(x) + Math.abs(y) + Math.abs(z) < 2 || searchDiagonals)
                        if (targetFace.method_10166().method_10173(x, y, z) == 0 || !surface)
                            offsets.add(new class_2338(x, y, z));

        class_2338 startPos = replace ? targetPos : targetPos.method_10093(targetFace);
        frontier.add(startPos);

        while (!frontier.isEmpty()) {
            class_2338 currentPos = frontier.removeFirst();
            if (visited.contains(currentPos))
                continue;
            visited.add(currentPos);
            if (!currentPos.method_19771(startPos, searchRange))
                continue;

            // Replace Mode
            if (replace) {
                class_2680 stateToReplace = world.method_8320(currentPos);
                class_2680 stateAboveStateToReplace = world.method_8320(currentPos.method_10093(targetFace));

                // Criteria
                if (stateToReplace.method_26214(world, currentPos) == -1)
                    continue;
                if (stateToReplace.method_26204() != state.method_26204() && !fuzzy)
                    continue;
                if (stateToReplace.method_45474())
                    continue;
                if (BlockHelper.hasBlockSolidSide(
                    stateAboveStateToReplace,
                    world,
                    currentPos.method_10093(targetFace),
                    targetFace.method_10153()
                ) && surface)
                    continue;
                affectedPositions.add(currentPos);

                // Search adjacent spaces
                for (class_2338 offset : offsets)
                    frontier.add(currentPos.method_10081(offset));
                continue;
            }

            // Place Mode
            class_2680 stateToPlaceAt = world.method_8320(currentPos);
            class_2680 stateToPlaceOn = world.method_8320(currentPos.method_10093(targetFace.method_10153()));

            // Criteria
            if (stateToPlaceOn.method_45474())
                continue;
            if (stateToPlaceOn.method_26204() != state.method_26204() && !fuzzy)
                continue;
            if (!stateToPlaceAt.method_45474())
                continue;
            affectedPositions.add(currentPos);

            // Search adjacent spaces
            for (class_2338 offset : offsets)
                frontier.add(currentPos.method_10081(offset));
            continue;
        }

        return affectedPositions;
    }
}
