package com.zurrtum.create.content.fluids.hosePulley;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.fluids.pipes.FluidPipeBlock;
import com.zurrtum.create.content.kinetics.base.HorizontalKineticBlock;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidInventoryProvider;
import net.minecraft.class_1750;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_4538;

public class HosePulleyBlock extends HorizontalKineticBlock implements IBE<HosePulleyBlockEntity>, FluidInventoryProvider<HosePulleyBlockEntity> {

    public HosePulleyBlock(class_2251 properties) {
        super(properties);
    }

    @Override
    public FluidInventory getFluidInventory(class_1936 world, class_2338 pos, class_2680 state, HosePulleyBlockEntity blockEntity, class_2350 context) {
        return blockEntity.handler;
    }

    @Override
    public class_2351 getRotationAxis(class_2680 state) {
        return state.method_11654(HORIZONTAL_FACING).method_10170().method_10166();
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2350 preferredHorizontalFacing = getPreferredHorizontalFacing(context);
        return method_9564().method_11657(
            HORIZONTAL_FACING,
            preferredHorizontalFacing != null ? preferredHorizontalFacing.method_10160() : context.method_8042()
                .method_10153()
        );
    }

    @Override
    public boolean hasShaftTowards(class_4538 world, class_2338 pos, class_2680 state, class_2350 face) {
        return state.method_11654(HORIZONTAL_FACING).method_10170() == face;
    }

    public static boolean hasPipeTowards(class_4538 world, class_2338 pos, class_2680 state, class_2350 face) {
        return state.method_11654(HORIZONTAL_FACING).method_10160() == face;
    }

    @Override
    public class_2350 getPreferredHorizontalFacing(class_1750 context) {
        class_2350 fromParent = super.getPreferredHorizontalFacing(context);
        if (fromParent != null)
            return fromParent;

        class_2350 prefferedSide = null;
        for (class_2350 facing : Iterate.horizontalDirections) {
            class_2338 pos = context.method_8037().method_10093(facing);
            class_2680 blockState = context.method_8045().method_8320(pos);
            if (FluidPipeBlock.canConnectTo(context.method_8045(), pos, blockState, facing))
                if (prefferedSide != null && prefferedSide.method_10166() != facing.method_10166()) {
                    prefferedSide = null;
                    break;
                } else
                    prefferedSide = facing;
        }
        return prefferedSide == null ? null : prefferedSide.method_10153();
    }

    @Override
    public Class<HosePulleyBlockEntity> getBlockEntityClass() {
        return HosePulleyBlockEntity.class;
    }

    @Override
    public class_2591<? extends HosePulleyBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.HOSE_PULLEY;
    }

}
