package com.zurrtum.create.content.fluids.pipes;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.api.contraption.transformable.TransformableBlockEntity;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.decoration.bracket.BracketedBlockEntityBehaviour;
import com.zurrtum.create.content.fluids.FluidPropagator;
import com.zurrtum.create.content.fluids.FluidTransportBehaviour;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class FluidPipeBlockEntity extends SmartBlockEntity implements TransformableBlockEntity {

    public FluidPipeBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public static FluidPipeBlockEntity pipe(class_2338 pos, class_2680 state) {
        return new FluidPipeBlockEntity(AllBlockEntityTypes.FLUID_PIPE, pos, state);
    }

    public static FluidPipeBlockEntity encased(class_2338 pos, class_2680 state) {
        return new FluidPipeBlockEntity(AllBlockEntityTypes.ENCASED_FLUID_PIPE, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(new StandardPipeFluidTransportBehaviour(this));
        behaviours.add(new BracketedBlockEntityBehaviour(this, this::canHaveBracket));
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return FluidPropagator.getSharedTriggers();
    }

    @Override
    public void transform(class_2586 be, StructureTransform transform) {
        BracketedBlockEntityBehaviour bracketBehaviour = getBehaviour(BracketedBlockEntityBehaviour.TYPE);
        if (bracketBehaviour != null) {
            bracketBehaviour.transformBracket(transform);
        }
    }

    private boolean canHaveBracket(class_2680 state) {
        return !(state.method_26204() instanceof EncasedPipeBlock);
    }

    class StandardPipeFluidTransportBehaviour extends FluidTransportBehaviour {

        public StandardPipeFluidTransportBehaviour(SmartBlockEntity be) {
            super(be);
        }

        @Override
        public boolean canHaveFlowToward(class_2680 state, class_2350 direction) {
            return (FluidPipeBlock.isPipe(state) || state.method_26204() instanceof EncasedPipeBlock) && state.method_11654(FluidPipeBlock.field_11329.get(
                direction));
        }

        @Override
        public AttachmentTypes getRenderedRimAttachment(class_1920 world, class_2338 pos, class_2680 state, class_2350 direction) {
            AttachmentTypes attachment = super.getRenderedRimAttachment(world, pos, state, direction);

            class_2338 offsetPos = pos.method_10093(direction);
            class_2680 otherState = world.method_8320(offsetPos);

            if (state.method_26204() instanceof EncasedPipeBlock && attachment != AttachmentTypes.DRAIN)
                return AttachmentTypes.NONE;

            if (attachment == AttachmentTypes.RIM) {
                if (!FluidPipeBlock.isPipe(otherState) && !(otherState.method_26204() instanceof EncasedPipeBlock) && !(otherState.method_26204() instanceof GlassFluidPipeBlock)) {
                    FluidTransportBehaviour pipeBehaviour = BlockEntityBehaviour.get(world, offsetPos, FluidTransportBehaviour.TYPE);
                    if (pipeBehaviour != null && pipeBehaviour.canHaveFlowToward(otherState, direction.method_10153()))
                        return AttachmentTypes.DETAILED_CONNECTION;
                }

                if (!FluidPipeBlock.shouldDrawRim(world, pos, state, direction))
                    return FluidPropagator.getStraightPipeAxis(state) == direction.method_10166() ? AttachmentTypes.CONNECTION : AttachmentTypes.DETAILED_CONNECTION;
            }

            if (attachment == AttachmentTypes.NONE && state.method_11654(FluidPipeBlock.field_11329.get(direction)))
                return AttachmentTypes.DETAILED_CONNECTION;

            return attachment;
        }

    }

}
