package com.zurrtum.create.content.fluids.tank;

import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.api.boiler.BoilerHeater;
import com.zurrtum.create.api.registry.SimpleRegistry;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock.HeatLevel;
import com.zurrtum.create.foundation.utility.BlockHelper;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class BoilerHeaters {
    public static void register() {
        BoilerHeater.REGISTRY.register(AllBlocks.BLAZE_BURNER, BoilerHeater.BLAZE_BURNER);
        BoilerHeater.REGISTRY.registerProvider(SimpleRegistry.Provider.forBlockTag(AllBlockTags.PASSIVE_BOILER_HEATERS, BoilerHeater.PASSIVE));
    }

    public static int passive(class_1937 level, class_2338 pos, class_2680 state) {
        return BlockHelper.isNotUnheated(state) ? BoilerHeater.PASSIVE_HEAT : BoilerHeater.NO_HEAT;
    }

    public static int blazeBurner(class_1937 level, class_2338 pos, class_2680 state) {
        HeatLevel value = state.method_11654(BlazeBurnerBlock.HEAT_LEVEL);
        if (value == HeatLevel.NONE) {
            return BoilerHeater.NO_HEAT;
        }
        if (value == HeatLevel.SEETHING) {
            return 2;
        }
        if (value.isAtLeast(HeatLevel.FADING)) {
            return 1;
        }
        return BoilerHeater.PASSIVE_HEAT;
    }
}
