package com.zurrtum.create.content.kinetics.chainConveyor;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.content.kinetics.base.KineticBlock;
import com.zurrtum.create.foundation.block.IBE;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import org.jetbrains.annotations.Nullable;

public class ChainConveyorBlock extends KineticBlock implements IBE<ChainConveyorBlockEntity> {

    public ChainConveyorBlock(class_2251 properties) {
        super(properties);
    }

    @Override
    public class_2351 getRotationAxis(class_2680 state) {
        return class_2351.field_11052;
    }

    @Override
    public class_265 method_9584(class_2680 pState, class_1922 pLevel, class_2338 pPos) {
        return AllShapes.CHAIN_CONVEYOR_INTERACTION;
    }

    @Override
    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return AllShapes.CHAIN_CONVEYOR_INTERACTION;
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (!level.method_8608() && stack.method_31574(class_1802.field_23983))
            return class_1269.field_5812;
        if (stack.method_31574(AllItems.PACKAGE_FROGPORT))
            return class_1269.field_5812;
        return class_1269.field_52423;
    }

    @Override
    public class_2680 method_9576(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1657 pPlayer) {
        super.method_9576(pLevel, pPos, pState, pPlayer);
        if (pLevel.method_8608())
            return pState;
        if (!pPlayer.method_68878())
            return pState;
        withBlockEntityDo(pLevel, pPos, be -> be.cancelDrops = true);
        return pState;
    }

    @Override
    public void method_9556(class_1937 level, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, class_1799 tool) {
        super.method_9556(level, player, pos, state, blockEntity, tool);
    }

    @Override
    public class_1269 onSneakWrenched(class_2680 state, class_1838 context) {
        class_1657 player = context.method_8036();
        if (player == null)
            return super.onSneakWrenched(state, context);

        withBlockEntityDo(
            context.method_8045(), context.method_8037(), be -> {
                be.cancelDrops = true;
                if (player.method_68878())
                    return;
                for (class_2338 targetPos : be.connections) {
                    int chainCost = ChainConveyorBlockEntity.getChainCost(targetPos);
                    while (chainCost > 0) {
                        player.method_31548().method_7398(new class_1799(class_1802.field_23983, Math.min(chainCost, 64)));
                        chainCost -= 64;
                    }
                }
            }
        );

        return super.onSneakWrenched(state, context);
    }

    @Override
    public class_2680 method_9605(class_1750 pContext) {
        for (int x = -1; x <= 1; x++)
            for (int z = -1; z <= 1; z++)
                if (pContext.method_8045().method_8320(pContext.method_8037().method_10069(x, 0, z)).method_26204() == this)
                    return null;

        return super.method_9605(pContext);
    }

    @Override
    public class_265 method_9549(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return class_259.method_1077();
    }

    @Override
    public boolean hasShaftTowards(class_4538 world, class_2338 pos, class_2680 state, class_2350 face) {
        return face.method_10166() == getRotationAxis(state);
    }

    @Override
    public Class<ChainConveyorBlockEntity> getBlockEntityClass() {
        return ChainConveyorBlockEntity.class;
    }

    @Override
    public class_2591<? extends ChainConveyorBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.CHAIN_CONVEYOR;
    }

}
