package com.zurrtum.create.content.kinetics.chainConveyor;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.api.contraption.transformable.TransformableBlockEntity;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.logistics.box.PackageEntity;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.packagePort.frogport.FrogportBlockEntity;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.function.Consumer;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class ChainConveyorBlockEntity extends KineticBlockEntity implements TransformableBlockEntity {
    public static final Codec<List<ChainConveyorPackage>> PACKAGE_CODEC = ChainConveyorPackage.CODEC.listOf();
    public static final Codec<List<ChainConveyorPackage>> CLIENT_PACKAGE_CODEC = ChainConveyorPackage.CLIENT_CODEC.listOf();
    public static final Codec<Map<class_2338, List<ChainConveyorPackage>>> MAP_CODEC = CreateCodecs.getCodecMap(class_2338.field_25064, PACKAGE_CODEC);
    public static final Codec<Map<class_2338, List<ChainConveyorPackage>>> CLIENT_MAP_CODEC = CreateCodecs.getCodecMap(
        class_2338.field_25064,
        CreateCodecs.getArrayListCodec(ChainConveyorPackage.CLIENT_CODEC)
    );

    public record ConnectionStats(float tangentAngle, float chainLength, class_243 start, class_243 end) {
    }

    public record ConnectedPort(float chainPosition, @Nullable class_2338 connection, String filter) {
    }

    public Set<class_2338> connections = new HashSet<>();
    public Map<class_2338, ConnectionStats> connectionStats;

    public Map<class_2338, ConnectedPort> loopPorts = new HashMap<>();
    public Map<class_2338, ConnectedPort> travelPorts = new HashMap<>();
    public ChainConveyorRoutingTable routingTable = new ChainConveyorRoutingTable();

    List<ChainConveyorPackage> loopingPackages = new ArrayList<>();
    Map<class_2338, List<ChainConveyorPackage>> travellingPackages = new HashMap<>();

    public boolean reversed;
    public boolean cancelDrops;
    public boolean checkInvalid;

    class_2338 chainDestroyedEffectToSend;

    public ChainConveyorBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.CHAIN_CONVEYOR, pos, state);
        checkInvalid = true;
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(field_11867).method_1014(connections.isEmpty() ? 3 : 64);
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        updateChainShapes();
    }

    public boolean canAcceptMorePackages() {
        return loopingPackages.size() + travellingPackages.size() < AllConfigs.server().logistics.chainConveyorCapacity.get();
    }

    public boolean canAcceptPackagesFor(@Nullable class_2338 connection) {
        if (connection == null && !canAcceptMorePackages())
            return false;
        return connection == null || (field_11863.method_8321(field_11867.method_10081(connection)) instanceof ChainConveyorBlockEntity otherClbe && otherClbe.canAcceptMorePackages());
    }

    public boolean canAcceptMorePackagesFromOtherConveyor() {
        return loopingPackages.size() < AllConfigs.server().logistics.chainConveyorCapacity.get();
    }

    //    @Override
    //    public boolean addToTooltip(List<Text> tooltip, boolean isPlayerSneaking) {
    //        return super.addToTooltip(tooltip, isPlayerSneaking);
    //
    //        // debug routing info
    //        //		tooltip.addAll(routingTable.createSummary());
    //        //		if (!loopPorts.isEmpty())
    //        //			tooltip.add(Component.literal(loopPorts.size() + " Loop ports"));
    //        //		if (!travelPorts.isEmpty())
    //        //			tooltip.add(Component.literal(travelPorts.size() + " Travel ports"));
    //        //		return true;
    //    }

    @Override
    public void tick() {
        super.tick();

        if (checkInvalid && !field_11863.method_8608()) {
            checkInvalid = false;
            removeInvalidConnections();
        }

        float serverSpeed = field_11863.method_8608() && !isVirtual() ? AllClientHandle.INSTANCE.getServerSpeed() : 1f;
        float speed = getSpeed() / 360f;
        float radius = 1.5f;
        float distancePerTick = Math.abs(speed);
        float degreesPerTick = (speed / (class_3532.field_29844 * radius)) * 360f;
        boolean reversedPreviously = reversed;

        prepareStats();

        if (field_11863.method_8608()) {
            getBehaviour(ChainConveyorBehaviour.TYPE).blockEntityTickBoxVisuals();
        }

        if (!field_11863.method_8608()) {
            routingTable.tick();
            if (routingTable.shouldAdvertise()) {
                for (class_2338 pos : connections)
                    if (field_11863.method_8321(this.field_11867.method_10081(pos)) instanceof ChainConveyorBlockEntity clbe)
                        routingTable.advertiseTo(pos, clbe.routingTable);
                routingTable.changed = false;
                routingTable.lastUpdate = 0;
            }
        }

        if (speed == 0) {
            updateBoxWorldPositions();
            return;
        }

        if (reversedPreviously != reversed) {
            for (Map.Entry<class_2338, List<ChainConveyorPackage>> entry : travellingPackages.entrySet()) {
                class_2338 offset = entry.getKey();
                if (!(field_11863.method_8321(field_11867.method_10081(offset)) instanceof ChainConveyorBlockEntity otherLift))
                    continue;
                for (Iterator<ChainConveyorPackage> iterator = entry.getValue().iterator(); iterator.hasNext(); ) {
                    ChainConveyorPackage box = iterator.next();
                    if (box.justFlipped)
                        continue;
                    box.justFlipped = true;
                    float length = (float) class_243.method_24954(offset).method_1033() - 22 / 16f;
                    box.chainPosition = length - box.chainPosition;
                    otherLift.addTravellingPackage(box, offset.method_35830(-1));
                    iterator.remove();
                }
            }
            notifyUpdate();
        }

        for (Map.Entry<class_2338, List<ChainConveyorPackage>> entry : travellingPackages.entrySet()) {
            class_2338 target = entry.getKey();
            ConnectionStats stats = connectionStats.get(target);
            if (stats == null)
                continue;

            Travelling:
            for (Iterator<ChainConveyorPackage> iterator = entry.getValue().iterator(); iterator.hasNext(); ) {
                ChainConveyorPackage box = iterator.next();
                box.justFlipped = false;

                float prevChainPosition = box.chainPosition;
                box.chainPosition += serverSpeed * distancePerTick;
                box.chainPosition = Math.min(stats.chainLength, box.chainPosition);

                float anticipatePosition = box.chainPosition;
                anticipatePosition += serverSpeed * distancePerTick * 4;
                anticipatePosition = Math.min(stats.chainLength, anticipatePosition);

                if (field_11863.method_8608() && !isVirtual())
                    continue;

                for (Map.Entry<class_2338, ConnectedPort> portEntry : travelPorts.entrySet()) {
                    ConnectedPort port = portEntry.getValue();
                    float chainPosition = port.chainPosition();

                    if (prevChainPosition > chainPosition)
                        continue;
                    if (!target.equals(port.connection))
                        continue;

                    boolean notAtPositionYet = box.chainPosition < chainPosition;
                    if (notAtPositionYet && anticipatePosition < chainPosition)
                        continue;
                    if (!PackageItem.matchAddress(box.item, port.filter()))
                        continue;
                    if (notAtPositionYet) {
                        notifyPortToAnticipate(portEntry.getKey());
                        continue;
                    }

                    if (!exportToPort(box, portEntry.getKey()))
                        continue;

                    iterator.remove();
                    notifyUpdate();
                    continue Travelling;
                }

                if (box.chainPosition < stats.chainLength)
                    continue;

                // transfer to other
                if (field_11863.method_8321(field_11867.method_10081(target)) instanceof ChainConveyorBlockEntity clbe) {
                    box.chainPosition = wrapAngle(stats.tangentAngle + 180 + 2 * 35 * (reversed ? -1 : 1));
                    clbe.addLoopingPackage(box);
                    iterator.remove();
                    notifyUpdate();
                }
            }
        }

        Looping:
        for (Iterator<ChainConveyorPackage> iterator = loopingPackages.iterator(); iterator.hasNext(); ) {
            ChainConveyorPackage box = iterator.next();
            box.justFlipped = false;

            float prevChainPosition = box.chainPosition;
            box.chainPosition += serverSpeed * degreesPerTick;
            box.chainPosition = wrapAngle(box.chainPosition);

            float anticipatePosition = box.chainPosition;
            anticipatePosition += serverSpeed * degreesPerTick * 4;
            anticipatePosition = wrapAngle(anticipatePosition);

            if (field_11863.method_8608())
                continue;

            for (Map.Entry<class_2338, ConnectedPort> portEntry : loopPorts.entrySet()) {
                ConnectedPort port = portEntry.getValue();
                float offBranchAngle = port.chainPosition();

                boolean notAtPositionYet = !loopThresholdCrossed(box.chainPosition, prevChainPosition, offBranchAngle);
                if (notAtPositionYet && !loopThresholdCrossed(anticipatePosition, prevChainPosition, offBranchAngle))
                    continue;
                if (!PackageItem.matchAddress(box.item, port.filter()))
                    continue;
                if (notAtPositionYet) {
                    notifyPortToAnticipate(portEntry.getKey());
                    continue;
                }

                if (!exportToPort(box, portEntry.getKey()))
                    continue;

                iterator.remove();
                notifyUpdate();
                continue Looping;
            }

            for (class_2338 connection : connections) {
                if (field_11863.method_8321(field_11867.method_10081(connection)) instanceof ChainConveyorBlockEntity ccbe && !ccbe.canAcceptMorePackagesFromOtherConveyor())
                    continue;

                float offBranchAngle = connectionStats.get(connection).tangentAngle;

                if (!loopThresholdCrossed(box.chainPosition, prevChainPosition, offBranchAngle))
                    continue;
                if (!routingTable.getExitFor(box.item).equals(connection))
                    continue;

                box.chainPosition = 0;
                addTravellingPackage(box, connection);
                iterator.remove();
                continue Looping;
            }
        }

        updateBoxWorldPositions();
    }

    public void removeInvalidConnections() {
        boolean changed = false;
        for (Iterator<class_2338> iterator = connections.iterator(); iterator.hasNext(); ) {
            class_2338 next = iterator.next();
            class_2338 target = field_11867.method_10081(next);
            if (!field_11863.method_8477(target))
                continue;
            if (field_11863.method_8321(target) instanceof ChainConveyorBlockEntity ccbe && ccbe.connections.contains(next.method_35830(-1)))
                continue;
            iterator.remove();
            changed = true;
        }
        if (changed)
            notifyUpdate();
    }

    public void notifyConnectedToValidate() {
        for (class_2338 blockPos : connections) {
            class_2338 target = field_11867.method_10081(blockPos);
            if (!field_11863.method_8477(target))
                continue;
            if (field_11863.method_8321(target) instanceof ChainConveyorBlockEntity ccbe)
                ccbe.checkInvalid = true;
        }
    }

    public boolean loopThresholdCrossed(float chainPosition, float prevChainPosition, float offBranchAngle) {
        int sign1 = class_3532.method_17822(AngleHelper.getShortestAngleDiff(offBranchAngle, prevChainPosition));
        int sign2 = class_3532.method_17822(AngleHelper.getShortestAngleDiff(offBranchAngle, chainPosition));
        boolean notCrossed = sign1 >= sign2 && !reversed || sign1 <= sign2 && reversed;
        return !notCrossed;
    }

    private boolean exportToPort(ChainConveyorPackage box, class_2338 offset) {
        class_2338 globalPos = field_11867.method_10081(offset);
        if (!(field_11863.method_8321(globalPos) instanceof FrogportBlockEntity ppbe))
            return false;

        if (ppbe.isAnimationInProgress())
            return false;
        if (ppbe.isBackedUp())
            return false;

        ppbe.startAnimation(box.item, false);
        return true;
    }

    private void notifyPortToAnticipate(class_2338 offset) {
        if (field_11863.method_8321(field_11867.method_10081(offset)) instanceof FrogportBlockEntity ppbe)
            ppbe.sendAnticipate();
    }

    public boolean addTravellingPackage(ChainConveyorPackage box, class_2338 connection) {
        if (!connections.contains(connection))
            return false;
        travellingPackages.computeIfAbsent(connection, $ -> new ArrayList<>()).add(box);
        if (field_11863.method_8608())
            return true;
        notifyUpdate();
        return true;
    }

    @Override
    public void notifyUpdate() {
        field_11863.method_8524(field_11867);
        sendData();
    }

    public boolean addLoopingPackage(ChainConveyorPackage box) {
        loopingPackages.add(box);
        notifyUpdate();
        return true;
    }

    public void prepareStats() {
        float speed = getSpeed();
        if (reversed != speed < 0 && speed != 0) {
            reversed = speed < 0;
            connectionStats = null;
        }
        if (connectionStats == null) {
            connectionStats = new HashMap<>();
            connections.forEach(this::calculateConnectionStats);
        }
    }

    public void updateBoxWorldPositions() {
        prepareStats();

        for (Map.Entry<class_2338, List<ChainConveyorPackage>> entry : travellingPackages.entrySet()) {
            class_2338 target = entry.getKey();
            ConnectionStats stats = connectionStats.get(target);
            if (stats == null)
                continue;
            for (ChainConveyorPackage box : entry.getValue()) {
                box.worldPosition = getPackagePosition(box.chainPosition, target);
                if (field_11863 == null || !field_11863.method_8608())
                    continue;
                class_243 diff = stats.end.method_1020(stats.start).method_1029();
                box.yaw = class_3532.method_15393((float) class_3532.method_15349(diff.field_1352, diff.field_1350) * class_3532.field_29848 - 90);
            }
        }

        for (ChainConveyorPackage box : loopingPackages) {
            box.worldPosition = getPackagePosition(box.chainPosition, null);
            box.yaw = class_3532.method_15393(box.chainPosition);
            if (reversed)
                box.yaw += 180;
        }
    }

    public class_243 getPackagePosition(float chainPosition, @Nullable class_2338 travelTarget) {
        if (travelTarget == null)
            return class_243.method_24955(field_11867).method_1019(VecHelper.rotate(new class_243(0, 6 / 16f, 0.875), chainPosition, class_2351.field_11052));
        prepareStats();
        ConnectionStats stats = connectionStats.get(travelTarget);
        if (stats == null)
            return class_243.field_1353;
        class_243 diff = stats.end.method_1020(stats.start).method_1029();
        return stats.start.method_1019(diff.method_1021(Math.min(stats.chainLength, chainPosition)));
    }

    private void calculateConnectionStats(class_2338 connection) {
        boolean reversed = getSpeed() < 0;
        float offBranchDistance = 35f;
        float direction = class_3532.field_29848 * (float) class_3532.method_15349(connection.method_10263(), connection.method_10260());
        float angle = wrapAngle(direction - offBranchDistance * (reversed ? -1 : 1));
        float oppositeAngle = wrapAngle(angle + 180 + 2 * offBranchDistance * (reversed ? -1 : 1));

        class_243 start = class_243.method_24955(field_11867).method_1019(VecHelper.rotate(new class_243(0, 0, 1.25), angle, class_2351.field_11052)).method_1031(0, 6 / 16f, 0);

        class_243 end = class_243.method_24955(field_11867.method_10081(connection)).method_1019(VecHelper.rotate(new class_243(0, 0, 1.25), oppositeAngle, class_2351.field_11052)).method_1031(0, 6 / 16f, 0);

        float length = (float) start.method_1022(end);
        connectionStats.put(connection, new ConnectionStats(angle, length, start, end));
    }

    public boolean addConnectionTo(class_2338 target) {
        class_2338 localTarget = target.method_10059(field_11867);
        boolean added = connections.add(localTarget);
        if (added) {
            notifyUpdate();
            calculateConnectionStats(localTarget);
            updateChainShapes();
        }

        detachKinetics();
        updateSpeed = true;

        return added;
    }

    public void chainDestroyed(class_2338 target, boolean spawnDrops, boolean sendEffect) {
        int chainCount = getChainCost(target);
        if (sendEffect) {
            chainDestroyedEffectToSend = target;
            sendData();
        }
        if (!spawnDrops)
            return;

        if (!forPointsAlongChains(
            target,
            chainCount,
            vec -> field_11863.method_8649(new class_1542(field_11863, vec.field_1352, vec.field_1351, vec.field_1350, new class_1799(class_1802.field_23983)))
        )) {
            while (chainCount > 0) {
                class_2248.method_9577(field_11863, field_11867, new class_1799(class_2246.field_23985.method_8389(), Math.min(chainCount, 64)));
                chainCount -= 64;
            }
        }
    }

    public boolean removeConnectionTo(class_2338 target) {
        class_2338 localTarget = target.method_10059(field_11867);
        if (!connections.contains(localTarget))
            return false;

        detachKinetics();
        connections.remove(localTarget);
        connectionStats.remove(localTarget);
        List<ChainConveyorPackage> packages = travellingPackages.remove(localTarget);
        if (packages != null)
            for (ChainConveyorPackage box : packages)
                drop(box);
        notifyUpdate();
        updateChainShapes();
        updateSpeed = true;

        return true;
    }

    private void updateChainShapes() {
        prepareStats();
        if (field_11863 != null && field_11863.method_8608()) {
            getBehaviour(ChainConveyorBehaviour.TYPE).updateChainShapes();
        }
    }

    @Override
    public void remove() {
        super.remove();
        if (field_11863 == null || !field_11863.method_8608())
            return;
        for (class_2338 blockPos : connections)
            spawnDestroyParticles(blockPos);
    }

    private void spawnDestroyParticles(class_2338 blockPos) {
        forPointsAlongChains(
            blockPos,
            (int) Math.round(class_243.method_24954(blockPos).method_1033() * 8),
            vec -> field_11863.method_8406(
                new class_2388(class_2398.field_11217, class_2246.field_23985.method_9564()),
                vec.field_1352,
                vec.field_1351,
                vec.field_1350,
                0,
                0,
                0
            )
        );
    }

    @Override
    public void destroy() {
        super.destroy();

        for (class_2338 blockPos : connections) {
            chainDestroyed(blockPos, !cancelDrops, false);
            if (field_11863.method_8321(field_11867.method_10081(blockPos)) instanceof ChainConveyorBlockEntity clbe)
                clbe.removeConnectionTo(field_11867);
        }

        for (ChainConveyorPackage box : loopingPackages)
            drop(box);
        for (Map.Entry<class_2338, List<ChainConveyorPackage>> entry : travellingPackages.entrySet())
            for (ChainConveyorPackage box : entry.getValue())
                drop(box);
    }

    public boolean forPointsAlongChains(class_2338 connection, int positions, Consumer<class_243> callback) {
        prepareStats();
        ConnectionStats stats = connectionStats.get(connection);
        if (stats == null)
            return false;

        class_243 start = stats.start;
        class_243 direction = stats.end.method_1020(start);
        class_243 origin = class_243.method_24953(field_11867);
        class_243 normal = direction.method_1036(new class_243(0, 1, 0)).method_1029();
        class_243 offset = start.method_1020(origin);
        class_243 start2 = origin.method_1019(offset.method_1019(normal.method_1021(-2 * normal.method_1026(offset))));

        for (boolean firstChain : Iterate.trueAndFalse) {
            int steps = positions / 2;
            if (firstChain)
                steps += positions % 2;
            for (int i = 0; i < steps; i++)
                callback.accept((firstChain ? start : start2).method_1019(direction.method_1021((0.5 + i) / steps)));
        }

        return true;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (field_11863 != null && field_11863.method_8608()) {
            getBehaviour(ChainConveyorBehaviour.TYPE).invalidate();
        }
    }

    private void drop(ChainConveyorPackage box) {
        if (box.worldPosition != null)
            field_11863.method_8649(PackageEntity.fromItemStack(field_11863, box.worldPosition.method_1023(0, 0.5, 0), box.item));
    }

    @Override
    public List<class_2338> addPropagationLocations(IRotate block, class_2680 state, List<class_2338> neighbours) {
        connections.forEach(p -> neighbours.add(field_11867.method_10081(p)));
        return super.addPropagationLocations(block, state, neighbours);
    }

    @Override
    public float propagateRotationTo(
        KineticBlockEntity target,
        class_2680 stateFrom,
        class_2680 stateTo,
        class_2338 diff,
        boolean connectedViaAxes,
        boolean connectedViaCogs
    ) {
        if (connections.contains(target.method_11016().method_10059(field_11867))) {
            if (!(target instanceof ChainConveyorBlockEntity))
                return 0;
            return 1;
        }
        return super.propagateRotationTo(target, stateFrom, stateTo, diff, connectedViaAxes, connectedViaCogs);
    }

    @Override
    public void writeSafe(class_11372 view) {
        super.writeSafe(view);
        view.method_71468("Connections", CreateCodecs.BLOCKPOS_SET_CODEC, connections);
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        if (clientPacket && chainDestroyedEffectToSend != null) {
            view.method_71468("DestroyEffect", class_2338.field_25064, chainDestroyedEffectToSend);
            chainDestroyedEffectToSend = null;
        }

        view.method_71468("Connections", CreateCodecs.BLOCKPOS_SET_CODEC, connections);
        view.method_71468("TravellingPackages", clientPacket ? CLIENT_MAP_CODEC : MAP_CODEC, travellingPackages);
        view.method_71468("LoopingPackages", clientPacket ? CLIENT_PACKAGE_CODEC : PACKAGE_CODEC, loopingPackages);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        if (clientPacket) {
            view.method_71426("DestroyEffect", class_2338.field_25064).ifPresent(this::spawnDestroyParticles);
        }

        int sizeBefore = connections.size();
        connections.clear();
        travellingPackages.clear();
        loopingPackages.clear();
        view.method_71426("Connections", CreateCodecs.BLOCKPOS_SET_CODEC).ifPresent(data -> connections.addAll(data));
        view.method_71426("TravellingPackages", CLIENT_MAP_CODEC).ifPresent(map -> travellingPackages.putAll(map));
        view.method_71426("LoopingPackages", CLIENT_PACKAGE_CODEC).ifPresent(list -> loopingPackages.addAll(list));
        connectionStats = null;
        updateBoxWorldPositions();
        updateChainShapes();

        if (connections.size() != sizeBefore && field_11863 != null && field_11863.method_8608())
            invalidateRenderBoundingBox();
    }

    public float wrapAngle(float angle) {
        angle %= 360;
        if (angle < 0)
            angle += 360;
        return angle;
    }

    public static int getChainCost(class_2338 connection) {
        return (int) Math.max(Math.round(class_243.method_24954(connection).method_1033() / 2.5), 1);
    }

    public static boolean getChainsFromInventory(class_1657 player, class_1799 chain, int cost, boolean simulate) {
        int found = 0;

        class_1661 inv = player.method_31548();
        int size = class_1661.field_30638;
        for (int j = 0; j <= size + 1; j++) {
            int i = j;
            boolean offhand = j == size + 1;
            if (j == size)
                i = inv.method_67532();
            else if (offhand)
                i = 0;
            else if (j == inv.method_67532())
                continue;

            class_1799 stackInSlot = offhand ? player.method_5998(class_1268.field_5810) : inv.method_5438(i);
            if (!class_1799.method_7984(stackInSlot, chain))
                continue;
            if (found >= cost)
                continue;

            int count = stackInSlot.method_7947();

            if (!simulate) {
                int remainingItems = count - Math.min(cost - found, count);
                class_1799 newItem = stackInSlot.method_46651(remainingItems);
                if (offhand)
                    player.method_6122(class_1268.field_5810, newItem);
                else
                    inv.method_5447(i, newItem);
            }

            found += count;
        }

        return found >= cost;
    }

    public List<ChainConveyorPackage> getLoopingPackages() {
        return loopingPackages;
    }

    public Map<class_2338, List<ChainConveyorPackage>> getTravellingPackages() {
        return travellingPackages;
    }

    //    @Override
    //    public ItemRequirement getRequiredItems(BlockState state) {
    //        // TODO: Uncomment when Schematicannon is able to print these with chains
    //        //		int totalCost = 0;
    //        //		for (BlockPos pos : connections)
    //        //			totalCost += getChainCost(pos);
    //        //		if (totalCost > 0)
    //        //			return new ItemRequirement(ItemUseType.CONSUME, new ItemStack(Items.CHAIN, Mth.ceil(totalCost / 2.0)));
    //        return super.getRequiredItems(state);
    //    }

    @Override
    public void transform(class_2586 be, StructureTransform transform) {
        if (connections == null || connections.isEmpty())
            return;

        connections = new HashSet<>(connections.stream().map(transform::applyWithoutOffset).toList());

        HashMap<class_2338, List<ChainConveyorPackage>> newMap = new HashMap<>();
        travellingPackages.forEach((key, value) -> newMap.put(transform.applyWithoutOffset(key), value));
        travellingPackages = newMap;

        connectionStats = null;
        notifyUpdate();
    }

}
