package com.zurrtum.create.content.kinetics.crafter;

import com.google.common.base.Predicates;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_1851;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.recipe.*;
import java.util.*;
import java.util.function.Predicate;

import static com.zurrtum.create.content.kinetics.base.HorizontalKineticBlock.HORIZONTAL_FACING;

public class RecipeGridHandler {

    public static List<MechanicalCrafterBlockEntity> getAllCraftersOfChain(MechanicalCrafterBlockEntity root) {
        return getAllCraftersOfChainIf(root, Predicates.alwaysTrue());
    }

    public static List<MechanicalCrafterBlockEntity> getAllCraftersOfChainIf(
        MechanicalCrafterBlockEntity root,
        Predicate<MechanicalCrafterBlockEntity> test
    ) {
        return getAllCraftersOfChainIf(root, test, false);
    }

    public static List<MechanicalCrafterBlockEntity> getAllCraftersOfChainIf(
        MechanicalCrafterBlockEntity root,
        Predicate<MechanicalCrafterBlockEntity> test,
        boolean poweredStart
    ) {
        List<MechanicalCrafterBlockEntity> crafters = new ArrayList<>();
        List<Pair<MechanicalCrafterBlockEntity, MechanicalCrafterBlockEntity>> frontier = new ArrayList<>();
        Set<MechanicalCrafterBlockEntity> visited = new HashSet<>();
        frontier.add(Pair.of(root, null));

        boolean empty = false;
        boolean allEmpty = true;

        while (!frontier.isEmpty()) {
            Pair<MechanicalCrafterBlockEntity, MechanicalCrafterBlockEntity> pair = frontier.removeFirst();
            MechanicalCrafterBlockEntity current = pair.getFirst();
            MechanicalCrafterBlockEntity last = pair.getSecond();

            if (visited.contains(current))
                return null;
            if (!(test.test(current)))
                empty = true;
            else
                allEmpty = false;

            crafters.add(current);
            visited.add(current);

            MechanicalCrafterBlockEntity target = getTargetingCrafter(current);
            if (target != last && target != null)
                frontier.add(Pair.of(target, current));
            for (MechanicalCrafterBlockEntity preceding : getPrecedingCrafters(current))
                if (preceding != last)
                    frontier.add(Pair.of(preceding, current));
        }

        return empty && !poweredStart || allEmpty ? null : crafters;
    }

    public static MechanicalCrafterBlockEntity getTargetingCrafter(MechanicalCrafterBlockEntity crafter) {
        class_2680 state = crafter.method_11010();
        if (!isCrafter(state))
            return null;

        class_2338 targetPos = crafter.method_11016().method_10093(MechanicalCrafterBlock.getTargetDirection(state));
        MechanicalCrafterBlockEntity targetBE = CrafterHelper.getCrafter(crafter.method_10997(), targetPos);
        if (targetBE == null)
            return null;

        class_2680 targetState = targetBE.method_11010();
        if (!isCrafter(targetState))
            return null;
        if (state.method_11654(HORIZONTAL_FACING) != targetState.method_11654(HORIZONTAL_FACING))
            return null;
        return targetBE;
    }

    public static List<MechanicalCrafterBlockEntity> getPrecedingCrafters(MechanicalCrafterBlockEntity crafter) {
        class_2338 pos = crafter.method_11016();
        class_1937 world = crafter.method_10997();
        List<MechanicalCrafterBlockEntity> crafters = new ArrayList<>();
        class_2680 blockState = crafter.method_11010();
        if (!isCrafter(blockState))
            return crafters;

        class_2350 blockFacing = blockState.method_11654(HORIZONTAL_FACING);
        class_2350 blockPointing = MechanicalCrafterBlock.getTargetDirection(blockState);
        for (class_2350 facing : Iterate.directions) {
            if (blockFacing.method_10166() == facing.method_10166())
                continue;
            if (blockPointing == facing)
                continue;

            class_2338 neighbourPos = pos.method_10093(facing);
            class_2680 neighbourState = world.method_8320(neighbourPos);
            if (!isCrafter(neighbourState))
                continue;
            if (MechanicalCrafterBlock.getTargetDirection(neighbourState) != facing.method_10153())
                continue;
            if (blockFacing != neighbourState.method_11654(HORIZONTAL_FACING))
                continue;
            MechanicalCrafterBlockEntity be = CrafterHelper.getCrafter(world, neighbourPos);
            if (be == null)
                continue;

            crafters.add(be);
        }

        return crafters;
    }

    private static boolean isCrafter(class_2680 state) {
        return state.method_27852(AllBlocks.MECHANICAL_CRAFTER);
    }

    public static class_1799 tryToApplyRecipe(class_3218 world, GroupedItems items) {
        items.calcStats();
        class_9694 craftingInput = items.toCraftingInput();
        class_1799 result = null;
        class_5455 registryAccess = world.method_30349();
        class_1863 recipeManager = world.method_64577();
        if (AllConfigs.server().recipes.allowRegularCraftingInCrafter.get()) {
            result = recipeManager.field_54638.method_64699(class_3956.field_17545, craftingInput, world).filter(r -> isRecipeAllowed(r, craftingInput))
                .findFirst().map(r -> r.comp_1933().method_8116(craftingInput, registryAccess)).orElse(null);
        }
        if (result == null)
            result = recipeManager.method_8132(AllRecipeTypes.MECHANICAL_CRAFTING, craftingInput, world)
                .map(r -> r.comp_1933().craft(craftingInput, registryAccess)).orElse(null);
        return result;
    }

    public static boolean isRecipeAllowed(class_8786<class_3955> recipe, class_9694 craftingInput) {
        if (recipe.comp_1933() instanceof class_1851) {
            int numItems = 0;
            for (int i = 0; i < craftingInput.method_59983(); i++) {
                if (!craftingInput.method_59984(i).method_7960()) {
                    numItems++;
                }
            }
            if (numItems > AllConfigs.server().recipes.maxFireworkIngredientsInCrafter.get()) {
                return false;
            }
        }
        return !AllRecipeTypes.shouldIgnoreInAutomation(recipe);
    }

    public static class GroupedItems {
        public static final Codec<Map<Pair<Integer, Integer>, class_1799>> GRID_CODEC = CreateCodecs.getCodecMap(
            Pair.codec(Codec.INT, Codec.INT),
            class_1799.field_49266
        );
        public static final Codec<GroupedItems> CODEC = RecordCodecBuilder.create(instance -> instance.group(GRID_CODEC.fieldOf("Grid")
            .forGetter(i -> i.grid)).apply(instance, GroupedItems::new));
        public Map<Pair<Integer, Integer>, class_1799> grid = new HashMap<>();
        public int minX;
        public int minY;
        int maxX;
        int maxY;
        public int width;
        public int height;
        boolean statsReady;

        public GroupedItems() {
        }

        public GroupedItems(class_1799 stack) {
            grid.put(Pair.of(0, 0), stack);
        }

        public GroupedItems(Map<Pair<Integer, Integer>, class_1799> grid) {
            this.grid.putAll(grid);
        }

        public void mergeOnto(GroupedItems other, Pointing pointing) {
            int xOffset = pointing == Pointing.LEFT ? 1 : pointing == Pointing.RIGHT ? -1 : 0;
            int yOffset = pointing == Pointing.DOWN ? 1 : pointing == Pointing.UP ? -1 : 0;
            grid.forEach((pair, stack) -> other.grid.put(Pair.of(pair.getFirst() + xOffset, pair.getSecond() + yOffset), stack));
            other.statsReady = false;
        }

        public void write(class_11372 view) {
            class_11372.class_11374 list = view.method_71476("Grid");
            grid.forEach((pair, stack) -> {
                class_11372 entry = list.method_71480();
                entry.method_71465("x", pair.getFirst());
                entry.method_71465("y", pair.getSecond());
                entry.method_71468("item", class_1799.field_49266, stack);
            });
        }

        public static GroupedItems read(class_11368 view) {
            GroupedItems items = new GroupedItems();
            class_11368.class_11370 list = view.method_71438("Grid");
            list.forEach(entry -> {
                int x = entry.method_71424("x", 0);
                int y = entry.method_71424("y", 0);
                class_1799 stack = entry.method_71426("item", class_1799.field_49266).orElse(class_1799.field_8037);
                items.grid.put(Pair.of(x, y), stack);
            });
            return items;
        }

        public void calcStats() {
            if (statsReady)
                return;
            statsReady = true;

            minX = 0;
            minY = 0;
            maxX = 0;
            maxY = 0;

            for (Pair<Integer, Integer> pair : grid.keySet()) {
                int x = pair.getFirst();
                int y = pair.getSecond();
                minX = Math.min(minX, x);
                minY = Math.min(minY, y);
                maxX = Math.max(maxX, x);
                maxY = Math.max(maxY, y);
            }

            width = maxX - minX + 1;
            height = maxY - minY + 1;
        }

        public boolean onlyEmptyItems() {
            for (class_1799 stack : grid.values())
                if (!stack.method_7960())
                    return false;
            return true;
        }

        public class_9694 toCraftingInput() {
            List<class_1799> list = new ArrayList<>(width * height);
            int minX = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxY = Integer.MIN_VALUE;

            for (int y = 0; y < height; y++) {
                for (int x = 0; x < width; x++) {
                    int xp = x + this.minX;
                    int yp = y + this.minY;
                    class_1799 stack = grid.get(Pair.of(xp, yp));
                    if (stack == null || stack.method_7960())
                        continue;
                    minX = Math.min(minX, xp);
                    maxX = Math.max(maxX, xp);
                    minY = Math.min(minY, yp);
                    maxY = Math.max(maxY, yp);
                }
            }

            int w = maxX - minX + 1;
            int h = maxY - minY + 1;

            for (int y = 0; y < h; y++) {
                for (int x = 0; x < w; x++) {
                    class_1799 stack = grid.get(Pair.of(x + minX, maxY - y));
                    list.add(stack == null ? class_1799.field_8037 : stack.method_7972());
                }
            }

            return new class_9694(w, h, list);
        }
    }

}
