package com.zurrtum.create.content.kinetics.deployer;

import com.zurrtum.create.infrastructure.items.SidedItemInventory;
import com.zurrtum.create.infrastructure.transfer.SlotRangeCache;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;

public class DeployerItemHandler implements SidedItemInventory {
    private final DeployerBlockEntity be;
    private final DeployerPlayer player;

    public DeployerItemHandler(DeployerBlockEntity be) {
        this.be = be;
        this.player = be.player;
    }

    @Override
    public int[] method_5494(class_2350 side) {
        return SlotRangeCache.get(be.overflowItems.size() + 1);
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        if (slot != 0 || player == null) {
            return false;
        }
        if (be.filtering.getFilter().method_7960()) {
            return true;
        }
        return be.filtering.test(stack);
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        if (slot != 0) {
            return true;
        }
        if (player == null) {
            return false;
        }
        if (be.filtering.getFilter().method_7960()) {
            return true;
        }
        return !be.filtering.test(player.cast().method_6047());
    }

    @Override
    public int method_5439() {
        return 1 + be.overflowItems.size();
    }

    @Override
    public class_1799 method_5438(int slot) {
        int size = be.overflowItems.size();
        if (slot > size) {
            return class_1799.field_8037;
        }
        if (slot == 0) {
            return player == null ? class_1799.field_8037 : player.cast().method_6047();
        }
        return be.overflowItems.get(slot - 1);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        int size = be.overflowItems.size();
        if (slot > size) {
            return;
        }
        if (slot == 0) {
            player.cast().method_6122(class_1268.field_5808, stack);
        } else {
            be.overflowItems.set(slot - 1, stack);
        }
    }

    @Override
    public void method_5431() {
        be.overflowItems.removeIf(class_1799::method_7960);
        be.notifyUpdate();
    }
}
