package com.zurrtum.create.content.kinetics.mechanicalArm;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.catnip.nbt.NBTHelper;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.foundation.item.ItemHelper;
import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.Nullable;

import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_9139;

public class ArmInteractionPoint {
    public static Codec<ArmInteractionPoint> getCodec(class_1937 world, class_2338 anchor) {
        return RecordCodecBuilder.create(instance -> instance.group(
            CreateRegistries.ARM_INTERACTION_POINT_TYPE.method_39673().fieldOf("Type").forGetter(ArmInteractionPoint::getType),
            class_2338.field_25064.fieldOf("Pos").forGetter(point -> point.pos.method_10059(anchor)),
            Mode.CODEC.fieldOf("Mode").forGetter(ArmInteractionPoint::getMode)
        ).apply(
            instance, (type, pos, mode) -> {
                pos = pos.method_10081(anchor);
                class_2680 state = world.method_8320(pos);
                if (!type.canCreatePoint(world, pos, state))
                    return null;
                ArmInteractionPoint point = type.createPoint(world, pos, state);
                if (point == null)
                    return null;
                point.mode = mode;
                return point;
            }
        ));
    }

    protected final ArmInteractionPointType type;
    protected class_1937 level;
    protected class_2338 pos;
    protected Mode mode = Mode.DEPOSIT;

    protected class_2680 cachedState;
    protected Supplier<class_1263> cachedHandler;
    protected ArmAngleTarget cachedAngles;

    public ArmInteractionPoint(ArmInteractionPointType type, class_1937 level, class_2338 pos, class_2680 state) {
        this.type = type;
        this.level = level;
        this.pos = pos;
        this.cachedState = state;
    }

    public ArmInteractionPointType getType() {
        return type;
    }

    public class_1937 getLevel() {
        return level;
    }

    public void setLevel(class_1937 level) {
        this.level = level;
    }

    public class_2338 getPos() {
        return pos;
    }

    public void relativePos(class_2338 pos) {
        this.pos = this.pos.method_10059(pos);
    }

    public void absolutePos(class_2338 pos) {
        this.pos = this.pos.method_10081(pos);
    }

    public Mode getMode() {
        return mode;
    }

    public void cycleMode() {
        mode = mode == Mode.DEPOSIT ? Mode.TAKE : Mode.DEPOSIT;
    }

    protected class_243 getInteractionPositionVector() {
        return VecHelper.getCenterOf(pos);
    }

    protected class_2350 getInteractionDirection() {
        return class_2350.field_11033;
    }

    public ArmAngleTarget getTargetAngles(class_2338 armPos, boolean ceiling) {
        if (cachedAngles == null)
            cachedAngles = new ArmAngleTarget(armPos, getInteractionPositionVector(), getInteractionDirection(), ceiling);

        return cachedAngles;
    }

    public void updateCachedState() {
        cachedState = level.method_8320(pos);
    }

    public boolean isValid() {
        updateCachedState();
        return type.canCreatePoint(level, pos, cachedState);
    }

    public void keepAlive() {
    }

    @Nullable
    protected class_1263 getHandler(ArmBlockEntity armBlockEntity) {
        if (cachedHandler == null && level instanceof class_3218 serverLevel) {
            class_2586 be = level.method_8321(pos);
            if (be == null)
                return null;
            cachedHandler = ItemHelper.getInventoryCache(serverLevel, pos, class_2350.field_11036, (blockEntity, direction) -> !armBlockEntity.method_11015());
        }
        return cachedHandler.get();
    }

    public class_1799 insert(ArmBlockEntity armBlockEntity, class_1799 stack, boolean simulate) {
        class_1263 handler = getHandler(armBlockEntity);
        if (handler == null)
            return stack;
        int insert;
        if (simulate) {
            insert = handler.countSpace(stack, class_2350.field_11036);
        } else {
            insert = handler.insert(stack, class_2350.field_11036);
        }
        if (insert == 0) {
            return stack;
        }
        int count = stack.method_7947();
        if (insert == count) {
            return class_1799.field_8037;
        }
        return stack.method_46651(count - insert);
    }

    public class_1799 extract(ArmBlockEntity armBlockEntity, int slot, int amount, boolean simulate) {
        class_1263 handler = getHandler(armBlockEntity);
        if (handler == null)
            return class_1799.field_8037;
        if (simulate) {
            return handler.count(stack -> true, amount, class_2350.field_11036);
        }
        return handler.extract(stack -> true, amount, class_2350.field_11036);
    }

    public class_1799 extract(ArmBlockEntity armBlockEntity, int slot, boolean simulate) {
        return extract(armBlockEntity, slot, 64, simulate);
    }

    public int getSlotCount(ArmBlockEntity armBlockEntity) {
        class_1263 handler = getHandler(armBlockEntity);
        if (handler == null)
            return 0;
        return handler.method_5439();
    }

    protected void serialize(class_2487 nbt, class_2338 anchor) {
        NBTHelper.writeEnum(nbt, "Mode", mode);
    }

    protected void deserialize(class_2487 nbt, class_2338 anchor) {
        mode = NBTHelper.readEnum(nbt, "Mode", Mode.class);
    }

    public final class_2487 serialize(class_2338 anchor) {
        class_2960 key = CreateRegistries.ARM_INTERACTION_POINT_TYPE.method_10221(type);
        if (key == null)
            throw new IllegalArgumentException("Could not get id for ArmInteractionPointType " + type + "!");

        class_2487 nbt = new class_2487();
        nbt.method_10582("Type", key.toString());
        nbt.method_67494("Pos", class_2338.field_25064, pos.method_10059(anchor));
        serialize(nbt, anchor);
        return nbt;
    }

    @Nullable
    public static ArmInteractionPoint deserialize(class_2487 nbt, class_1937 level, class_2338 anchor) {
        class_2960 id = class_2960.method_12829(nbt.method_68564("Type", ""));
        if (id == null)
            return null;
        ArmInteractionPointType type = CreateRegistries.ARM_INTERACTION_POINT_TYPE.method_63535(id);
        if (type == null)
            return null;
        class_2338 pos = NBTHelper.readBlockPos(nbt, "Pos").method_10081(anchor);
        class_2680 state = level.method_8320(pos);
        if (!type.canCreatePoint(level, pos, state))
            return null;
        ArmInteractionPoint point = type.createPoint(level, pos, state);
        if (point == null)
            return null;
        point.deserialize(nbt, anchor);
        return point;
    }

    public static void transformPos(class_2487 nbt, StructureTransform transform) {
        class_2338 pos = nbt.method_67491("Pos", class_2338.field_25064).orElse(class_2338.field_10980);
        pos = transform.applyWithoutOffset(pos);
        nbt.method_67494("Pos", class_2338.field_25064, pos);
    }

    public static boolean isInteractable(class_1937 level, class_2338 pos, class_2680 state) {
        return ArmInteractionPointType.getPrimaryType(level, pos, state) != null;
    }

    @Nullable
    public static ArmInteractionPoint create(class_1937 level, class_2338 pos, class_2680 state) {
        ArmInteractionPointType type = ArmInteractionPointType.getPrimaryType(level, pos, state);
        if (type == null)
            return null;
        return type.createPoint(level, pos, state);
    }

    public enum Mode implements class_3542 {
        DEPOSIT("create.mechanical_arm.deposit_to", 0xDDC166),
        TAKE("create.mechanical_arm.extract_from", 0x7FCDE0);

        public static final Codec<Mode> CODEC = class_3542.method_28140(Mode::values);
        public static final class_9139<ByteBuf, Mode> PACKET_CODEC = CatnipStreamCodecBuilders.ofEnum(Mode.class);
        private final String translationKey;
        private final int color;

        Mode(String translationKey, int color) {
            this.translationKey = translationKey;
            this.color = color;
        }

        @Override
        public String method_15434() {
            return name().toLowerCase(Locale.ROOT);
        }

        public String getTranslationKey() {
            return translationKey;
        }

        public int getColor() {
            return color;
        }
    }

}
