package com.zurrtum.create.content.kinetics.millstone;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.items.SidedItemInventory;
import com.zurrtum.create.infrastructure.transfer.SlotRangeCache;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2371;
import net.minecraft.class_2392;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_8786;
import net.minecraft.class_9696;

public class MillstoneBlockEntity extends KineticBlockEntity {
    public MillstoneInventoryHandler capability;
    public int timer;
    private MillingRecipe lastRecipe;

    public MillstoneBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.MILLSTONE, pos, state);
        capability = new MillstoneInventoryHandler();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this));
        super.addBehaviours(behaviours);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.MILLSTONE);
    }

    @Override
    public void tick() {
        super.tick();

        if (getSpeed() == 0)
            return;
        for (int i = 1, size = capability.method_5439(); i < size; i++) {
            class_1799 stack = capability.method_5438(i);
            if (stack.method_7947() == capability.method_58350(stack)) {
                return;
            }
        }

        if (timer > 0) {
            timer -= getProcessingSpeed();

            if (field_11863.method_8608()) {
                spawnParticles();
                return;
            }
            if (timer <= 0)
                process();
            return;
        } else if (field_11863.method_8608()) {
            return;
        }

        class_1799 stack = capability.method_5438(0);
        if (stack.method_7960())
            return;

        class_9696 input = new class_9696(stack);
        if (lastRecipe == null || !lastRecipe.matches(input, field_11863)) {
            Optional<class_8786<MillingRecipe>> recipe = ((class_3218) field_11863).method_64577()
                .method_8132(AllRecipeTypes.MILLING, input, field_11863);
            if (recipe.isEmpty()) {
                timer = 100;
                sendData();
            } else {
                lastRecipe = recipe.get().comp_1933();
                timer = lastRecipe.time();
                sendData();
            }
            return;
        }

        timer = lastRecipe.time();
        sendData();
    }

    @Override
    public void destroy() {
        super.destroy();
        class_1264.method_5451(field_11863, field_11867, capability);
    }

    private void process() {
        class_1799 stack = capability.method_5438(0);
        class_9696 input = new class_9696(stack);

        if (lastRecipe == null || !lastRecipe.matches(input, field_11863)) {
            Optional<class_8786<MillingRecipe>> recipe = ((class_3218) field_11863).method_64577()
                .method_8132(AllRecipeTypes.MILLING, input, field_11863);
            if (recipe.isEmpty())
                return;
            lastRecipe = recipe.get().comp_1933();
        }

        class_1799 recipeRemainder = stack.method_7909().method_7858();
        stack.method_7934(1);
        capability.method_5447(0, stack);
        capability.outputAllowInsertion();
        List<class_1799> list = lastRecipe.craft(input, field_11863.field_9229);
        if (!recipeRemainder.method_7960()) {
            list.add(recipeRemainder);
        }
        capability.insert(list);
        capability.outputForbidInsertion();

        award(AllAdvancements.MILLSTONE);

        sendData();
        method_5431();
    }

    public void spawnParticles() {
        class_1799 stackInSlot = capability.method_5438(0);
        if (stackInSlot.method_7960())
            return;

        class_2392 data = new class_2392(class_2398.field_11218, stackInSlot);
        float angle = field_11863.field_9229.method_43057() * 360;
        class_243 offset = new class_243(0, 0, 0.5f);
        offset = VecHelper.rotate(offset, angle, class_2351.field_11052);
        class_243 target = VecHelper.rotate(offset, getSpeed() > 0 ? 25 : -25, class_2351.field_11052);

        class_243 center = offset.method_1019(VecHelper.getCenterOf(field_11867));
        target = VecHelper.offsetRandomly(target.method_1020(offset), field_11863.field_9229, 1 / 128f);
        field_11863.method_8406(data, center.field_1352, center.field_1351, center.field_1350, target.field_1352, target.field_1351, target.field_1350);
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71465("Timer", timer);
        capability.write(view);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        timer = view.method_71424("Timer", 0);
        capability.read(view);
        super.read(view, clientPacket);
    }

    public int getProcessingSpeed() {
        return class_3532.method_15340((int) Math.abs(getSpeed() / 16f), 1, 512);
    }

    private boolean canProcess(class_1799 stack) {
        class_9696 input = new class_9696(stack);
        if (lastRecipe != null && lastRecipe.matches(input, field_11863))
            return true;
        Optional<class_8786<MillingRecipe>> recipe = ((class_3218) field_11863).method_64577().method_8132(AllRecipeTypes.MILLING, input, field_11863);
        if (recipe.isEmpty()) {
            return false;
        }
        lastRecipe = recipe.get().comp_1933();
        return true;
    }

    public class MillstoneInventoryHandler implements SidedItemInventory {
        private static final int[] SLOTS = SlotRangeCache.get(10);
        private final class_2371<class_1799> stacks = class_2371.method_10213(10, class_1799.field_8037);
        private boolean check = true;

        public void outputAllowInsertion() {
            check = false;
        }

        public void outputForbidInsertion() {
            check = true;
        }

        @Override
        public int method_5439() {
            return 10;
        }

        @Override
        public int[] method_5494(class_2350 side) {
            return SLOTS;
        }

        @Override
        public boolean method_5437(int slot, class_1799 stack) {
            return !check || canProcess(stack);
        }

        @Override
        public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
            return check ? slot == 0 : slot > 0;
        }

        @Override
        public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
            return slot != 0;
        }

        @Override
        public class_1799 method_5438(int slot) {
            if (slot >= 10) {
                return class_1799.field_8037;
            }
            return stacks.get(slot);
        }

        @Override
        public void method_5447(int slot, class_1799 stack) {
            if (slot >= 10) {
                return;
            }
            stacks.set(slot, stack);
        }

        @Override
        public void method_5431() {
            MillstoneBlockEntity.this.method_5431();
        }

        public void write(class_11372 view) {
            class_11372.class_11373<class_1799> list = view.method_71467("Inventory", class_1799.field_49266);
            list.method_71484(stacks.getFirst());
            for (int i = 1; i < 10; i++) {
                class_1799 stack = stacks.get(i);
                if (stack.method_7960()) {
                    continue;
                }
                list.method_71484(stack);
            }
        }

        public void read(class_11368 view) {
            List<class_1799> list = view.method_71437("Inventory", class_1799.field_49266).method_71456().toList();
            int i = 0;
            for (class_1799 itemStack : list) {
                stacks.set(i++, itemStack);
            }
            for (; i < 10; i++) {
                method_5447(i, class_1799.field_8037);
            }
        }
    }

}
