package com.zurrtum.create.content.logistics;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class BigItemStack {
    public static final Codec<BigItemStack> CODEC = RecordCodecBuilder.create(i -> i.group(
        class_1799.field_49266.fieldOf("item_stack")
            .forGetter(s -> s.stack), class_5699.field_33441.fieldOf("count").forGetter(s -> s.count)
    ).apply(i, BigItemStack::new));

    public static final class_9139<class_9129, BigItemStack> STREAM_CODEC = class_9139.method_56435(
        class_1799.field_49268,
        s -> s.stack,
        class_9135.field_48550,
        s -> s.count,
        BigItemStack::new
    );

    public static final int INF = 1_000_000_000;

    public class_1799 stack;
    public int count;

    public BigItemStack(class_1799 stack) {
        this(stack, 1);
    }

    public BigItemStack(class_1799 stack, int count) {
        this.stack = stack;
        this.count = count;
    }

    public boolean isInfinite() {
        return count >= INF;
    }

    public static BigItemStack receive(class_9129 buffer) {
        return new BigItemStack(class_1799.field_48349.decode(buffer), buffer.method_10816());
    }

    public static Comparator<? super BigItemStack> comparator() {
        return (i1, i2) -> Integer.compare(i2.count, i1.count);
    }

    @Override
    public boolean equals(final Object obj) {
        if (obj == this)
            return true;
        if (obj instanceof BigItemStack other)
            return class_1799.method_31577(stack, other.stack) && count == other.count;
        return false;
    }

    @Override
    public int hashCode() {
        return (nullHash(stack) * 31) ^ Integer.hashCode(count);
    }

    int nullHash(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    @Override
    public String toString() {
        return "(" + stack.method_7964().getString() + " x" + count + ")";
    }

    public static List<BigItemStack> duplicateWrappers(List<BigItemStack> list) {
        List<BigItemStack> copy = new ArrayList<>();
        for (BigItemStack bigItemStack : list)
            copy.add(new BigItemStack(bigItemStack.stack, bigItemStack.count));
        return copy;
    }
}
