package com.zurrtum.create.content.logistics.depot;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.logistics.box.PackageEntity;
import com.zurrtum.create.content.logistics.funnel.AbstractFunnelBlock;
import com.zurrtum.create.content.logistics.funnel.FunnelBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollValueBehaviour;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.packet.c2s.EjectorAwardPacket;
import com.zurrtum.create.infrastructure.packet.c2s.EjectorElytraPacket;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239.class_240;
import net.minecraft.class_2426;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3959.class_242;
import net.minecraft.class_3959.class_3960;
import net.minecraft.class_3965;
import net.minecraft.util.math.*;
import org.jetbrains.annotations.Nullable;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class EjectorBlockEntity extends KineticBlockEntity {

    ServerScrollValueBehaviour maxStackSize;
    public DepotBehaviour depotBehaviour;
    public EntityLauncher launcher;
    LerpedFloat lidProgress;
    boolean powered;
    boolean launch;
    State state;

    // item collision
    @Nullable
    public Pair<class_243, class_2338> earlyTarget;
    public float earlyTargetTime;
    // runtime stuff
    int scanCooldown;
    class_1799 trackedItem;

    public enum State implements class_3542 {
        CHARGED,
        LAUNCHING,
        RETRACTING;

        public static final Codec<State> CODEC = class_3542.method_28140(State::values);

        @Override
        public String method_15434() {
            return name().toLowerCase(Locale.ROOT);
        }
    }

    public EjectorBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.WEIGHTED_EJECTOR, pos, state);
        launcher = new EntityLauncher(1, 0);
        lidProgress = LerpedFloat.linear().startWithValue(1);
        this.state = State.RETRACTING;
        powered = false;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        behaviours.add(depotBehaviour = new DepotBehaviour(this));

        maxStackSize = new ServerScrollValueBehaviour(this).between(0, 64);
        behaviours.add(maxStackSize);

        depotBehaviour.maxStackSize = () -> maxStackSize.getValue();
        depotBehaviour.canAcceptItems = () -> state == State.CHARGED;
        depotBehaviour.canFunnelsPullFrom = side -> side != getFacing();
        depotBehaviour.enableMerging();
        depotBehaviour.addSubBehaviours(behaviours);
    }

    @Override
    public void initialize() {
        super.initialize();
        updateSignal();
    }

    public void activate() {
        launch = true;
        nudgeEntities();
    }

    protected boolean cannotLaunch() {
        return state != State.CHARGED && !(field_11863.method_8608() && state == State.LAUNCHING);
    }

    public void activateDeferred() {
        if (cannotLaunch())
            return;
        class_2350 facing = getFacing();
        List<class_1297> entities = field_11863.method_18467(class_1297.class, new class_238(field_11867).method_1009(-1 / 16f, 0, -1 / 16f));

        // Launch Items
        boolean doLogic = !field_11863.method_8608() || isVirtual();
        if (doLogic)
            launchItems();

        // Launch Entities
        for (class_1297 entity : entities) {
            boolean isPlayerEntity = entity instanceof class_1657;
            if (!entity.method_5805())
                continue;
            if (entity instanceof class_1542)
                continue;
            if (entity instanceof PackageEntity)
                continue;
            if (entity.method_5657() == class_3619.field_15975)
                continue;

            entity.method_24830(false);

            if (isPlayerEntity != field_11863.method_8608())
                continue;

            entity.method_5814(field_11867.method_10263() + .5f, field_11867.method_10264() + 1, field_11867.method_10260() + .5f);
            launcher.applyMotion(entity, facing);

            if (!isPlayerEntity)
                continue;

            class_1657 playerEntity = (class_1657) entity;

            if (launcher.getHorizontalDistance() * launcher.getHorizontalDistance() + launcher.getVerticalDistance() * launcher.getVerticalDistance() >= 25 * 25)
                AllClientHandle.INSTANCE.sendPacket(new EjectorAwardPacket(field_11867));

            if (!(playerEntity.method_6118(class_1304.field_6174).method_7909() == class_1802.field_8833))
                continue;

            playerEntity.method_36457(-35);
            playerEntity.method_36456(facing.method_10144());
            playerEntity.method_18799(playerEntity.method_18798().method_1021(.75f));
            deployElytra(playerEntity);
            AllClientHandle.INSTANCE.sendPacket(new EjectorElytraPacket(field_11867));
        }

        if (doLogic) {
            lidProgress.chase(1, .8f, Chaser.EXP);
            state = State.LAUNCHING;
            if (!field_11863.method_8608()) {
                field_11863.method_8396(null, field_11867, class_3417.field_15080, class_3419.field_15245, .35f, 1f);
                field_11863.method_8396(null, field_11867, class_3417.field_14982, class_3419.field_15245, .1f, 1.4f);
            }
        }
    }

    public void deployElytra(class_1657 playerEntity) {
        EntityHack.setElytraFlying(playerEntity);
    }

    protected void launchItems() {
        class_1799 heldItemStack = depotBehaviour.getHeldItemStack();
        class_2350 funnelFacing = getFacing().method_10153();

        if (AbstractFunnelBlock.getFunnelFacing(field_11863.method_8320(field_11867.method_10084())) == funnelFacing) {
            DirectBeltInputBehaviour directOutput = getBehaviour(DirectBeltInputBehaviour.TYPE);

            if (depotBehaviour.heldItem != null) {
                class_1799 remainder = directOutput.tryExportingToBeltFunnel(heldItemStack, funnelFacing, false);
                if (remainder == null)
                    ;
                else if (remainder.method_7960())
                    depotBehaviour.removeHeldItem();
                else if (remainder.method_7947() != heldItemStack.method_7947())
                    depotBehaviour.heldItem.stack = remainder;
            }

            for (Iterator<TransportedItemStack> iterator = depotBehaviour.incoming.iterator(); iterator.hasNext(); ) {
                TransportedItemStack transportedItemStack = iterator.next();
                class_1799 stack = transportedItemStack.stack;
                class_1799 remainder = directOutput.tryExportingToBeltFunnel(stack, funnelFacing, false);
                if (remainder == null)
                    ;
                else if (remainder.method_7960())
                    iterator.remove();
                else if (!class_1799.method_7984(remainder, stack))
                    transportedItemStack.stack = remainder;
            }

            boolean change = false;
            class_1263 outputs = depotBehaviour.processingOutputBuffer;
            for (int i = 0, size = outputs.method_5439(); i < size; i++) {
                class_1799 remainder = directOutput.tryExportingToBeltFunnel(outputs.method_5438(i), funnelFacing, false);
                if (remainder != null) {
                    outputs.method_5447(i, remainder);
                    change = true;
                }
            }
            if (change) {
                outputs.method_5431();
            }
            return;
        }

        if (!field_11863.method_8608())
            for (class_2350 d : Iterate.directions) {
                class_2680 blockState = field_11863.method_8320(field_11867.method_10093(d));
                if (!(blockState.method_26204() instanceof class_2426))
                    continue;
                if (blockState.method_11654(class_2426.field_10927) != d.method_10153())
                    continue;
                blockState.method_26191(field_11863, field_11863, field_11867.method_10093(d), d.method_10153(), field_11867, blockState, field_11863.field_9229);
            }

        if (depotBehaviour.heldItem != null) {
            addToLaunchedItems(heldItemStack);
            depotBehaviour.removeHeldItem();
        }

        for (TransportedItemStack transportedItemStack : depotBehaviour.incoming)
            addToLaunchedItems(transportedItemStack.stack);
        depotBehaviour.incoming.clear();

        boolean change = false;
        class_1263 outputs = depotBehaviour.processingOutputBuffer;
        for (int i = 0, size = outputs.method_5439(); i < size; i++) {
            class_1799 stack = outputs.method_5438(i);
            if (stack.method_7960()) {
                continue;
            }
            addToLaunchedItems(stack);
            outputs.method_5447(i, class_1799.field_8037);
            change = true;
        }
        if (change) {
            outputs.method_5431();
        }
    }

    protected void addToLaunchedItems(class_1799 stack) {
        if ((!field_11863.method_8608() || isVirtual()) && trackedItem == null && scanCooldown == 0) {
            scanCooldown = AllConfigs.server().kinetics.ejectorScanInterval.get();
            trackedItem = stack;
        }
        EjectorItemEntity item = new EjectorItemEntity(field_11863, this, stack);
        field_11863.method_8649(item);
    }

    public class_2350 getFacing() {
        class_2680 blockState = method_11010();
        if (!blockState.method_27852(AllBlocks.WEIGHTED_EJECTOR))
            return class_2350.field_11036;
        class_2350 facing = blockState.method_11654(EjectorBlock.HORIZONTAL_FACING);
        return facing;
    }

    @Override
    public void tick() {
        super.tick();

        boolean doLogic = !field_11863.method_8608() || isVirtual();
        State prevState = state;

        if (scanCooldown > 0)
            scanCooldown--;

        if (launch) {
            launch = false;
            activateDeferred();
        }

        if (state == State.LAUNCHING) {
            lidProgress.chase(1, .8f, Chaser.EXP);
            lidProgress.tickChaser();
            if (lidProgress.getValue() > 1 - 1 / 16f && doLogic) {
                state = State.RETRACTING;
                lidProgress.setValue(1);
            }
        }

        if (state == State.CHARGED) {
            lidProgress.setValue(0);
            lidProgress.updateChaseSpeed(0);
            if (doLogic)
                ejectIfTriggered();
        }

        if (state == State.RETRACTING) {
            if (lidProgress.getChaseTarget() == 1 && !lidProgress.settled()) {
                lidProgress.tickChaser();
            } else {
                lidProgress.updateChaseTarget(0);
                lidProgress.updateChaseSpeed(0);
                if (lidProgress.getValue() == 0 && doLogic) {
                    state = State.CHARGED;
                    lidProgress.setValue(0);
                    sendData();
                }

                float value = class_3532.method_15363(lidProgress.getValue() - getWindUpSpeed(), 0, 1);
                lidProgress.setValue(value);

                int soundRate = (int) (1 / (getWindUpSpeed() * 5)) + 1;
                float volume = .125f;
                float pitch = 1.5f - lidProgress.getValue();
                if (((int) field_11863.method_8510()) % soundRate == 0 && doLogic)
                    field_11863.method_8396(null, field_11867, class_3417.field_15105, class_3419.field_15245, volume, pitch);
            }
        }

        if (state != prevState)
            notifyUpdate();
    }

    private boolean scanTrajectoryForObstacles(int time) {
        if (time <= 2)
            return false;

        class_243 source = getLaunchedItemLocation(time);
        class_243 target = getLaunchedItemLocation(time + 1);

        class_3965 rayTraceBlocks = field_11863.method_17742(new class_3959(
            source,
            target,
            class_3960.field_17558,
            class_242.field_1348,
            class_3726.method_16194()
        ));
        boolean miss = rayTraceBlocks.method_17783() == class_240.field_1333;

        if (!miss && rayTraceBlocks.method_17783() == class_240.field_1332) {
            class_2680 blockState = field_11863.method_8320(rayTraceBlocks.method_17777());
            if (FunnelBlock.isFunnel(blockState) && blockState.method_28498(FunnelBlock.EXTRACTING) && blockState.method_11654(FunnelBlock.EXTRACTING))
                miss = true;
        }

        if (miss) {
            if (earlyTarget != null && earlyTargetTime < time + 1) {
                earlyTarget = null;
                earlyTargetTime = 0;
            }
            return false;
        }

        class_243 vec = rayTraceBlocks.method_17784();
        earlyTarget = Pair.of(vec.method_1019(class_243.method_24954(rayTraceBlocks.method_17780().method_62675()).method_1021(.25f)), rayTraceBlocks.method_17777());
        earlyTargetTime = (float) (time + (source.method_1022(vec) / source.method_1022(target)));
        sendData();
        return true;
    }

    protected void nudgeEntities() {
        for (class_1297 entity : field_11863.method_18467(class_1297.class, new class_238(field_11867).method_1009(-1 / 16f, 0, -1 / 16f))) {
            if (!entity.method_5805())
                continue;
            if (entity.method_5657() == class_3619.field_15975)
                continue;
            if (!(entity instanceof class_1657))
                entity.method_5814(entity.method_23317(), entity.method_23318() + .125f, entity.method_23321());
        }
    }

    protected void ejectIfTriggered() {
        if (powered)
            return;
        int presentStackSize = depotBehaviour.getPresentStackSize();
        if (presentStackSize == 0)
            return;
        if (presentStackSize < maxStackSize.getValue())
            return;
        if (depotBehaviour.heldItem != null && depotBehaviour.heldItem.beltPosition < .49f)
            return;

        class_2350 funnelFacing = getFacing().method_10153();
        class_1799 held = depotBehaviour.getHeldItemStack();
        if (AbstractFunnelBlock.getFunnelFacing(field_11863.method_8320(field_11867.method_10084())) == funnelFacing) {
            DirectBeltInputBehaviour directOutput = getBehaviour(DirectBeltInputBehaviour.TYPE);
            if (depotBehaviour.heldItem != null) {
                class_1799 tryFunnel = directOutput.tryExportingToBeltFunnel(held, funnelFacing, true);
                if (tryFunnel == null || !tryFunnel.method_7960())
                    return;
            }
        }

        DirectBeltInputBehaviour targetOpenInv = getTargetOpenInv();

        // Do not eject if target cannot accept held item
        if (targetOpenInv != null && depotBehaviour.heldItem != null && targetOpenInv.handleInsertion(held, class_2350.field_11036, true)
            .method_7947() == held.method_7947())
            return;

        activate();
        notifyUpdate();
    }

    public DirectBeltInputBehaviour getTargetOpenInv() {
        class_2338 targetPos = earlyTarget != null ? earlyTarget.getSecond() : field_11867.method_10086(launcher.getVerticalDistance())
            .method_10079(getFacing(), Math.max(1, launcher.getHorizontalDistance()));
        return BlockEntityBehaviour.get(field_11863, targetPos, DirectBeltInputBehaviour.TYPE);
    }

    public class_243 getLaunchedItemLocation(float time) {
        return launcher.getGlobalPos(time, getFacing().method_10153(), field_11867);
    }

    public class_243 getLaunchedItemMotion(float time) {
        class_243 pos = launcher.getGlobalVelocity(time, getFacing().method_10153()).method_1021(.5f);
        return new class_243(
            (int) (class_3532.method_15350(pos.field_1352, -3.9, 3.9) * 8000.0) / 8000.0,
            (int) (class_3532.method_15350(pos.field_1351, -3.9, 3.9) * 8000.0) / 8000.0,
            (int) (class_3532.method_15350(pos.field_1350, -3.9, 3.9) * 8000.0) / 8000.0
        );
    }

    public float getWindUpSpeed() {
        int hd = launcher.getHorizontalDistance();
        int vd = launcher.getVerticalDistance();

        float speedFactor = Math.abs(getSpeed()) / 256f;
        float distanceFactor;
        if (hd == 0 && vd == 0)
            distanceFactor = 1;
        else
            distanceFactor = 1 * class_3532.method_15355(hd * hd + vd * vd);
        return speedFactor / distanceFactor;
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71465("HorizontalDistance", launcher.getHorizontalDistance());
        view.method_71465("VerticalDistance", launcher.getVerticalDistance());
        view.method_71472("Powered", powered);
        view.method_71468("State", State.CODEC, state);
        lidProgress.write(view.method_71461("Lid"));

        if (earlyTarget != null) {
            view.method_71468("EarlyTarget", class_243.field_38277, earlyTarget.getFirst());
            view.method_71468("EarlyTargetPos", class_2338.field_25064, earlyTarget.getSecond());
            view.method_71464("EarlyTargetTime", earlyTargetTime);
        }
    }

    @Override
    public void writeSafe(class_11372 view) {
        super.writeSafe(view);
        view.method_71465("HorizontalDistance", launcher.getHorizontalDistance());
        view.method_71465("VerticalDistance", launcher.getVerticalDistance());
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        int horizontalDistance = view.method_71424("HorizontalDistance", 0);
        int verticalDistance = view.method_71424("VerticalDistance", 0);

        if (launcher.getHorizontalDistance() != horizontalDistance || launcher.getVerticalDistance() != verticalDistance) {
            launcher.set(horizontalDistance, verticalDistance);
            launcher.clamp(AllConfigs.server().kinetics.maxEjectorDistance.get());
        }

        powered = view.method_71433("Powered", false);
        state = view.method_71426("State", State.CODEC).orElse(State.RETRACTING);
        lidProgress.read(view.method_71434("Lid"), false);

        earlyTarget = null;
        earlyTargetTime = 0;
        view.method_71426("EarlyTarget", class_243.field_38277).ifPresent(vec3d -> {
            earlyTarget = Pair.of(vec3d, view.method_71426("EarlyTargetPos", class_2338.field_25064).orElseThrow());
            earlyTargetTime = view.method_71423("EarlyTargetTime", 0);
        });

        float forceAngle = view.method_71423("ForceAngle", -1);
        if (forceAngle != -1) {
            lidProgress.startWithValue(forceAngle);
        }
    }

    public void updateSignal() {
        boolean shoudPower = field_11863.method_49803(field_11867);
        if (shoudPower == powered)
            return;
        powered = shoudPower;
        sendData();
    }

    public void setTarget(int horizontalDistance, int verticalDistance) {
        launcher.set(Math.max(1, horizontalDistance), verticalDistance);
        sendData();
    }

    public class_2338 getTargetPosition() {
        class_2680 blockState = method_11010();
        if (!blockState.method_27852(AllBlocks.WEIGHTED_EJECTOR))
            return field_11867;
        class_2350 facing = blockState.method_11654(EjectorBlock.HORIZONTAL_FACING);
        return field_11867.method_10079(facing, launcher.getHorizontalDistance()).method_10086(launcher.getVerticalDistance());
    }

    public float getLidProgress(float pt) {
        return lidProgress.getValue(pt);
    }

    public State getState() {
        return state;
    }

    private static abstract class EntityHack extends class_1297 {

        public EntityHack(class_1299<?> p_i48580_1_, class_1937 p_i48580_2_) {
            super(p_i48580_1_, p_i48580_2_);
        }

        public static void setElytraFlying(class_1297 e) {
            class_2945 data = e.method_5841();
            data.method_12778(field_5990, (byte) (data.method_12789(field_5990) | 1 << 7));
        }

    }
}