package com.zurrtum.create.content.logistics.filter;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.content.logistics.filter.FilterItemStack.ListFilterItemStack;
import com.zurrtum.create.foundation.gui.menu.MenuBase;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_9129;
import net.minecraft.class_9288;
import net.minecraft.class_9331;

public class ListFilterItem extends FilterItem {
    protected ListFilterItem(class_1793 properties) {
        super(properties);
    }

    @Override
    public List<class_2561> makeSummary(class_1799 filter) {
        List<class_2561> list = new ArrayList<>();

        ItemStackHandler filterItems = getFilterItemHandler(filter);
        boolean blacklist = filter.method_58695(AllDataComponents.FILTER_ITEMS_BLACKLIST, false);

        list.add((blacklist ? class_2561.method_43471("create.gui.filter.deny_list") : class_2561.method_43471("create.gui.filter.allow_list")).method_27692(
            class_124.field_1065));
        int count = 0;
        for (int i = 0, size = filterItems.method_5439(); i < size; i++) {
            if (count > 3) {
                list.add(class_2561.method_43470("- ...").method_27692(class_124.field_1063));
                break;
            }

            class_1799 filterStack = filterItems.method_5438(i);
            if (filterStack.method_7960())
                continue;
            list.add(class_2561.method_43470("- ").method_10852(filterStack.method_7964()).method_27692(class_124.field_1080));
            count++;
        }

        if (count == 0)
            return Collections.emptyList();

        return list;
    }

    @Override
    public @Nullable MenuBase<?> createMenu(int id, class_1661 inv, class_1657 player, class_9129 extraData) {
        class_1799 heldItem = player.method_6047();
        class_1799.field_48349.encode(extraData, heldItem);
        return new FilterMenu(id, inv, heldItem);
    }

    @Override
    public class_9331<?> getComponentType() {
        return AllDataComponents.FILTER_ITEMS;
    }

    @Override
    public FilterItemStack makeStackWrapper(class_1799 filter) {
        return new ListFilterItemStack(filter);
    }

    public ItemStackHandler getFilterItemHandler(class_1799 stack) {
        ItemStackHandler newInv = new ItemStackHandler(18);
        class_9288 contents = stack.method_58695(AllDataComponents.FILTER_ITEMS, class_9288.field_49334);
        ItemHelper.fillItemStackHandler(contents, newInv);
        return newInv;
    }

    @Override
    public class_1799[] getFilterItems(class_1799 stack) {
        if (stack.method_58695(AllDataComponents.FILTER_ITEMS_BLACKLIST, false))
            return new class_1799[0];
        return ItemHelper.getNonEmptyStacks(getFilterItemHandler(stack)).toArray(class_1799[]::new);
    }
}