package com.zurrtum.create.content.logistics.packager;

import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.api.packager.InventoryIdentifier;
import com.zurrtum.create.api.registry.SimpleRegistry;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.content.logistics.vault.ItemVaultBlockEntity;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.class_1278;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_3954;

public class AllInventoryIdentifiers {
    public static void registerDefaults() {
        // identify known single blocks
        InventoryIdentifier.REGISTRY.registerProvider(SimpleRegistry.Provider.forBlockTag(
            AllBlockTags.SINGLE_BLOCK_INVENTORIES,
            AllInventoryIdentifiers::single
        ));

        // connect double chests
        InventoryIdentifier.REGISTRY.registerProvider(block -> {
            Collection<class_2769<?>> properties = block.method_9595().method_11659();
            if (properties.contains(class_2281.field_10770) && properties.contains(class_2281.field_10768)) {
                return AllInventoryIdentifiers::chest;
            }
            return null;
        });

        // best-effort for WorldlyContainerHolders (just composters in vanilla)
        InventoryIdentifier.REGISTRY.registerProvider(block -> {
            if (block instanceof class_3954) {
                return AllInventoryIdentifiers::worldlyContainerBlock;
            }
            return null;
        });

        // connect vaults
        InventoryIdentifier.REGISTRY.register(
            AllBlocks.ITEM_VAULT, (level, state, face) -> {
                class_2586 be = level.method_8321(face.getPos());
                return be instanceof ItemVaultBlockEntity vault ? vault.getInvId() : null;
            }
        );
    }

    private static InventoryIdentifier single(class_1937 level, class_2680 state, BlockFace face) {
        return new InventoryIdentifier.Single(face.getPos());
    }

    private static InventoryIdentifier chest(class_1937 level, class_2680 state, BlockFace face) {
        class_2745 type = state.method_11654(class_2281.field_10770);

        if (type != class_2745.field_12569) {
            class_2350 toOther = class_2281.method_9758(state);
            class_2338 otherPos = face.getPos().method_10093(toOther);
            class_2680 otherState = level.method_8320(otherPos);
            if (otherState.method_27852(state.method_26204()) && class_2281.method_9758(otherState) == toOther.method_10153()) {
                return new InventoryIdentifier.Pair(face.getPos(), otherPos);
            }
        }

        return new InventoryIdentifier.Single(face.getPos());
    }

    private static InventoryIdentifier worldlyContainerBlock(class_1937 level, class_2680 state, BlockFace face) {
        class_3954 holder = (class_3954) state.method_26204();
        class_1278 container = holder.method_17680(state, level, face.getPos());
        return ofWorldlyContainer(container, face);
    }

    private static InventoryIdentifier ofWorldlyContainer(class_1278 container, BlockFace face) {
        class_2350 side = face.getFace();
        int[] slots = container.method_5494(side);
        // get all faces that have the same slots as the given one
        Set<class_2350> directions = EnumSet.of(side);
        for (class_2350 direction : Iterate.directions) {
            if (direction != side) {
                int[] faceSlots = container.method_5494(direction);
                if (Arrays.equals(slots, faceSlots)) {
                    directions.add(direction);
                }
            }
        }
        return new InventoryIdentifier.MultiFace(face.getPos(), directions);
    }

    // called manually when no other Finder is found.
    // currently just checks for WorldlyContainer BlockEntities, which would
    // fill the registry with Finders pointlessly if done through a provider.
    public static InventoryIdentifier fallback(class_1937 level, class_2680 state, BlockFace face) {
        class_2586 be = level.method_8321(face.getPos());
        if (be instanceof class_1278 container) {
            return ofWorldlyContainer(container, face);
        }

        return null;
    }
}
