package com.zurrtum.create.content.logistics.packager;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.infrastructure.packet.s2c.LogisticalStockResponsePacket;
import org.apache.commons.lang3.mutable.MutableInt;

import java.util.*;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_3222;

public class InventorySummary {
    public static Codec<InventorySummary> CODEC = BigItemStack.CODEC.listOf().xmap(
        i -> {
            InventorySummary summary = new InventorySummary();
            summary.addAllBigItemStacks(i);
            return summary;
        }, i -> {
            List<BigItemStack> all = new ArrayList<>();
            i.items.forEach((key, list) -> all.addAll(list));
            return all;
        }
    );

    public static final InventorySummary EMPTY = new InventorySummary();

    private Map<class_1792, List<BigItemStack>> items = new IdentityHashMap<>();
    private List<BigItemStack> stacksByCount;
    private int totalCount;

    public int contributingLinks;

    public void add(InventorySummary summary) {
        summary.items.forEach((i, list) -> list.forEach(this::add));
        contributingLinks += summary.contributingLinks;
    }

    public void add(class_1799 stack) {
        add(stack, stack.method_7947());
    }

    public void add(BigItemStack entry) {
        add(entry.stack, entry.count);
    }

    public Map<class_1792, List<BigItemStack>> getItemMap() {
        return items;
    }

    public void addAllItemStacks(List<class_1799> list) {
        for (class_1799 stack : list)
            add(stack, stack.method_7947());
    }

    public void addAllBigItemStacks(List<BigItemStack> list) {
        for (BigItemStack entry : list)
            add(entry.stack, entry.count);
    }

    public InventorySummary copy() {
        InventorySummary inventorySummary = new InventorySummary();
        items.forEach((i, list) -> list.forEach(entry -> inventorySummary.add(entry.stack, entry.count)));
        return inventorySummary;
    }

    public void add(class_1799 stack, int count) {
        if (count == 0 || stack.method_7960())
            return;

        if (totalCount < BigItemStack.INF)
            totalCount += count;

        List<BigItemStack> stacks = items.computeIfAbsent(stack.method_7909(), $ -> Lists.newArrayList());
        for (BigItemStack existing : stacks) {
            class_1799 existingStack = existing.stack;
            if (class_1799.method_31577(existingStack, stack)) {
                if (existing.count < BigItemStack.INF)
                    existing.count += count;
                return;
            }
        }

        if (stack.method_7947() > stack.method_7914())
            stack = stack.method_46651(1);

        BigItemStack newEntry = new BigItemStack(stack, count);
        stacks.add(newEntry);
    }

    public boolean erase(class_1799 stack) {
        List<BigItemStack> stacks = items.get(stack.method_7909());
        if (stacks == null)
            return false;
        for (Iterator<BigItemStack> iterator = stacks.iterator(); iterator.hasNext(); ) {
            BigItemStack existing = iterator.next();
            class_1799 existingStack = existing.stack;
            if (!class_1799.method_31577(existingStack, stack))
                continue;
            totalCount -= existing.count;
            iterator.remove();
            return true;
        }
        return false;
    }

    public int getCountOf(class_1799 stack) {
        List<BigItemStack> list = items.get(stack.method_7909());
        if (list == null)
            return 0;
        for (BigItemStack entry : list)
            if (class_1799.method_31577(entry.stack, stack))
                return entry.count;
        return 0;
    }

    public int getTotalOfMatching(Predicate<class_1799> filter) {
        MutableInt sum = new MutableInt();
        items.forEach(($, list) -> {
            for (BigItemStack entry : list)
                if (filter.test(entry.stack))
                    sum.add(entry.count);
        });
        return sum.getValue();
    }

    public List<BigItemStack> getStacks() {
        if (stacksByCount == null) {
            List<BigItemStack> stacks = new ArrayList<>();
            items.forEach((i, list) -> stacks.addAll(list));
            return stacks;
        }
        return stacksByCount;
    }

    public List<BigItemStack> getStacksByCount() {
        if (stacksByCount == null) {
            stacksByCount = new ArrayList<>();
            items.forEach((i, list) -> stacksByCount.addAll(list));
            stacksByCount.sort(BigItemStack.comparator());
        }
        return stacksByCount;
    }

    public int getTotalCount() {
        return totalCount;
    }

    public void divideAndSendTo(class_3222 player, class_2338 pos) {
        List<BigItemStack> stacks = getStacksByCount();
        int remaining = stacks.size();

        List<BigItemStack> currentList = null;

        if (stacks.isEmpty())
            player.field_13987.method_14364(new LogisticalStockResponsePacket(true, pos, Collections.emptyList()));

        for (BigItemStack entry : stacks) {
            if (currentList == null)
                currentList = new ArrayList<>(Math.min(100, remaining));

            currentList.add(entry);
            remaining--;

            if (remaining == 0)
                break;
            if (currentList.size() < 100)
                continue;

            player.field_13987.method_14364(new LogisticalStockResponsePacket(false, pos, currentList));
            currentList = null;
        }

        if (currentList != null)
            player.field_13987.method_14364(new LogisticalStockResponsePacket(true, pos, currentList));
    }

    public boolean isEmpty() {
        return items.isEmpty();
    }

}
