package com.zurrtum.create.content.logistics.packager;

import com.mojang.serialization.Codec;
import com.zurrtum.create.*;
import com.zurrtum.create.api.packager.unpacking.UnpackingHandler;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.compat.computercraft.AbstractComputerBehaviour;
import com.zurrtum.create.compat.computercraft.ComputerCraftProxy;
import com.zurrtum.create.compat.computercraft.events.PackageEvent;
import com.zurrtum.create.content.contraptions.actors.psi.PortableStorageInterfaceBlockEntity;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.crate.BottomlessItemHandler;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.zurrtum.create.content.logistics.factoryBoard.ServerFactoryPanelBehaviour;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour.RequestType;
import com.zurrtum.create.content.logistics.packagerLink.PackagerLinkBlock;
import com.zurrtum.create.content.logistics.packagerLink.PackagerLinkBlockEntity;
import com.zurrtum.create.content.logistics.packagerLink.RequestPromiseQueue;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.CapManipulationBehaviourBase.InterfaceProvider;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.infrastructure.component.PackageOrderWithCrafts;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import com.zurrtum.create.infrastructure.packet.s2c.WiFiEffectPacket;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_8242;

public class PackagerBlockEntity extends SmartBlockEntity {
    private static final Codec<List<BigItemStack>> EXITING_CODEC = BigItemStack.CODEC.listOf();

    public boolean redstonePowered;
    public int buttonCooldown;
    public String signBasedAddress;

    public InvManipulationBehaviour targetInventory;
    public class_1799 heldBox;
    public class_1799 previouslyUnwrapped;

    public List<BigItemStack> queuedExitingPackages;

    public final PackagerItemHandler inventory;

    public static final int CYCLE = 20;
    public int animationTicks;
    public boolean animationInward;

    public AbstractComputerBehaviour computerBehaviour;
    public Boolean hasCustomComputerAddress;
    public String customComputerAddress;

    private InventorySummary availableItems;
    private VersionedInventoryTrackerBehaviour invVersionTracker;

    public PackagerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        redstonePowered = state.method_61767(PackagerBlock.POWERED, false);
        heldBox = class_1799.field_8037;
        previouslyUnwrapped = class_1799.field_8037;
        inventory = new PackagerItemHandler(this);
        animationTicks = 0;
        animationInward = true;
        queuedExitingPackages = new LinkedList<>();
        signBasedAddress = "";
        customComputerAddress = "";
        hasCustomComputerAddress = false;
        buttonCooldown = 0;
    }

    public PackagerBlockEntity(class_2338 pos, class_2680 state) {
        this(AllBlockEntityTypes.PACKAGER, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(targetInventory = new InvManipulationBehaviour(
            this,
            InterfaceProvider.oppositeOfBlockFacing()
        ).withFilter(this::supportsBlockEntity));
        behaviours.add(invVersionTracker = new VersionedInventoryTrackerBehaviour(this));
        behaviours.add(computerBehaviour = ComputerCraftProxy.behaviour(this));
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.PACKAGER);
    }

    private boolean supportsBlockEntity(class_2586 target) {
        return target != null && !(target instanceof PortableStorageInterfaceBlockEntity);
    }

    @Override
    public void initialize() {
        super.initialize();
        recheckIfLinksPresent();
    }

    @Override
    public void tick() {
        super.tick();

        if (buttonCooldown > 0)
            buttonCooldown--;

        if (animationTicks == 0) {
            previouslyUnwrapped = class_1799.field_8037;

            if (!field_11863.method_8608() && !queuedExitingPackages.isEmpty() && heldBox.method_7960()) {
                BigItemStack entry = queuedExitingPackages.getFirst();
                heldBox = entry.stack.method_7972();

                entry.count--;
                if (entry.count <= 0)
                    queuedExitingPackages.removeFirst();

                animationInward = false;
                animationTicks = CYCLE;
                notifyUpdate();
            }

            return;
        }

        if (field_11863.method_8608()) {
            if (animationTicks == CYCLE - (animationInward ? 5 : 1))
                AllSoundEvents.PACKAGER.playAt(field_11863, field_11867, 1, 1, true);
            if (animationTicks == (animationInward ? 1 : 5))
                field_11863.method_45446(field_11867, class_3417.field_15131, class_3419.field_15245, 0.25f, 0.75f, true);
        }

        animationTicks--;

        if (animationTicks == 0 && !field_11863.method_8608()) {
            wakeTheFrogs();
            method_5431();
        }
    }

    public void triggerStockCheck() {
        getAvailableItems();
    }

    public InventorySummary getAvailableItems() {
        if (availableItems != null && invVersionTracker.stillWaiting(targetInventory.getInventory()))
            return availableItems;

        InventorySummary availableItems = new InventorySummary();

        class_1263 targetInv = targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler) {
            this.availableItems = availableItems;
            return availableItems;
        }

        if (targetInv instanceof BottomlessItemHandler bih) {
            availableItems.add(bih.method_5438(0), BigItemStack.INF);
            this.availableItems = availableItems;
            return availableItems;
        }

        for (int slot = 0, size = targetInv.method_5439(); slot < size; slot++) {
            availableItems.add(targetInv.method_5438(slot));
        }

        invVersionTracker.awaitNewVersion(targetInventory.getInventory());
        submitNewArrivals(this.availableItems, availableItems);
        this.availableItems = availableItems;
        return availableItems;
    }

    private void submitNewArrivals(InventorySummary before, InventorySummary after) {
        if (before == null || after.isEmpty())
            return;

        Set<RequestPromiseQueue> promiseQueues = new HashSet<>();

        for (class_2350 d : Iterate.directions) {
            if (!field_11863.method_8477(field_11867.method_10093(d)))
                continue;

            class_2680 adjacentState = field_11863.method_8320(field_11867.method_10093(d));
            if (adjacentState.method_27852(AllBlocks.FACTORY_GAUGE)) {
                if (FactoryPanelBlock.connectedDirection(adjacentState) != d)
                    continue;
                if (!(field_11863.method_8321(field_11867.method_10093(d)) instanceof FactoryPanelBlockEntity fpbe))
                    continue;
                if (!fpbe.restocker)
                    continue;
                for (ServerFactoryPanelBehaviour behaviour : fpbe.panels.values()) {
                    if (!behaviour.isActive())
                        continue;
                    promiseQueues.add(behaviour.restockerPromises);
                }
            }

            if (adjacentState.method_27852(AllBlocks.STOCK_LINK)) {
                if (PackagerLinkBlock.getConnectedDirection(adjacentState) != d)
                    continue;
                if (!(field_11863.method_8321(field_11867.method_10093(d)) instanceof PackagerLinkBlockEntity plbe))
                    continue;
                UUID freqId = plbe.behaviour.freqId;
                if (!Create.LOGISTICS.hasQueuedPromises(freqId))
                    continue;
                promiseQueues.add(Create.LOGISTICS.getQueuedPromises(freqId));
            }
        }

        if (promiseQueues.isEmpty())
            return;

        for (BigItemStack entry : after.getStacks())
            before.add(entry.stack, -entry.count);
        for (RequestPromiseQueue queue : promiseQueues)
            for (BigItemStack entry : before.getStacks())
                if (entry.count < 0)
                    queue.itemEnteredSystem(entry.stack, -entry.count);
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (field_11863.method_8608())
            return;
        recheckIfLinksPresent();
        if (!redstonePowered)
            return;
        redstonePowered = method_11010().method_61767(PackagerBlock.POWERED, false);
        if (!redstoneModeActive())
            return;
        updateSignAddress();
        attemptToSend(null);
    }

    public void recheckIfLinksPresent() {
        if (field_11863.method_8608())
            return;
        class_2680 blockState = method_11010();
        if (!blockState.method_28498(PackagerBlock.LINKED))
            return;
        boolean shouldBeLinked = getLinkPos() != null;
        boolean isLinked = blockState.method_11654(PackagerBlock.LINKED);
        if (shouldBeLinked == isLinked)
            return;
        field_11863.method_8501(field_11867, blockState.method_28493(PackagerBlock.LINKED));
    }

    public boolean redstoneModeActive() {
        return !method_11010().method_61767(PackagerBlock.LINKED, false);
    }

    private class_2338 getLinkPos() {
        for (class_2350 d : Iterate.directions) {
            class_2680 adjacentState = field_11863.method_8320(field_11867.method_10093(d));
            if (!adjacentState.method_27852(AllBlocks.STOCK_LINK))
                continue;
            if (PackagerLinkBlock.getConnectedDirection(adjacentState) != d)
                continue;
            return field_11867.method_10093(d);
        }
        return null;
    }

    public void flashLink() {
        if (!(field_11863 instanceof class_3218 serverWorld)) {
            return;
        }
        for (class_2350 d : Iterate.directions) {
            class_2338 adjacentPos = field_11867.method_10093(d);
            class_2680 adjacentState = field_11863.method_8320(adjacentPos);
            if (!adjacentState.method_27852(AllBlocks.STOCK_LINK))
                continue;
            if (PackagerLinkBlock.getConnectedDirection(adjacentState) != d)
                continue;
            serverWorld.method_8503().method_3760().method_14605(
                null,
                adjacentPos.method_10263(),
                adjacentPos.method_10264(),
                adjacentPos.method_10260(),
                32,
                serverWorld.method_27983(),
                new WiFiEffectPacket(adjacentPos)
            );
            return;
        }
    }

    public boolean isTooBusyFor(RequestType type) {
        int queue = queuedExitingPackages.size();
        return queue >= switch (type) {
            case PLAYER -> 50;
            case REDSTONE -> 20;
            case RESTOCK -> 10;
        };
    }

    public void activate() {
        redstonePowered = true;
        method_5431();

        recheckIfLinksPresent();
        if (!redstoneModeActive())
            return;

        updateSignAddress();
        attemptToSend(null);

        // dont send multiple packages when a button signal length is received
        if (buttonCooldown <= 0) { // still on button cooldown, don't prolong it
            buttonCooldown = 40;
        }
    }

    public boolean unwrapBox(class_1799 box, boolean simulate) {
        if (animationTicks > 0)
            return false;

        Objects.requireNonNull(field_11863);

        ItemStackHandler contents = PackageItem.getContents(box);
        List<class_1799> items = ItemHelper.getNonEmptyStacks(contents);
        if (items.isEmpty())
            return true;

        PackageOrderWithCrafts orderContext = PackageItem.getOrderContext(box);
        class_2350 facing = method_11010().method_61767(PackagerBlock.field_10927, class_2350.field_11036);
        class_2338 target = field_11867.method_10093(facing.method_10153());
        class_2680 targetState = field_11863.method_8320(target);

        UnpackingHandler handler = UnpackingHandler.REGISTRY.get(targetState);
        UnpackingHandler toUse = handler != null ? handler : AllUnpackingHandlers.DEFAULT;
        // note: handler may modify the passed items
        boolean unpacked = toUse.unpack(field_11863, target, targetState, facing, items, orderContext, simulate);

        if (unpacked && !simulate) {
            computerBehaviour.prepareComputerEvent(new PackageEvent(box, "package_received"));
            previouslyUnwrapped = box;
            animationInward = true;
            animationTicks = CYCLE;
            notifyUpdate();
        }

        return unpacked;
    }

    public void attemptToSend(@Nullable List<PackagingRequest> queuedRequests) {
        if (queuedRequests == null && (!heldBox.method_7960() || animationTicks != 0 || buttonCooldown > 0))
            return;

        class_1263 targetInv = targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler)
            return;

        MutableBoolean anyItemPresent = new MutableBoolean();
        ItemStackHandler extractedItems = new ItemStackHandler(PackageItem.SLOTS);
        class_1799 extractedPackageItem = class_1799.field_8037;
        PackagingRequest nextRequest = null;
        String fixedAddress = null;
        int fixedOrderId = 0;

        // Data written to packages for defrags
        int linkIndexInOrder = 0;
        boolean finalLinkInOrder = false;
        int packageIndexAtLink = 0;
        boolean finalPackageAtLink = false;
        PackageOrderWithCrafts orderContext = null;
        boolean requestQueue = queuedRequests != null;

        if (requestQueue && !queuedRequests.isEmpty()) {
            nextRequest = queuedRequests.get(0);
            fixedAddress = nextRequest.address();
            fixedOrderId = nextRequest.orderId();
            linkIndexInOrder = nextRequest.linkIndex();
            finalLinkInOrder = nextRequest.finalLink().booleanValue();
            packageIndexAtLink = nextRequest.packageCounter().getAndIncrement();
            orderContext = nextRequest.context();
        }

        Outer:
        for (int i = 0; i < PackageItem.SLOTS; i++) {
            boolean continuePacking = true;

            while (continuePacking) {
                continuePacking = false;

                if (requestQueue) {
                    class_1799 stack = nextRequest.item();
                    class_1792 item = stack.method_7909();

                    boolean bulky = !item.method_31568();
                    if (bulky && anyItemPresent.isTrue())
                        break Outer;

                    int count = Math.min(64, nextRequest.getCount());
                    int extract = targetInv.extract(stack, count);
                    if (extract == 0)
                        break Outer;
                    anyItemPresent.setTrue();
                    extractedItems.insert(stack, extract);

                    if (item instanceof PackageItem)
                        extractedPackageItem = stack.method_46651(extract);

                    nextRequest.subtract(extract);

                    if (!nextRequest.isEmpty()) {
                        if (bulky)
                            break Outer;
                        break;
                    }

                    finalPackageAtLink = true;
                    queuedRequests.removeFirst();
                    if (queuedRequests.isEmpty())
                        break Outer;
                    int previousCount = nextRequest.packageCounter().intValue();
                    nextRequest = queuedRequests.getFirst();
                    if (!fixedAddress.equals(nextRequest.address()))
                        break Outer;
                    if (fixedOrderId != nextRequest.orderId())
                        break Outer;

                    nextRequest.packageCounter().setValue(previousCount);
                    finalPackageAtLink = false;
                    continuePacking = true;
                    if (nextRequest.context() != null)
                        orderContext = nextRequest.context();

                    if (bulky)
                        break Outer;
                } else {
                    class_1799 extracted = targetInv.extract(stack -> anyItemPresent.isFalse() || stack.method_7909().method_31568(), 64);
                    if (extracted.method_7960())
                        break Outer;

                    anyItemPresent.setTrue();
                    extractedItems.insert(extracted);
                    class_1792 item = extracted.method_7909();

                    if (item instanceof PackageItem)
                        extractedPackageItem = extracted;
                    if (!item.method_31568())
                        break Outer;
                }
            }
        }

        if (anyItemPresent.isFalse()) {
            if (nextRequest != null)
                queuedRequests.removeFirst();
            return;
        }

        class_1799 createdBox = extractedPackageItem.method_7960() ? PackageItem.containing(extractedItems) : extractedPackageItem;
        computerBehaviour.prepareComputerEvent(new PackageEvent(createdBox, "package_created"));
        PackageItem.clearAddress(createdBox);

        if (fixedAddress != null && !fixedAddress.isBlank())
            PackageItem.addAddress(createdBox, fixedAddress);
        if (requestQueue)
            PackageItem.setOrder(createdBox, fixedOrderId, linkIndexInOrder, finalLinkInOrder, packageIndexAtLink, finalPackageAtLink, orderContext);
        if (!requestQueue && !signBasedAddress.isBlank())
            PackageItem.addAddress(createdBox, signBasedAddress);

        class_2338 linkPos = getLinkPos();
        if (extractedPackageItem.method_7960() && linkPos != null && field_11863.method_8321(linkPos) instanceof PackagerLinkBlockEntity plbe)
            plbe.behaviour.deductFromAccurateSummary(extractedItems);

        if (!heldBox.method_7960() || animationTicks != 0) {
            queuedExitingPackages.add(new BigItemStack(createdBox, 1));
            return;
        }

        heldBox = createdBox;
        animationInward = false;
        animationTicks = CYCLE;

        award(AllAdvancements.PACKAGER);
        triggerStockCheck();
        notifyUpdate();
    }

    public void updateSignAddress() {
        signBasedAddress = "";
        for (class_2350 side : Iterate.directions) {
            String address = getSign(side);
            if (address == null || address.isBlank())
                continue;
            signBasedAddress = address;
        }
        if (computerBehaviour.hasAttachedComputer() && hasCustomComputerAddress) {
            signBasedAddress = customComputerAddress;
        } else {
            hasCustomComputerAddress = false;
        }
    }

    protected String getSign(class_2350 side) {
        class_2586 blockEntity = field_11863.method_8321(field_11867.method_10093(side));
        if (!(blockEntity instanceof class_2625 sign))
            return null;
        for (boolean front : Iterate.trueAndFalse) {
            class_8242 text = sign.method_49843(front);
            String address = "";
            for (class_2561 component : text.method_49877(false)) {
                String string = component.getString();
                if (!string.isBlank())
                    address += string.trim() + " ";
            }
            if (!address.isBlank())
                return address.trim();
        }
        return null;
    }

    protected void wakeTheFrogs() {
        //TODO
        //        if (world.getBlockEntity(pos.offset(Direction.UP)) instanceof FrogportBlockEntity port)
        //            port.tryPullingFromOwnAndAdjacentInventories();
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        redstonePowered = view.method_71433("Active", false);
        animationInward = view.method_71433("AnimationInward", false);
        animationTicks = view.method_71424("AnimationTicks", 0);
        signBasedAddress = view.method_71428("SignAddress", "");
        customComputerAddress = view.method_71428("ComputerAddress", "");
        hasCustomComputerAddress = view.method_71433("HasComputerAddress", false);
        heldBox = view.method_71426("HeldBox", class_1799.field_24671).orElse(class_1799.field_8037);
        previouslyUnwrapped = view.method_71426("InsertedBox", class_1799.field_24671).orElse(class_1799.field_8037);
        if (clientPacket)
            return;
        queuedExitingPackages.clear();
        view.method_71426("QueuedExitingPackages", EXITING_CODEC).ifPresent(list -> queuedExitingPackages.addAll(list));
        view.method_71426("LastSummary", InventorySummary.CODEC).ifPresent(summary -> availableItems = summary);
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71472("Active", redstonePowered);
        view.method_71472("AnimationInward", animationInward);
        view.method_71465("AnimationTicks", animationTicks);
        view.method_71469("SignAddress", signBasedAddress);
        view.method_71469("ComputerAddress", customComputerAddress);
        view.method_71472("HasComputerAddress", hasCustomComputerAddress);
        if (!heldBox.method_7960()) {
            view.method_71468("HeldBox", class_1799.field_24671, heldBox);
        }
        if (!previouslyUnwrapped.method_7960()) {
            view.method_71468("InsertedBox", class_1799.field_24671, previouslyUnwrapped);
        }
        if (clientPacket)
            return;
        view.method_71468("QueuedExitingPackages", EXITING_CODEC, queuedExitingPackages);
        if (availableItems != null)
            view.method_71468("LastSummary", InventorySummary.CODEC, availableItems);
    }

    @Override
    public void destroy() {
        super.destroy();
        class_1264.method_5451(field_11863, field_11867, inventory);
        queuedExitingPackages.forEach(bigStack -> {
            for (int i = 0; i < bigStack.count; i++)
                class_1264.method_5449(field_11863, field_11867.method_10263(), field_11867.method_10264(), field_11867.method_10260(), bigStack.stack.method_7972());
        });
        queuedExitingPackages.clear();
    }

    public float getTrayOffset(float partialTicks) {
        float tickCycle = animationInward ? animationTicks - partialTicks : animationTicks - 5 - partialTicks;
        float progress = class_3532.method_15363(tickCycle / (CYCLE - 5) * 2 - 1, -1, 1);
        progress = 1 - progress * progress;
        return progress * progress;
    }

    public class_1799 getRenderedBox() {
        if (animationInward)
            return animationTicks <= CYCLE / 2 ? class_1799.field_8037 : previouslyUnwrapped;
        return animationTicks >= CYCLE / 2 ? class_1799.field_8037 : heldBox;
    }

    public boolean isTargetingSameInventory(@Nullable IdentifiedInventory inventory) {
        if (inventory == null)
            return false;

        class_1263 targetHandler = targetInventory.getInventory();
        if (targetHandler == null)
            return false;

        if (inventory.identifier() != null) {
            BlockFace face = targetInventory.getTarget().getOpposite();
            return inventory.identifier().contains(face);
        } else {
            return isSameInventoryFallback(targetHandler, inventory.handler());
        }
    }

    private static boolean isSameInventoryFallback(class_1263 first, class_1263 second) {
        if (first == second)
            return true;

        // If a contained ItemStack instance is the same, we can be pretty sure these
        // inventories are the same (works for compound inventories)
        for (int i = 0, secondSize = second.method_5439(); i < secondSize; i++) {
            class_1799 stackInSlot = second.method_5438(i);
            if (stackInSlot.method_7960())
                continue;
            for (int j = 0, firstSize = first.method_5439(); j < firstSize; j++)
                if (stackInSlot == first.method_5438(j))
                    return true;
            break;
        }

        return false;
    }
}
