package com.zurrtum.create.content.logistics.packager.repackager;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.compat.computercraft.events.PackageEvent;
import com.zurrtum.create.compat.computercraft.events.RepackageEvent;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.crate.BottomlessItemHandler;
import com.zurrtum.create.content.logistics.packager.PackagerBlockEntity;
import com.zurrtum.create.content.logistics.packager.PackagerItemHandler;
import com.zurrtum.create.content.logistics.packager.PackagingRequest;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class RepackagerBlockEntity extends PackagerBlockEntity {

    public PackageRepackageHelper repackageHelper;

    public RepackagerBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.REPACKAGER, pos, state);
        repackageHelper = new PackageRepackageHelper();
    }

    public boolean unwrapBox(class_1799 box, boolean simulate) {
        if (animationTicks > 0)
            return false;

        class_1263 targetInv = targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler)
            return false;

        boolean targetIsCreativeCrate = targetInv instanceof BottomlessItemHandler;
        boolean anySpace;
        if (simulate) {
            int count = box.method_7947();
            anySpace = targetInv.countSpace(box, count) == count;
        } else {
            anySpace = targetInv.preciseInsert(box);
        }

        if (!targetIsCreativeCrate && !anySpace)
            return false;
        if (simulate)
            return true;

        computerBehaviour.prepareComputerEvent(new PackageEvent(box, "package_received"));
        previouslyUnwrapped = box;
        animationInward = true;
        animationTicks = CYCLE;
        notifyUpdate();
        return true;
    }

    @Override
    public void recheckIfLinksPresent() {
    }

    @Override
    public boolean redstoneModeActive() {
        return true;
    }

    public void attemptToSend(List<PackagingRequest> queuedRequests) {
        if (!heldBox.method_7960() || animationTicks != 0 || buttonCooldown > 0)
            return;
        if (!queuedExitingPackages.isEmpty())
            return;

        class_1263 targetInv = targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler)
            return;

        attemptToRepackage(targetInv);
        if (heldBox.method_7960())
            return;

        updateSignAddress();
        if (!signBasedAddress.isBlank())
            PackageItem.addAddress(heldBox, signBasedAddress);
    }

    protected void attemptToRepackage(class_1263 targetInv) {
        repackageHelper.clear();
        int completedOrderId = -1;

        for (class_1799 stack : targetInv) {
            if (stack.method_7960() || !PackageItem.isPackage(stack))
                continue;

            if (!repackageHelper.isFragmented(stack)) {
                targetInv.extract(stack, 1);
                heldBox = stack.method_7972();
                animationInward = false;
                animationTicks = CYCLE;
                notifyUpdate();
                return;
            }

            completedOrderId = repackageHelper.addPackageFragment(stack);
            if (completedOrderId != -1)
                break;
        }

        if (completedOrderId == -1)
            return;

        List<BigItemStack> boxesToExport = repackageHelper.repack(completedOrderId, field_11863.method_8409());
        if (boxesToExport.isEmpty())
            return;

        if (computerBehaviour.hasAttachedComputer()) {
            for (BigItemStack box : boxesToExport) {
                computerBehaviour.prepareComputerEvent(new RepackageEvent(box.stack, box.count));
            }
        }

        targetInv.extract(repackageHelper.collectedPackages.get(completedOrderId));
        queuedExitingPackages.addAll(boxesToExport);
        notifyUpdate();
    }
}
