package com.zurrtum.create.content.logistics.packagerLink;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllParticleTypes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.logistics.packager.IdentifiedInventory;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.packager.PackagerBlockEntity;
import com.zurrtum.create.content.logistics.packager.PackagingRequest;
import com.zurrtum.create.content.logistics.packager.repackager.RepackagerBlockEntity;
import com.zurrtum.create.content.redstone.displayLink.LinkWithBulbBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.component.PackageOrderWithCrafts;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_4844;

public class PackagerLinkBlockEntity extends LinkWithBulbBlockEntity {

    public LogisticallyLinkedBehaviour behaviour;
    public UUID placedBy;

    public PackagerLinkBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.PACKAGER_LINK, pos, state);
        setLazyTickRate(10);
        placedBy = null;
    }

    public InventorySummary fetchSummaryFromPackager(@Nullable IdentifiedInventory ignoredHandler) {
        PackagerBlockEntity packager = getPackager();
        if (packager == null)
            return InventorySummary.EMPTY;
        if (packager.isTargetingSameInventory(ignoredHandler))
            return InventorySummary.EMPTY;
        return packager.getAvailableItems();
    }

    public void playEffect() {
        AllSoundEvents.STOCK_LINK.playAt(field_11863, field_11867, 0.75f, 1.25f, false);
        class_243 vec3 = class_243.method_24953(field_11867);

        class_2680 state = method_11010();
        float f = 1;

        class_2738 face = state.method_61767(PackagerLinkBlock.field_11007, class_2738.field_12475);
        if (face != class_2738.field_12475)
            f = -1;
        if (face == class_2738.field_12471)
            vec3 = vec3.method_1031(0, 0.25, 0);

        vec3 = vec3.method_1019(class_243.method_24954(state.method_61767(PackagerLinkBlock.field_11177, class_2350.field_11035).method_62675()).method_1021(f * 0.125));

        pulse();
        field_11863.method_8406(AllParticleTypes.WIFI, vec3.field_1352, vec3.field_1351, vec3.field_1350, 1, face == class_2738.field_12473 ? -1 : 1, 1);
    }

    public Pair<PackagerBlockEntity, PackagingRequest> processRequest(
        class_1799 stack,
        int amount,
        String address,
        int linkIndex,
        MutableBoolean finalLink,
        int orderId,
        @Nullable PackageOrderWithCrafts context,
        @Nullable IdentifiedInventory ignoredHandler
    ) {
        PackagerBlockEntity packager = getPackager();
        if (packager == null)
            return null;
        if (packager.isTargetingSameInventory(ignoredHandler))
            return null;

        InventorySummary summary = packager.getAvailableItems();
        int availableCount = summary.getCountOf(stack);
        if (availableCount == 0)
            return null;
        int toWithdraw = Math.min(amount, availableCount);
        return Pair.of(packager, PackagingRequest.create(stack, toWithdraw, address, linkIndex, finalLink, 0, orderId, context));
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        if (placedBy != null)
            view.method_71468("PlacedBy", class_4844.field_25122, placedBy);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        placedBy = view.method_71426("PlacedBy", class_4844.field_25122).orElse(null);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(behaviour = new LogisticallyLinkedBehaviour(this, true));
    }

    @Override
    public void initialize() {
        super.initialize();
        behaviour.redstonePowerChanged(PackagerLinkBlock.getPower(method_11010(), field_11863, field_11867));
        PackagerBlockEntity packager = getPackager();
        if (packager != null)
            packager.recheckIfLinksPresent();
    }

    @Nullable
    public PackagerBlockEntity getPackager() {
        class_2680 blockState = method_11010();
        if (behaviour.redstonePower == 15)
            return null;
        class_2338 source = field_11867.method_10093(PackagerLinkBlock.getConnectedDirection(blockState).method_10153());
        if (!(field_11863.method_8321(source) instanceof PackagerBlockEntity packager))
            return null;
        if (packager instanceof RepackagerBlockEntity)
            return null;
        return packager;
    }

    @Override
    public class_2350 getBulbFacing(class_2680 state) {
        return PackagerLinkBlock.getConnectedDirection(state);
    }

    private static final Map<class_2680, class_243> bulbOffsets = new HashMap<>();

    @Override
    public class_243 getBulbOffset(class_2680 state) {
        return bulbOffsets.computeIfAbsent(
            state, s -> {
                class_243 offset = VecHelper.voxelSpace(5, 6, 11);
                class_243 wallOffset = VecHelper.voxelSpace(11, 6, 5);
                class_2738 face = s.method_11654(PackagerLinkBlock.field_11007);
                class_243 vec = face == class_2738.field_12471 ? wallOffset : offset;
                float angle = AngleHelper.horizontalAngle(s.method_11654(PackagerLinkBlock.field_11177));
                if (face == class_2738.field_12473)
                    angle = -angle;
                if (face == class_2738.field_12471)
                    angle = 0;
                return VecHelper.rotateCentered(vec, angle, class_2351.field_11052);
            }
        );
    }

}
