package com.zurrtum.create.content.logistics.vault;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.api.connectivity.ConnectivityHandler;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class ItemVaultBlock extends class_2248 implements IWrenchable, IBE<ItemVaultBlockEntity>, ItemInventoryProvider<ItemVaultBlockEntity> {

    public static final class_2754<class_2351> HORIZONTAL_AXIS = class_2741.field_12529;
    public static final class_2746 LARGE = class_2746.method_11825("large");

    public ItemVaultBlock(class_2251 p_i48440_1_) {
        super(p_i48440_1_);
        method_9590(method_9564().method_11657(LARGE, false));
    }

    public class_1263 getInventory(class_1936 world, class_2338 pos, class_2680 state, ItemVaultBlockEntity blockEntity, class_2350 context) {
        if (blockEntity.itemCapability != null) {
            class_1263 inventory = blockEntity.itemCapability.get();
            if (inventory != null) {
                return inventory;
            }
        }
        blockEntity.initCapability();
        return blockEntity.itemCapability != null ? blockEntity.itemCapability.get() : null;
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> pBuilder) {
        pBuilder.method_11667(HORIZONTAL_AXIS, LARGE);
        super.method_9515(pBuilder);
    }

    @Override
    public class_2680 method_9605(class_1750 pContext) {
        if (pContext.method_8036() == null || !pContext.method_8036().method_5715()) {
            class_2680 placedOn = pContext.method_8045().method_8320(pContext.method_8037().method_10093(pContext.method_8038().method_10153()));
            class_2351 preferredAxis = getVaultBlockAxis(placedOn);
            if (preferredAxis != null)
                return this.method_9564().method_11657(HORIZONTAL_AXIS, preferredAxis);
        }
        return this.method_9564().method_11657(HORIZONTAL_AXIS, pContext.method_8042().method_10166());
    }

    @Override
    public void method_9615(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2680 pOldState, boolean pIsMoving) {
        if (pOldState.method_26204() == pState.method_26204())
            return;
        if (pIsMoving)
            return;
        withBlockEntityDo(pLevel, pPos, ItemVaultBlockEntity::updateConnectivity);
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        if (context.method_8038().method_10166().method_10178()) {
            class_2586 be = context.method_8045().method_8321(context.method_8037());
            if (be instanceof ItemVaultBlockEntity vault) {
                ConnectivityHandler.splitMulti(vault);
                vault.removeController(true);
            }
            state = state.method_11657(LARGE, false);
        }
        return IWrenchable.super.onWrenched(state, context);
    }

    @Override
    public void method_66388(class_2680 state, class_3218 world, class_2338 pos, boolean pIsMoving) {
        if (state.method_31709()) {
            class_2586 be = world.method_8321(pos);
            if (!(be instanceof ItemVaultBlockEntity vaultBE))
                return;
            class_1264.method_5451(world, pos, vaultBE.inventory);
            world.method_8544(pos);
            ConnectivityHandler.splitMulti(vaultBE);
        }
    }

    public static boolean isVault(class_2680 state) {
        return state.method_27852(AllBlocks.ITEM_VAULT);
    }

    @Nullable
    public static class_2351 getVaultBlockAxis(class_2680 state) {
        if (!isVault(state))
            return null;
        return state.method_11654(HORIZONTAL_AXIS);
    }

    public static boolean isLarge(class_2680 state) {
        if (!isVault(state))
            return false;
        return state.method_11654(LARGE);
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rot) {
        class_2351 axis = state.method_11654(HORIZONTAL_AXIS);
        return state.method_11657(HORIZONTAL_AXIS, rot.method_10503(class_2350.method_10169(axis, class_2352.field_11056)).method_10166());
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirrorIn) {
        return state;
    }

    @Override
    public boolean method_9498(class_2680 p_149740_1_) {
        return true;
    }

    @Override
    public int method_9572(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2350 direction) {
        return ItemHelper.calcRedstoneFromBlockEntity(this, pLevel, pPos);
    }

    @Override
    public class_2591<? extends ItemVaultBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.ITEM_VAULT;
    }

    @Override
    public Class<ItemVaultBlockEntity> getBlockEntityClass() {
        return ItemVaultBlockEntity.class;
    }
}
