package com.zurrtum.create.content.redstone;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.api.contraption.transformable.TransformableBlock;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import net.minecraft.class_1750;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_2383;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_2754;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectedDirectionalBlock extends class_2383 implements IWrenchable, TransformableBlock {

    public static final class_2754<class_2738> TARGET = class_2754.method_11850("target", class_2738.class);

    public static final MapCodec<DirectedDirectionalBlock> field_46280 = method_54094(DirectedDirectionalBlock::new);

    public DirectedDirectionalBlock(class_2251 pProperties) {
        super(pProperties);
        method_9590(method_9564().method_11657(TARGET, class_2738.field_12471));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515(pBuilder.method_11667(TARGET, field_11177));
    }

    @Nullable
    public class_2680 method_9605(class_1750 pContext) {
        for (class_2350 direction : pContext.method_7718()) {
            class_2680 blockstate;
            if (direction.method_10166() == class_2351.field_11052) {
                blockstate = method_9564().method_11657(TARGET, direction == class_2350.field_11036 ? class_2738.field_12473 : class_2738.field_12475)
                    .method_11657(field_11177, pContext.method_8042());
            } else {
                blockstate = method_9564().method_11657(TARGET, class_2738.field_12471).method_11657(field_11177, direction.method_10153());
            }

            return blockstate;
        }

        return null;
    }

    public static class_2350 getTargetDirection(class_2680 pState) {
        return switch (pState.method_11654(TARGET)) {
            case field_12473 -> class_2350.field_11036;
            case field_12475 -> class_2350.field_11033;
            default -> pState.method_11654(field_11177);
        };
    }

    @Override
    public class_2680 getRotatedBlockState(class_2680 originalState, class_2350 targetedFace) {
        if (targetedFace.method_10166() == class_2351.field_11052)
            return IWrenchable.super.getRotatedBlockState(originalState, targetedFace);

        class_2350 targetDirection = getTargetDirection(originalState);
        class_2350 newFacing = targetDirection.method_35833(targetedFace.method_10166());
        if (targetedFace.method_10171() == class_2352.field_11060)
            newFacing = newFacing.method_10153();

        if (newFacing.method_10166() == class_2351.field_11052)
            return originalState.method_11657(TARGET, newFacing == class_2350.field_11036 ? class_2738.field_12473 : class_2738.field_12475);
        return originalState.method_11657(TARGET, class_2738.field_12471).method_11657(field_11177, newFacing);
    }

    @Override
    public class_2680 transform(class_2680 state, StructureTransform transform) {
        if (transform.mirror != null)
            state = method_9569(state, transform.mirror);
        if (transform.rotationAxis == class_2351.field_11052)
            return method_9598(state, transform.rotation);

        class_2350 targetDirection = getTargetDirection(state);
        class_2350 newFacing = transform.rotateFacing(targetDirection);

        if (newFacing.method_10166() == class_2351.field_11052)
            return state.method_11657(TARGET, newFacing == class_2350.field_11036 ? class_2738.field_12473 : class_2738.field_12475);
        return state.method_11657(TARGET, class_2738.field_12471).method_11657(field_11177, newFacing);
    }

    @Override
    protected @NotNull MapCodec<? extends class_2383> method_53969() {
        return field_46280;
    }
}
