package com.zurrtum.create.content.redstone.analogLever;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class AnalogLeverBlockEntity extends SmartBlockEntity {

    int state = 0;
    int lastChange;
    public LerpedFloat clientState;

    public AnalogLeverBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.ANALOG_LEVER, pos, state);
        clientState = LerpedFloat.linear();
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71465("State", state);
        view.method_71465("ChangeTimer", lastChange);
        super.write(view, clientPacket);
    }


    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        state = view.method_71424("State", 0);
        lastChange = view.method_71424("ChangeTimer", 0);
        clientState.chase(state, 0.2f, Chaser.EXP);
        super.read(view, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        if (lastChange > 0) {
            lastChange--;
            if (lastChange == 0)
                updateOutput();
        }
        if (field_11863.method_8608())
            clientState.tickChaser();
    }

    @Override
    public void initialize() {
        super.initialize();

    }

    private void updateOutput() {
        AnalogLeverBlock.updateNeighbors(method_11010(), field_11863, field_11867);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    public void changeState(boolean back) {
        int prevState = state;
        state += back ? -1 : 1;
        state = class_3532.method_15340(state, 0, 15);
        if (prevState != state)
            lastChange = 15;
        sendData();
    }

    public int getState() {
        return state;
    }
}
