package com.zurrtum.create.content.redstone.displayLink;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.api.behaviour.display.DisplaySource;
import com.zurrtum.create.api.behaviour.display.DisplayTarget;
import com.zurrtum.create.api.contraption.transformable.TransformableBlockEntity;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.compat.computercraft.AbstractComputerBehaviour;
import com.zurrtum.create.compat.computercraft.ComputerCraftProxy;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelSupportBehaviour;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class DisplayLinkBlockEntity extends LinkWithBulbBlockEntity implements TransformableBlockEntity {

    public class_2338 targetOffset;

    public DisplaySource activeSource;
    private class_2487 sourceConfig;

    public DisplayTarget activeTarget;
    public int targetLine;

    public int refreshTicks;
    public AbstractComputerBehaviour computerBehaviour;
    public FactoryPanelSupportBehaviour factoryPanelSupport;

    public DisplayLinkBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.DISPLAY_LINK, pos, state);
        targetOffset = class_2338.field_10980;
        sourceConfig = new class_2487();
        targetLine = 0;
    }


    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(computerBehaviour = ComputerCraftProxy.behaviour(this));
        behaviours.add(factoryPanelSupport = new FactoryPanelSupportBehaviour(this, () -> false, () -> false, this::updateGatheredData));
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.DISPLAY_LINK, AllAdvancements.DISPLAY_BOARD);
    }

    @Override
    public void tick() {
        super.tick();

        if (isVirtual())
            return;
        if (activeSource == null)
            return;
        if (field_11863.method_8608())
            return;

        refreshTicks++;
        if (refreshTicks < activeSource.getPassiveRefreshTicks() || !activeSource.shouldPassiveReset())
            return;
        tickSource();
    }

    public void tickSource() {
        refreshTicks = 0;
        if (method_11010().method_61767(DisplayLinkBlock.POWERED, true))
            return;
        if (!field_11863.method_8608())
            updateGatheredData();
    }

    public void onNoLongerPowered() {
        if (activeSource == null)
            return;
        refreshTicks = 0;
        activeSource.onSignalReset(new DisplayLinkContext(field_11863, this));
        updateGatheredData();
    }

    public void updateGatheredData() {
        class_2338 sourcePosition = getSourcePosition();
        class_2338 targetPosition = getTargetPosition();

        if (!field_11863.method_8477(targetPosition) || !field_11863.method_8477(sourcePosition))
            return;

        DisplayTarget target = DisplayTarget.get(field_11863, targetPosition);
        List<DisplaySource> sources = DisplaySource.getAll(field_11863, sourcePosition);
        boolean notify = false;

        if (activeTarget != target) {
            activeTarget = target;
            notify = true;
        }

        if (activeSource != null && !sources.contains(activeSource)) {
            activeSource = null;
            sourceConfig = new class_2487();
            notify = true;
        }

        if (notify)
            notifyUpdate();
        if (activeSource == null || activeTarget == null)
            return;

        DisplayLinkContext context = new DisplayLinkContext(field_11863, this);
        activeSource.transferData(context, activeTarget, targetLine);
        sendPulseNextSync();
        sendData();

        award(AllAdvancements.DISPLAY_LINK);
    }

    @Override
    public void writeSafe(class_11372 view) {
        super.writeSafe(view);
        writeGatheredData(view);
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        writeGatheredData(view);
        if (clientPacket && activeTarget != null) {
            class_2960 id = CreateRegistries.DISPLAY_TARGET.method_10221(this.activeTarget);
            if (id != null) {
                view.method_71468("TargetType", class_2960.field_25139, id);
            }
        }
    }

    private void writeGatheredData(class_11372 view) {
        view.method_71468("TargetOffset", class_2338.field_25064, targetOffset);
        view.method_71465("TargetLine", targetLine);

        if (activeSource != null) {
            class_2487 data = sourceConfig.method_10553();
            class_2960 id = CreateRegistries.DISPLAY_SOURCE.method_10221(this.activeSource);
            if (id != null) {
                data.method_67494("Id", class_2960.field_25139, id);
            }
            view.method_71468("Source", class_2487.field_25128, data);
        }
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        targetOffset = view.method_71426("TargetOffset", class_2338.field_25064).orElse(class_2338.field_10980);
        targetLine = view.method_71424("TargetLine", 0);

        if (clientPacket) {
            view.method_71426("TargetType", class_2960.field_25139).ifPresent(id -> activeTarget = DisplayTarget.get(id));
        }
        view.method_71426("Source", class_2487.field_25128).ifPresent(data -> {
            activeSource = DisplaySource.get(data.method_67491("Id", class_2960.field_25139).orElse(null));
            sourceConfig = activeSource != null ? data.method_10553() : new class_2487();
        });
    }

    public void target(class_2338 targetPosition) {
        this.targetOffset = targetPosition.method_10059(field_11867);
    }

    public class_2338 getSourcePosition() {
        for (FactoryPanelPosition position : factoryPanelSupport.getLinkedPanels())
            return position.pos();
        return field_11867.method_10093(getDirection());
    }

    public class_2487 getSourceConfig() {
        return sourceConfig;
    }

    public void setSourceConfig(class_2487 sourceConfig) {
        this.sourceConfig = sourceConfig;
    }

    public class_2350 getDirection() {
        return method_11010().method_61767(DisplayLinkBlock.field_10927, class_2350.field_11036).method_10153();
    }

    public class_2338 getTargetPosition() {
        return field_11867.method_10081(targetOffset);
    }

    private static final class_243 bulbOffset = VecHelper.voxelSpace(11, 7, 5);
    private static final class_243 bulbOffsetVertical = VecHelper.voxelSpace(5, 7, 11);

    @Override
    public class_243 getBulbOffset(class_2680 state) {
        if (state.method_61767(DisplayLinkBlock.field_10927, class_2350.field_11036).method_10166().method_10178())
            return bulbOffsetVertical;
        return bulbOffset;
    }

    @Override
    public void transform(class_2586 be, StructureTransform transform) {
        targetOffset = transform.applyWithoutOffset(targetOffset);
        notifyUpdate();
    }

}
