package com.zurrtum.create.content.redstone.displayLink.source;

import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour.TransportedResult;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlockEntity;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import com.zurrtum.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_5250;
import org.apache.commons.lang3.mutable.MutableObject;

public class ItemNameDisplaySource extends SingleLineDisplaySource {
    @Override
    protected class_5250 provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
        DisplayLinkBlockEntity gatherer = context.blockEntity();
        class_2350 direction = gatherer.getDirection();
        class_2338.class_2339 pos = gatherer.getSourcePosition().method_25503();

        class_5250 combined = EMPTY_LINE.method_27661();

        for (int i = 0; i < 32; i++) {
            TransportedItemStackHandlerBehaviour behaviour = BlockEntityBehaviour.get(
                context.level(),
                pos,
                TransportedItemStackHandlerBehaviour.TYPE
            );
            pos.method_10098(direction);

            if (behaviour == null)
                break;

            MutableObject<class_1799> stackHolder = new MutableObject<>();
            behaviour.handleCenteredProcessingOnAllItems(
                .25f, tis -> {
                    stackHolder.setValue(tis.stack);
                    return TransportedResult.doNothing();
                }
            );

            class_1799 stack = stackHolder.getValue();
            if (stack != null && !stack.method_7960())
                combined = combined.method_10852(stack.method_7964());
        }

        return combined;
    }

    @Override
    protected String getTranslationKey() {
        return "combine_item_names";
    }

    @Override
    public boolean allowsLabeling(DisplayLinkContext context) {
        return true;
    }

    @Override
    protected String getFlapDisplayLayoutName(DisplayLinkContext context) {
        return "Number";
    }
}
