package com.zurrtum.create.content.redstone.displayLink.source;

import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorPackage;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import com.zurrtum.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.zurrtum.create.content.redstone.smartObserver.SmartObserverBlock;
import com.zurrtum.create.content.redstone.smartObserver.SmartObserverBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_5250;

public class PackageAddressDisplaySource extends SingleLineDisplaySource {
    @Override
    protected class_5250 provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
        class_2586 sourceBE = context.getSourceBlockEntity();
        if (!(sourceBE instanceof SmartObserverBlockEntity cobe))
            return EMPTY_LINE;

        InvManipulationBehaviour invManipulationBehaviour = cobe.getBehaviour(InvManipulationBehaviour.TYPE);
        ServerFilteringBehaviour filteringBehaviour = cobe.getBehaviour(ServerFilteringBehaviour.TYPE);
        class_1263 handler = invManipulationBehaviour.getInventory();

        if (handler == null) {
            class_2338 targetPos = cobe.method_11016().method_10093(SmartObserverBlock.getTargetDirection(cobe.method_11010()));

            if (context.level().method_8321(targetPos) instanceof ChainConveyorBlockEntity ccbe)
                for (ChainConveyorPackage box : ccbe.getLoopingPackages())
                    if (filteringBehaviour.test(box.item))
                        return class_2561.method_43470(PackageItem.getAddress(box.item));

            return EMPTY_LINE;
        }

        for (class_1799 stack : handler) {
            if (PackageItem.isPackage(stack) && filteringBehaviour.test(stack))
                return class_2561.method_43470(PackageItem.getAddress(stack));
        }

        return EMPTY_LINE;
    }

    @Override
    protected String getTranslationKey() {
        return "read_package_address";
    }

    @Override
    public boolean allowsLabeling(DisplayLinkContext context) {
        return true;
    }
}