package com.zurrtum.create.content.redstone.displayLink.source;

import com.zurrtum.create.api.behaviour.display.DisplaySource;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import com.zurrtum.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.zurrtum.create.content.trains.display.FlapDisplayBlockEntity;
import com.zurrtum.create.content.trains.display.FlapDisplayLayout;
import com.zurrtum.create.content.trains.display.FlapDisplaySection;
import org.apache.commons.lang3.mutable.MutableInt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_3722;
import net.minecraft.class_5250;

import static com.zurrtum.create.content.trains.display.FlapDisplaySection.MONOSPACE;

public abstract class ValueListDisplaySource extends DisplaySource {

    protected abstract Stream<IntAttached<class_5250>> provideEntries(DisplayLinkContext context, int maxRows);

    protected abstract boolean valueFirst();

    @Override
    public List<class_5250> provideText(DisplayLinkContext context, DisplayTargetStats stats) {
        boolean isBook = context.getTargetBlockEntity() instanceof class_3722;

        List<class_5250> list = provideEntries(
            context,
            stats.maxRows() * (isBook ? ENTRIES_PER_PAGE : 1)
        ).map(e -> createComponentsFromEntry(context, e)).map(l -> {
            class_5250 combined = l.get(0).method_10852(l.get(1));
            if (l.size() > 2)
                combined.method_10852(l.get(2));
            return combined;
        }).toList();

        if (isBook)
            list = condensePages(list);

        return list;
    }

    static final int ENTRIES_PER_PAGE = 8;

    private List<class_5250> condensePages(List<class_5250> list) {
        List<class_5250> condensed = new ArrayList<>();
        class_5250 current = null;
        for (int i = 0; i < list.size(); i++) {
            class_5250 atIndex = list.get(i);
            if (current == null) {
                current = atIndex;
                continue;
            }
            current.method_10852(class_2561.method_43470("\n")).method_10852(atIndex);
            if ((i + 1) % ENTRIES_PER_PAGE == 0) {
                condensed.add(current);
                current = null;
            }
        }

        if (current != null)
            condensed.add(current);
        return condensed;
    }

    @Override
    public List<List<class_5250>> provideFlapDisplayText(DisplayLinkContext context, DisplayTargetStats stats) {
        MutableInt highest = new MutableInt(0);
        context.flapDisplayContext = highest;
        return provideEntries(context, stats.maxRows()).map(e -> {
            highest.setValue(Math.max(highest.getValue(), e.getFirst()));
            return createComponentsFromEntry(context, e);
        }).toList();
    }

    protected List<class_5250> createComponentsFromEntry(DisplayLinkContext context, IntAttached<class_5250> entry) {
        int number = entry.getFirst();
        class_5250 name = entry.getSecond().method_10852(WHITESPACE);

        if (shortenNumbers(context)) {
            Couple<class_5250> shortened = shorten(number);
            return valueFirst() ? Arrays.asList(shortened.getFirst(), shortened.getSecond(), name) : Arrays.asList(
                name,
                shortened.getFirst(),
                shortened.getSecond()
            );
        }

        class_5250 formattedNumber = class_2561.method_43470(String.valueOf(number)).method_10852(WHITESPACE);
        return valueFirst() ? Arrays.asList(formattedNumber, name) : Arrays.asList(name, formattedNumber);
    }

    @Override
    public void loadFlapDisplayLayout(DisplayLinkContext context, FlapDisplayBlockEntity flapDisplay, FlapDisplayLayout layout) {

        boolean valueFirst = valueFirst();
        boolean shortenNumbers = shortenNumbers(context);
        int valueFormat = shortenNumbers ? 0 : Math.max(4, 1 + (int) Math.log10(((MutableInt) context.flapDisplayContext).intValue()));

        String layoutKey = "ValueList_" + valueFirst + "_" + valueFormat;
        if (layout.isLayout(layoutKey))
            return;

        int maxCharCount = flapDisplay.getMaxCharCount(1);
        int numberLength = Math.min(maxCharCount, Math.max(3, valueFormat));
        int nameLength = Math.max(maxCharCount - numberLength - (shortenNumbers ? 1 : 0), 0);

        FlapDisplaySection name = new FlapDisplaySection(MONOSPACE * nameLength, "alphabet", false, !valueFirst);
        FlapDisplaySection value = new FlapDisplaySection(MONOSPACE * numberLength, "number", false, !shortenNumbers && valueFirst).rightAligned();

        if (shortenNumbers) {
            FlapDisplaySection suffix = new FlapDisplaySection(MONOSPACE, "shortened_numbers", false, valueFirst);
            layout.configure(layoutKey, valueFirst ? Arrays.asList(value, suffix, name) : Arrays.asList(name, value, suffix));
            return;
        }

        layout.configure(layoutKey, valueFirst ? Arrays.asList(value, name) : Arrays.asList(name, value));
    }

    private Couple<class_5250> shorten(int number) {
        if (number >= 1000000) {
            return Couple.create(
                class_2561.method_43470(String.valueOf(number / 1000000)),
                class_2561.method_43471("create.display_source.value_list.million").method_10852(WHITESPACE)
            );
        }
        if (number >= 1000) {
            return Couple.create(
                class_2561.method_43470(String.valueOf(number / 1000)),
                class_2561.method_43471("create.display_source.value_list.thousand").method_10852(WHITESPACE)
            );
        }
        return Couple.create(class_2561.method_43470(String.valueOf(number)), WHITESPACE);
    }

    protected boolean shortenNumbers(DisplayLinkContext context) {
        return context.sourceConfig().method_68083("Format", 0) == 0;
    }

}