package com.zurrtum.create.content.redstone.nixieTube;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.compat.computercraft.AbstractComputerBehaviour;
import com.zurrtum.create.compat.computercraft.ComputerCraftProxy;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlock;
import com.zurrtum.create.content.trains.signal.SignalBlockEntity;
import com.zurrtum.create.content.trains.signal.SignalBlockEntity.SignalState;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.utility.DynamicComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_8824;

public class NixieTubeBlockEntity extends SmartBlockEntity {
    public static final class ComputerSignal {
        public static final class TubeDisplay {
            public static final int ENCODED_SIZE = 7;

            public byte r = 63, g = 63, b = 63;
            public byte blinkPeriod = 0, blinkOffTime = 0;
            public byte glowWidth = 1, glowHeight = 1;

            public void decode(byte[] data, int offset) {
                r = data[offset];
                g = data[offset + 1];
                b = data[offset + 2];
                blinkPeriod = data[offset + 3];
                blinkOffTime = data[offset + 4];
                glowWidth = data[offset + 5];
                glowHeight = data[offset + 6];
            }

            public void encode(byte[] data, int offset) {
                data[offset] = r;
                data[offset + 1] = g;
                data[offset + 2] = b;
                data[offset + 3] = blinkPeriod;
                data[offset + 4] = blinkOffTime;
                data[offset + 5] = glowWidth;
                data[offset + 6] = glowHeight;
            }
        }

        public @NotNull TubeDisplay first = new TubeDisplay();
        public @NotNull TubeDisplay second = new TubeDisplay();

        public void decode(byte[] encoded) {
            first.decode(encoded, 0);
            second.decode(encoded, TubeDisplay.ENCODED_SIZE);
        }

        public byte[] encode() {
            byte[] encoded = new byte[TubeDisplay.ENCODED_SIZE * 2];
            first.encode(encoded, 0);
            second.encode(encoded, TubeDisplay.ENCODED_SIZE);
            return encoded;
        }
    }


    private int redstoneStrength;
    private Optional<class_2561> customText;
    private int nixieIndex;
    private Couple<String> displayedStrings;
    private boolean keepAlive;

    public AbstractComputerBehaviour computerBehaviour;
    public @Nullable ComputerSignal computerSignal;

    private WeakReference<SignalBlockEntity> cachedSignalTE;
    public SignalState signalState;

    public NixieTubeBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.NIXIE_TUBE, pos, state);
        customText = Optional.empty();
        redstoneStrength = 0;
        cachedSignalTE = new WeakReference<>(null);
    }

    @Override
    public void tick() {
        super.tick();
        if (!field_11863.method_8608())
            return;
        signalState = null;

        if (computerBehaviour.hasAttachedComputer()) {
            if (field_11863.method_8608() && cachedSignalTE.get() != null) {
                cachedSignalTE = new WeakReference<>(null);
            }
            return;
        } else {
            computerSignal = null;
        }

        SignalBlockEntity signalBlockEntity = cachedSignalTE.get();

        if (signalBlockEntity == null || signalBlockEntity.method_11015()) {
            class_2350 facing = NixieTubeBlock.getFacing(method_11010());
            class_2586 blockEntity = field_11863.method_8321(field_11867.method_10093(facing.method_10153()));
            if (blockEntity instanceof SignalBlockEntity signal) {
                signalState = signal.getState();
                cachedSignalTE = new WeakReference<>(signal);
            }
            return;
        }

        signalState = signalBlockEntity.getState();
    }

    @Override
    public void initialize() {
        if (field_11863.method_8608())
            updateDisplayedStrings();
    }

    //

    public boolean reactsToRedstone() {
        return !computerBehaviour.hasAttachedComputer() && customText.isEmpty();
    }

    @Nullable
    public Couple<String> getDisplayedStrings() {
        return displayedStrings;
    }

    public class_5250 getFullText() {
        return customText.map(class_2561::method_27661).orElse(class_2561.method_43470("" + redstoneStrength));
    }

    public void updateRedstoneStrength(int signalStrength) {
        clearCustomText();
        redstoneStrength = signalStrength;
        DisplayLinkBlock.notifyGatherers(field_11863, field_11867);
        notifyUpdate();
    }

    public void displayCustomText(class_2561 text, int nixiePositionInRow) {
        if (text == null)
            return;
        if (customText.filter(d -> d.equals(text)).isPresent())
            return;

        customText = Optional.ofNullable(DynamicComponent.parseCustomText(field_11863, field_11867, text));
        nixieIndex = nixiePositionInRow;
        DisplayLinkBlock.notifyGatherers(field_11863, field_11867);
        notifyUpdate();
    }

    public void displayEmptyText(int nixiePositionInRow) {
        displayCustomText(class_5244.field_39003, nixiePositionInRow);
    }

    public void updateDisplayedStrings() {
        if (signalState != null || computerSignal != null)
            return;
        customText.map(class_2561::getString).ifPresentOrElse(
            fullText -> displayedStrings = Couple.create(charOrEmpty(fullText, nixieIndex * 2), charOrEmpty(fullText, nixieIndex * 2 + 1)),
            () -> displayedStrings = Couple.create(redstoneStrength < 10 ? "0" : "1", String.valueOf(redstoneStrength % 10))
        );
    }

    public void clearCustomText() {
        nixieIndex = 0;
        customText = Optional.empty();
    }

    public int getRedstoneStrength() {
        return redstoneStrength;
    }

    //

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);

        view.method_71426("CustomText", class_8824.field_46597).ifPresentOrElse(
            text -> {
                customText = Optional.of(text);
                nixieIndex = view.method_71424("CustomTextIndex", 0);
            }, () -> redstoneStrength = view.method_71424("RedstoneStrength", 0)
        );
        if (clientPacket || isVirtual()) {
            view.method_71426("ComputerSignal", Codec.BYTE_BUFFER).ifPresentOrElse(
                t -> {
                    byte[] encodedComputerSignal = t.array();
                    if (computerSignal == null)
                        computerSignal = new ComputerSignal();
                    computerSignal.decode(encodedComputerSignal);
                }, () -> computerSignal = null
            );
            updateDisplayedStrings();
        }
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);

        customText.ifPresentOrElse(
            text -> {
                view.method_71465("CustomTextIndex", nixieIndex);
                view.method_71468("CustomText", class_8824.field_46597, text);
            }, () -> view.method_71465("RedstoneStrength", redstoneStrength)
        );
        if (clientPacket && computerSignal != null) {
            view.method_71468("ComputerSignal", Codec.BYTE_BUFFER, ByteBuffer.wrap(computerSignal.encode()));
        }
    }

    private String charOrEmpty(String string, int index) {
        return string.length() <= index ? " " : string.substring(index, index + 1);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(computerBehaviour = ComputerCraftProxy.behaviour(this));
    }

    @Override
    @SuppressWarnings("deprecation")
    public void method_66473(class_2338 pos, class_2680 oldState) {
        class_2680 state = field_11863.method_8320(pos);
        if (method_11017().method_20526(state)) {
            keepAlive = true;
            method_31664(state);
        } else {
            super.method_66473(pos, oldState);
        }
    }

    @Override
    public void method_11012() {
        if (keepAlive) {
            keepAlive = false;
            field_11863.method_22350(field_11867).method_12007(this);
        } else {
            super.method_11012();
        }
    }
}
