package com.zurrtum.create.content.redstone.thresholdSwitch;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.content.redstone.DirectedDirectionalBlock;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.RedStoneConnectBlock;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.foundation.item.ItemHelper;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_2758;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class ThresholdSwitchBlock extends DirectedDirectionalBlock implements IBE<ThresholdSwitchBlockEntity>, RedStoneConnectBlock {

    public static final class_2758 LEVEL = class_2758.method_11867("level", 0, 5);

    public ThresholdSwitchBlock(class_2251 p_i48377_1_) {
        super(p_i48377_1_);
    }

    @Override
    public void method_9615(class_2680 state, class_1937 worldIn, class_2338 pos, class_2680 oldState, boolean isMoving) {
        updateObservedInventory(state, worldIn, pos);
    }

    private void updateObservedInventory(class_2680 state, class_4538 world, class_2338 pos) {
        withBlockEntityDo(world, pos, ThresholdSwitchBlockEntity::updateCurrentLevel);
    }

    @Override
    public boolean canConnectRedstone(class_2680 state, class_2350 side) {
        return side != null && side.method_10153() != getTargetDirection(state);
    }

    @Override
    public boolean method_9506(class_2680 state) {
        return true;
    }

    @Override
    public int method_9524(class_2680 blockState, class_1922 blockAccess, class_2338 pos, class_2350 side) {
        if (side == getTargetDirection(blockState).method_10153())
            return 0;
        return getBlockEntityOptional(blockAccess, pos).filter(ThresholdSwitchBlockEntity::isPowered).map($ -> 15).orElse(0);
    }

    @Override
    public void method_9588(class_2680 blockState, class_3218 world, class_2338 pos, class_5819 random) {
        getBlockEntityOptional(world, pos).ifPresent(ThresholdSwitchBlockEntity::updatePowerAfterDelay);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder.method_11667(LEVEL));
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (player != null && stack.method_31574(AllItems.WRENCH))
            return class_1269.field_52423;
        if (level.method_8608()) {
            withBlockEntityDo(
                level, pos, be -> {
                    AllClientHandle.INSTANCE.openThresholdSwitchScreen(be, player);
                }
            );
        }
        return class_1269.field_5812;
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2680 state = method_9564();

        class_2350 preferredFacing = null;
        for (class_2350 face : context.method_7718()) {
            class_2586 be = context.method_8045().method_8321(context.method_8037().method_10093(face));
            if (be != null && (ItemHelper.getInventory(
                be.method_10997(),
                be.method_11016(),
                null,
                be,
                null
            ) != null || FluidHelper.hasFluidInventory(be.method_10997(), be.method_11016(), null, be, null))) {
                preferredFacing = face;
                break;
            }
        }

        if (preferredFacing == null) {
            class_2350 facing = context.method_7715();
            preferredFacing = context.method_8036() != null && context.method_8036().method_5715() ? facing : facing.method_10153();
        }

        if (preferredFacing.method_10166() == class_2351.field_11052) {
            state = state.method_11657(TARGET, preferredFacing == class_2350.field_11036 ? class_2738.field_12473 : class_2738.field_12475);
            preferredFacing = context.method_8042();
        }

        return state.method_11657(field_11177, preferredFacing);
    }

    @Override
    public Class<ThresholdSwitchBlockEntity> getBlockEntityClass() {
        return ThresholdSwitchBlockEntity.class;
    }

    @Override
    public class_2591<? extends ThresholdSwitchBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.THRESHOLD_SWITCH;
    }

}
