package com.zurrtum.create.content.redstone.thresholdSwitch;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.zurrtum.create.content.processing.recipe.ProcessingInventory;
import com.zurrtum.create.content.redstone.DirectedDirectionalBlock;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.CapManipulationBehaviourBase.InterfaceProvider;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.TankManipulationBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1953;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class ThresholdSwitchBlockEntity extends SmartBlockEntity {

    public int onWhenAbove;
    public int offWhenBelow;

    public int currentMinLevel;
    public int currentLevel;
    public int currentMaxLevel;
    public boolean inStacks;

    private boolean redstoneState;
    private boolean inverted;
    private boolean poweredAfterDelay;

    private ServerFilteringBehaviour filtering;
    private InvManipulationBehaviour observedInventory;
    private TankManipulationBehaviour observedTank;
    private VersionedInventoryTrackerBehaviour invVersionTracker;

    //TODO
    //    private static final List<ThresholdSwitchCompat> COMPAT = List.of(new FunctionalStorage(), new SophisticatedStorage(), new StorageDrawers());

    public ThresholdSwitchBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.THRESHOLD_SWITCH, pos, state);
        onWhenAbove = 128;
        offWhenBelow = 64;
        currentLevel = -1;
        redstoneState = false;
        inverted = false;
        poweredAfterDelay = false;
        setLazyTickRate(10);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        onWhenAbove = view.method_71424("OnAboveAmount", 0);
        offWhenBelow = view.method_71424("OffBelowAmount", 0);
        currentLevel = view.method_71424("CurrentAmount", 0);
        currentMinLevel = view.method_71424("CurrentMinAmount", 0);
        currentMaxLevel = view.method_71424("CurrentMaxAmount", 0);
        inStacks = view.method_71433("InStacks", false);
        redstoneState = view.method_71433("Powered", false);
        inverted = view.method_71433("Inverted", false);
        poweredAfterDelay = view.method_71433("PoweredAfterDelay", false);
        super.read(view, clientPacket);
    }

    protected void writeCommon(class_11372 view) {
        view.method_71464("OnAboveAmount", onWhenAbove);
        view.method_71464("OffBelowAmount", offWhenBelow);
        view.method_71472("Inverted", inverted);
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        writeCommon(view);
        view.method_71465("CurrentAmount", currentLevel);
        view.method_71465("CurrentMinAmount", currentMinLevel);
        view.method_71465("CurrentMaxAmount", currentMaxLevel);
        view.method_71472("InStacks", inStacks);
        view.method_71472("Powered", redstoneState);
        view.method_71472("PoweredAfterDelay", poweredAfterDelay);
        super.write(view, clientPacket);
    }

    @Override
    public void writeSafe(class_11372 view) {
        writeCommon(view);
        super.writeSafe(view);
    }

    public int getMinLevel() {
        return currentMinLevel;
    }

    public int getStockLevel() {
        return currentLevel;
    }

    public int getMaxLevel() {
        return currentMaxLevel;
    }

    public void updateCurrentLevel() {
        boolean changed = false;
        int prevLevel = currentLevel;
        int prevMaxLevel = currentMaxLevel;

        class_2338 target = getTargetPos();
        class_2586 targetBlockEntity = field_11863.method_8321(target);

        observedInventory.findNewCapability();
        observedTank.findNewCapability();

        if (targetBlockEntity instanceof ThresholdSwitchObservable observable) {
            currentMinLevel = observable.getMinValue();
            currentLevel = observable.getCurrentValue();
            currentMaxLevel = observable.getMaxValue();

		/*} else if (StorageDrawers.isDrawer(targetBlockEntity) && observedInventory.hasInventory()) {
			currentMinLevel = 0;
			currentLevel = StorageDrawers.getItemCount(observedInventory.getInventory(), filtering);
			currentMaxLevel = StorageDrawers.getTotalStorageSpace(observedInventory.getInventory());
		*/

        } else if (observedInventory.hasInventory() || observedTank.hasInventory()) {
            currentMinLevel = 0;
            currentLevel = 0;
            currentMaxLevel = 0;

            if (observedInventory.hasInventory()) {

                // Item inventory
                class_1263 inv = observedInventory.getInventory();
                if (invVersionTracker.stillWaiting(inv)) {
                    currentLevel = prevLevel;
                    currentMaxLevel = prevMaxLevel;

                } else {
                    invVersionTracker.awaitNewVersion(inv);
                    for (int slot = 0, size = inv.method_5439(); slot < size; slot++) {
                        class_1799 stackInSlot = inv.method_5438(slot);
                        int space = stackInSlot.method_7960() ? 64 : inv.method_58350(stackInSlot);
                        if (space == 0)
                            continue;

                        currentMaxLevel += space;
                        if (filtering.test(stackInSlot))
                            currentLevel += stackInSlot.method_7947();
                    }
                }
            }

            if (observedTank.hasInventory()) {
                // Fluid inventory
                FluidInventory tank = observedTank.getInventory();
                for (int slot = 0, size = tank.size(); slot < size; slot++) {
                    FluidStack stackInSlot = tank.getStack(slot);
                    int space = tank.getMaxAmount(stackInSlot);
                    if (space == 0)
                        continue;

                    currentMaxLevel += space;
                    if (filtering.test(stackInSlot))
                        currentLevel += stackInSlot.getAmount();
                }
            }

        } else {
            // No compatible inventories found
            currentMinLevel = -1;
            currentMaxLevel = -1;
            if (currentLevel == -1)
                return;

            field_11863.method_8652(field_11867, method_11010().method_11657(ThresholdSwitchBlock.LEVEL, 0), class_2248.field_31036);
            currentLevel = -1;
            redstoneState = false;
            sendData();
            scheduleBlockTick();
            return;
        }

        currentLevel = class_3532.method_15340(currentLevel, currentMinLevel, currentMaxLevel);
        changed = currentLevel != prevLevel;

        boolean previouslyPowered = redstoneState;
        if (redstoneState && currentLevel <= offWhenBelow)
            redstoneState = false;
        else if (!redstoneState && currentLevel >= onWhenAbove)
            redstoneState = true;
        boolean update = previouslyPowered != redstoneState;

        int displayLevel = 0;
        float normedLevel = (float) (currentLevel - currentMinLevel) / (currentMaxLevel - currentMinLevel);
        if (currentLevel > 0)
            displayLevel = (int) (1 + normedLevel * 4);
        field_11863.method_8652(field_11867, method_11010().method_11657(ThresholdSwitchBlock.LEVEL, displayLevel), update ? 3 : 2);

        if (update)
            scheduleBlockTick();

        if (changed || update) {
            DisplayLinkBlock.notifyGatherers(field_11863, field_11867);
            notifyUpdate();
        }
    }

    private boolean isSuitableInventory(class_2586 be) {
        return be != null && !(be instanceof StockTickerBlockEntity || ItemHelper.getInventory(
            field_11863,
            be.method_11016(),
            null,
            be,
            null
        ) instanceof ProcessingInventory);
    }

    public class_2338 getTargetPos() {
        return field_11867.method_10093(ThresholdSwitchBlock.getTargetDirection(method_11010()));
    }

    public class_1799 getDisplayItemForScreen() {
        class_2338 target = getTargetPos();
        return new class_1799(field_11863.method_8320(target).method_26204());
    }

    public static enum ThresholdType {
        UNSUPPORTED,
        ITEM,
        FLUID,
        CUSTOM;
    }

    public ThresholdType getTypeOfCurrentTarget() {
        if (observedInventory.hasInventory())
            return ThresholdType.ITEM;
        if (observedTank.hasInventory())
            return ThresholdType.FLUID;
        if (field_11863.method_8321(getTargetPos()) instanceof ThresholdSwitchObservable)
            return ThresholdType.CUSTOM;
        return ThresholdType.UNSUPPORTED;
    }

    protected void scheduleBlockTick() {
        class_2248 block = method_11010().method_26204();
        if (!field_11863.method_8397().method_8677(field_11867, block))
            field_11863.method_64311(field_11867, block, 2, class_1953.field_9314);
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (field_11863.method_8608())
            return;
        updateCurrentLevel();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(filtering = new ServerFilteringBehaviour(this).withCallback($ -> {
            this.updateCurrentLevel();
            invVersionTracker.reset();
        }));

        behaviours.add(invVersionTracker = new VersionedInventoryTrackerBehaviour(this));

        InterfaceProvider towardBlockFacing = (w, p, s) -> new BlockFace(p, DirectedDirectionalBlock.getTargetDirection(s));

        behaviours.add(observedInventory = new InvManipulationBehaviour(this, towardBlockFacing).bypassSidedness()
            .withFilter(this::isSuitableInventory));
        behaviours.add(observedTank = new TankManipulationBehaviour(this, towardBlockFacing).bypassSidedness());
    }

    public float getLevelForDisplay() {
        return currentLevel == -1 ? 0 : currentLevel;
    }

    public boolean getState() {
        return redstoneState;
    }

    public boolean shouldBePowered() {
        return inverted != redstoneState;
    }

    public void updatePowerAfterDelay() {
        poweredAfterDelay = shouldBePowered();
        field_11863.method_8408(field_11867, method_11010().method_26204());
        sendData();
    }

    public boolean isPowered() {
        return poweredAfterDelay;
    }

    public boolean isInverted() {
        return inverted;
    }

    public void setInverted(boolean inverted) {
        if (inverted == this.inverted)
            return;
        this.inverted = inverted;
        updatePowerAfterDelay();
    }
}
