package com.zurrtum.create.content.schematics.cannon;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.Create;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity.CasingType;
import com.zurrtum.create.content.kinetics.belt.BeltPart;
import com.zurrtum.create.content.kinetics.belt.BeltSlope;
import com.zurrtum.create.content.kinetics.belt.item.BeltConnectorItem;
import com.zurrtum.create.content.kinetics.simpleRelays.AbstractSimpleShaftBlock;
import com.zurrtum.create.foundation.utility.BlockHelper;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_7871;
import net.minecraft.class_8942;

public abstract class LaunchedItem {

    public int totalTicks;
    public int ticksRemaining;
    public class_2338 target;
    public class_1799 stack;

    private LaunchedItem(class_2338 start, class_2338 target, class_1799 stack) {
        this(target, stack, ticksForDistance(start, target), ticksForDistance(start, target));
    }

    private static int ticksForDistance(class_2338 start, class_2338 target) {
        return (int) (Math.max(10, Math.sqrt(Math.sqrt(target.method_10262(start))) * 4f));
    }

    LaunchedItem() {
    }

    private LaunchedItem(class_2338 target, class_1799 stack, int ticksLeft, int total) {
        this.target = target;
        this.stack = stack;
        this.totalTicks = total;
        this.ticksRemaining = ticksLeft;
    }

    public boolean update(class_1937 world) {
        if (ticksRemaining > 0) {
            ticksRemaining--;
            return false;
        }
        if (world.method_8608())
            return false;

        place(world);
        return true;
    }

    public void write(class_11372 view) {
        view.method_71465("TotalTicks", totalTicks);
        view.method_71465("TicksLeft", ticksRemaining);
        if (!stack.method_7960()) {
            view.method_71468("Stack", class_1799.field_24671, stack);
        }
        view.method_71468("Target", class_2338.field_25064, target);
    }

    public static LaunchedItem from(class_11368 view, class_7871<class_2248> holderGetter) {
        LaunchedItem item = ForBelt.from(view, holderGetter);
        if (item != null) {
            return item;
        }
        item = ForBlockState.from(view, holderGetter);
        if (item != null) {
            return item;
        }
        item = new LaunchedItem.ForEntity();
        item.read(view, holderGetter);
        return item;
    }

    abstract void place(class_1937 world);

    void read(class_11368 view, class_7871<class_2248> holderGetter) {
        target = view.method_71426("Target", class_2338.field_25064).orElse(class_2338.field_10980);
        ticksRemaining = view.method_71424("TicksLeft", 0);
        totalTicks = view.method_71424("TotalTicks", 0);
        stack = view.method_71426("Stack", class_1799.field_24671).orElse(class_1799.field_8037);
    }

    public static class ForBlockState extends LaunchedItem {
        public class_2680 state;
        public class_2487 data;

        ForBlockState() {
        }

        public ForBlockState(class_2338 start, class_2338 target, class_1799 stack, class_2680 state, class_2487 data) {
            super(start, target, stack);
            this.state = state;
            this.data = data;
        }

        @Override
        public void write(class_11372 view) {
            super.write(view);
            view.method_71468("BlockState", class_2680.field_24734, state);
            if (data != null) {
                data.method_10551("x");
                data.method_10551("y");
                data.method_10551("z");
                data.method_10551("id");
                view.method_71468("Data", class_2487.field_25128, data);
            }
        }

        public static LaunchedItem from(class_11368 view, class_7871<class_2248> holderGetter) {
            return view.method_71426("BlockState", class_2680.field_24734).map(state -> {
                ForBlockState result = new ForBlockState();
                result.read(view, holderGetter, state);
                return result;
            }).orElse(null);
        }

        @Override
        void read(class_11368 view, class_7871<class_2248> holderGetter) {
            read(view, holderGetter, view.method_71426("BlockState", class_2680.field_24734).orElseGet(class_2246.field_10124::method_9564));
        }

        private void read(class_11368 view, class_7871<class_2248> holderGetter, class_2680 state) {
            super.read(view, holderGetter);
            this.state = state;
            view.method_71426("Data", class_2487.field_25128).ifPresent(nbt -> data = nbt);
        }

        @Override
        void place(class_1937 world) {
            BlockHelper.placeSchematicBlock(world, state, target, stack, data);
        }

    }

    public static class ForBelt extends ForBlockState {
        public int length;
        public CasingType[] casings;

        public ForBelt() {
        }

        @Override
        public void write(class_11372 view) {
            super.write(view);
            view.method_71468("Length", Codec.INT, length);
            view.method_71473("Casing", Arrays.stream(casings).mapToInt(CasingType::ordinal).toArray());
        }

        public static LaunchedItem from(class_11368 view, class_7871<class_2248> holderGetter) {
            return view.method_71426("Length", Codec.INT).map(length -> {
                ForBelt result = new ForBelt();
                result.read(view, holderGetter, length);
                return result;
            }).orElse(null);
        }

        @Override
        void read(class_11368 view, class_7871<class_2248> holderGetter) {
            read(view, holderGetter, view.method_71426("Length", Codec.INT).orElse(0));
        }

        private void read(class_11368 view, class_7871<class_2248> holderGetter, int length) {
            this.length = length;
            int[] intArray = view.method_71442("Casing").orElseGet(() -> new int[0]);
            casings = new CasingType[length];
            for (int i = 0; i < casings.length; i++)
                casings[i] = i >= intArray.length ? CasingType.NONE : CasingType.values()[class_3532.method_15340(
                    intArray[i],
                    0,
                    CasingType.values().length - 1
                )];
            super.read(view, holderGetter);
        }

        public ForBelt(class_2338 start, class_2338 target, class_1799 stack, class_2680 state, CasingType[] casings) {
            super(start, target, stack, state, null);
            this.casings = casings;
            this.length = casings.length;
        }

        @Override
        void place(class_1937 world) {
            boolean isStart = state.method_11654(BeltBlock.PART) == BeltPart.START;
            class_2338 offset = BeltBlock.nextSegmentPosition(state, class_2338.field_10980, isStart);
            int i = length - 1;
            class_2351 axis = state.method_11654(BeltBlock.SLOPE) == BeltSlope.SIDEWAYS ? class_2351.field_11052 : state.method_11654(BeltBlock.HORIZONTAL_FACING).method_10170()
                .method_10166();
            world.method_8501(target, AllBlocks.SHAFT.method_9564().method_11657(AbstractSimpleShaftBlock.AXIS, axis));
            BeltConnectorItem.createBelts(world, target, target.method_10069(offset.method_10263() * i, offset.method_10264() * i, offset.method_10260() * i));

            for (int segment = 0; segment < length; segment++) {
                if (casings[segment] == CasingType.NONE)
                    continue;
                class_2338 casingTarget = target.method_10069(offset.method_10263() * segment, offset.method_10264() * segment, offset.method_10260() * segment);
                if (world.method_8321(casingTarget) instanceof BeltBlockEntity bbe)
                    bbe.setCasingType(casings[segment]);
            }
        }

    }

    public static class ForEntity extends LaunchedItem {
        public class_1297 entity;
        private class_2487 deferredTag;

        ForEntity() {
        }

        public ForEntity(class_2338 start, class_2338 target, class_1799 stack, class_1297 entity) {
            super(start, target, stack);
            this.entity = entity;
        }

        @Override
        public boolean update(class_1937 world) {
            if (deferredTag != null && entity == null) {
                try {
                    try (class_8942.class_11340 logging = new class_8942.class_11340(() -> "LaunchedItem.ForEntity", Create.LOGGER)) {
                        class_11368 view = class_11352.method_71417(logging, world.method_30349(), deferredTag);
                        Optional<class_1297> loadEntityUnchecked = class_1299.method_5892(view, world, class_3730.field_52444);
                        if (loadEntityUnchecked.isEmpty())
                            return true;
                        entity = loadEntityUnchecked.get();
                    }
                } catch (Exception var3) {
                    return true;
                }
                deferredTag = null;
            }
            return super.update(world);
        }

        @Override
        public void write(class_11372 view) {
            super.write(view);
            if (entity != null) {
                class_11372 data = view.method_71461("Entity");
                class_1299<?> entityType = entity.method_5864();
                class_2960 id = class_1299.method_5890(entityType);
                if (id != null && entityType.method_5893()) {
                    data.method_71469("id", id.toString());
                }
                entity.method_5647(data);
            }
        }

        @Override
        void read(class_11368 view, class_7871<class_2248> holderGetter) {
            super.read(view, holderGetter);
            view.method_71426("Entity", class_2487.field_25128).ifPresent(nbt -> deferredTag = nbt);
        }

        @Override
        void place(class_1937 world) {
            if (entity != null)
                world.method_8649(entity);
        }

    }

}
