package com.zurrtum.create.content.schematics.requirement;

import com.zurrtum.create.api.schematic.requirement.SchematicRequirementRegistries;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockEntityItemRequirement;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.zurrtum.create.api.schematic.requirement.SpecialEntityItemRequirement;
import com.zurrtum.create.catnip.components.ComponentProcessors;
import net.minecraft.block.*;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_1533;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2185;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2344;
import net.minecraft.class_2369;
import net.minecraft.class_2472;
import net.minecraft.class_2488;
import net.minecraft.class_2542;
import net.minecraft.class_2573;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2771;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ItemRequirement {
    public static final ItemRequirement NONE = new ItemRequirement(Collections.emptyList());
    public static final ItemRequirement INVALID = new ItemRequirement(Collections.emptyList());

    protected List<StackRequirement> requiredItems;

    public ItemRequirement(List<StackRequirement> requiredItems) {
        this.requiredItems = requiredItems;
    }

    public ItemRequirement(StackRequirement stackRequirement) {
        this(List.of(stackRequirement));
    }

    public ItemRequirement(ItemUseType usage, class_1799 stack) {
        this(new StackRequirement(stack, usage));
    }

    public ItemRequirement(ItemUseType usage, class_1792 item) {
        this(usage, new class_1799(item));
    }

    public ItemRequirement(ItemUseType usage, List<class_1799> requiredItems) {
        this(requiredItems.stream().map(req -> new StackRequirement(req, usage)).collect(Collectors.toList()));
    }

    public static ItemRequirement of(class_2680 state, @Nullable class_2586 be) {
        class_2248 block = state.method_26204();

        ItemRequirement requirement;
        SchematicRequirementRegistries.BlockRequirement blockRequirement = SchematicRequirementRegistries.BLOCKS.get(block);
        if (blockRequirement != null) {
            requirement = blockRequirement.getRequiredItems(state, be);
        } else if (block instanceof SpecialBlockItemRequirement specialBlock) {
            requirement = specialBlock.getRequiredItems(state, be);
        } else {
            requirement = defaultOf(state, be);
        }

        if (be != null) {
            SchematicRequirementRegistries.BlockEntityRequirement beRequirement = SchematicRequirementRegistries.BLOCK_ENTITIES.get(be.method_11017());
            if (beRequirement != null) {
                requirement = requirement.union(beRequirement.getRequiredItems(be, state));
            } else if (be instanceof SpecialBlockEntityItemRequirement specialBE) {
                requirement = requirement.union(specialBE.getRequiredItems(state));
                //TODO
                //            } else if (com.simibubi.create.compat.Mods.FRAMEDBLOCKS.contains(block)) {
                //                requirement = requirement.union(FramedBlocksInSchematics.getRequiredItems(state, be));
            }
        }

        return requirement;
    }

    private static ItemRequirement defaultOf(class_2680 state, class_2586 be) {
        class_2248 block = state.method_26204();
        if (block == class_2246.field_10124)
            return NONE;

        class_1792 item = block.method_8389();
        if (item == class_1802.field_8162)
            return INVALID;

        // double slab needs two items
        if (state.method_28498(class_2741.field_12485) && state.method_11654(class_2741.field_12485) == class_2771.field_12682)
            return new ItemRequirement(ItemUseType.CONSUME, new class_1799(item, 2));
        if (block instanceof class_2542)
            return new ItemRequirement(ItemUseType.CONSUME, new class_1799(item, state.method_11654(class_2542.field_11710)));
        if (block instanceof class_2472)
            return new ItemRequirement(ItemUseType.CONSUME, new class_1799(item, state.method_11654(class_2472.field_11472)));
        if (block instanceof class_2488)
            return new ItemRequirement(ItemUseType.CONSUME, new class_1799(item, state.method_11654(class_2488.field_11518).intValue()));
        // FD's rich soil extends FarmBlock so this is to make sure the cost is correct (it should be rich soil not dirt)
        //TODO
        //        if (block == BuiltInRegistries.BLOCK.get(Mods.FD.asResource("rich_soil_farmland")))
        //            return new ItemRequirement(
        //                ItemUseType.CONSUME,
        //                BuiltInRegistries.ITEM.get(Mods.FD.asResource("rich_soil"))
        //            );
        if (block instanceof class_2344 || block instanceof class_2369)
            return new ItemRequirement(ItemUseType.CONSUME, class_1802.field_8831);
        if (block instanceof class_2185 && be instanceof class_2573 bannerBE)
            return new ItemRequirement(new StrictNbtStackRequirement(bannerBE.method_10907(), ItemUseType.CONSUME));
        // Tall grass doesnt exist as a block so use 2 grass blades
        if (block == class_2246.field_10214)
            return new ItemRequirement(ItemUseType.CONSUME, new class_1799(class_1802.field_8602, 2));
        // Large ferns don't exist as blocks so use 2 ferns instead
        if (block == class_2246.field_10313)
            return new ItemRequirement(ItemUseType.CONSUME, new class_1799(class_1802.field_8471, 2));

        return new ItemRequirement(ItemUseType.CONSUME, item);
    }

    public static ItemRequirement of(class_1297 entity) {
        SchematicRequirementRegistries.EntityRequirement requirement = SchematicRequirementRegistries.ENTITIES.get(entity.method_5864());
        if (requirement != null) {
            return requirement.getRequiredItems(entity);
        } else if (entity instanceof SpecialEntityItemRequirement specialEntity) {
            return specialEntity.getRequiredItems();
        }

        if (entity instanceof class_1533 itemFrame) {
            class_1799 frame = itemFrame.method_33340();
            class_1799 displayedItem = ComponentProcessors.withUnsafeComponentsDiscarded(itemFrame.method_6940());
            if (displayedItem.method_7960())
                return new ItemRequirement(ItemUseType.CONSUME, frame);
            return new ItemRequirement(List.of(
                new ItemRequirement.StackRequirement(frame, ItemUseType.CONSUME),
                new ItemRequirement.StrictNbtStackRequirement(displayedItem, ItemUseType.CONSUME)
            ));
        }

        if (entity instanceof class_1531 armorStand) {
            List<StackRequirement> requirements = new ArrayList<>();
            requirements.add(new StackRequirement(new class_1799(class_1802.field_8694), ItemUseType.CONSUME));
            for (class_1304 equipmentSlot : class_1304.field_54086) {
                class_1799 itemStack = armorStand.method_6118(equipmentSlot);
                requirements.add(new StrictNbtStackRequirement(ComponentProcessors.withUnsafeComponentsDiscarded(itemStack), ItemUseType.CONSUME));
            }
            return new ItemRequirement(requirements);
        }

        return INVALID;
    }

    public boolean isEmpty() {
        return NONE == this;
    }

    public boolean isInvalid() {
        return INVALID == this;
    }

    public List<StackRequirement> getRequiredItems() {
        return requiredItems;
    }

    public ItemRequirement union(ItemRequirement other) {
        if (this.isInvalid() || other.isInvalid())
            return INVALID;
        if (this.isEmpty())
            return other;
        if (other.isEmpty())
            return this;

        return new ItemRequirement(Stream.concat(requiredItems.stream(), other.requiredItems.stream()).collect(Collectors.toList()));
    }

    public enum ItemUseType {
        CONSUME,
        DAMAGE
    }

    public static class StackRequirement {
        public final class_1799 stack;
        public final ItemUseType usage;

        public StackRequirement(class_1799 stack, ItemUseType usage) {
            this.stack = stack;
            this.usage = usage;
        }

        public boolean matches(class_1799 other) {
            return class_1799.method_7984(stack, other);
        }
    }

    public static class StrictNbtStackRequirement extends StackRequirement {
        public StrictNbtStackRequirement(class_1799 stack, ItemUseType usage) {
            super(stack, usage);
        }

        @Override
        public boolean matches(class_1799 other) {
            return class_1799.method_31577(stack, other);
        }
    }
}