package com.zurrtum.create.content.trains.bogey;

import com.zurrtum.create.AllBogeyStyles;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.foundation.blockEntity.CachedRenderBBBlockEntity;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

import static com.zurrtum.create.content.trains.entity.CarriageBogey.UPSIDE_DOWN_KEY;

public abstract class AbstractBogeyBlockEntity extends CachedRenderBBBlockEntity {
    public static final String BOGEY_STYLE_KEY = "BogeyStyle";
    public static final String BOGEY_DATA_KEY = "BogeyData";

    private class_2487 bogeyData;

    public AbstractBogeyBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public abstract BogeyStyle getDefaultStyle();

    public class_2487 getBogeyData() {
        if (bogeyData == null || !bogeyData.method_10545(BOGEY_STYLE_KEY))
            bogeyData = createBogeyData();
        return bogeyData;
    }

    public void setBogeyData(@NotNull class_2487 newData) {
        if (!newData.method_10545(BOGEY_STYLE_KEY)) {
            newData.method_67494(BOGEY_STYLE_KEY, class_2960.field_25139, getDefaultStyle().id);
        }
        bogeyData = newData;
    }

    public void setBogeyStyle(@NotNull BogeyStyle style) {
        getBogeyData().method_67494(BOGEY_STYLE_KEY, class_2960.field_25139, style.id);
        markUpdated();
    }

    @NotNull
    public BogeyStyle getStyle() {
        class_2487 data = getBogeyData();
        class_2960 currentStyle = data.method_67491(BOGEY_STYLE_KEY, class_2960.field_25139).orElseThrow();
        BogeyStyle style = AllBogeyStyles.BOGEY_STYLES.get(currentStyle);
        if (style == null) {
            setBogeyStyle(getDefaultStyle());
            return getStyle();
        }
        return style;
    }

    @Override
    protected void method_11007(class_11372 view) {
        class_2487 data = this.getBogeyData();
        if (data != null)
            view.method_71468(BOGEY_DATA_KEY, class_2487.field_25128, data); // Now contains style
        super.method_11007(view);
    }

    @Override
    protected void method_11014(class_11368 view) {
        bogeyData = view.method_71426(BOGEY_DATA_KEY, class_2487.field_25128).orElseGet(this::createBogeyData);
        super.method_11014(view);
    }

    private class_2487 createBogeyData() {
        class_2487 nbt = new class_2487();
        nbt.method_67494(BOGEY_STYLE_KEY, class_2960.field_25139, getDefaultStyle().id);
        boolean upsideDown = false;
        if (method_11010().method_26204() instanceof AbstractBogeyBlock<?> bogeyBlock)
            upsideDown = bogeyBlock.isUpsideDown(method_11010());
        nbt.method_10556(UPSIDE_DOWN_KEY, upsideDown);
        return nbt;
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return super.createRenderBoundingBox().method_1014(2);
    }

    // Ponder
    LerpedFloat virtualAnimation = LerpedFloat.angular();

    public float getVirtualAngle(float partialTicks) {
        return virtualAnimation.getValue(partialTicks);
    }

    public void animate(float distanceMoved) {
        class_2680 blockState = method_11010();
        if (!(blockState.method_26204() instanceof AbstractBogeyBlock<?> type))
            return;
        double angleDiff = 360 * distanceMoved / (Math.PI * 2 * type.getWheelRadius());
        double newWheelAngle = (virtualAnimation.getValue() - angleDiff) % 360;
        virtualAnimation.setValue(newWheelAngle);
    }

    private void markUpdated() {
        method_5431();
        class_1937 level = method_10997();
        if (level != null)
            level.method_8413(method_11016(), method_11010(), method_11010(), 3);
    }
}
