package com.zurrtum.create.content.trains.observer;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.contraption.transformable.TransformableBlockEntity;
import com.zurrtum.create.compat.computercraft.AbstractComputerBehaviour;
import com.zurrtum.create.compat.computercraft.ComputerCraftProxy;
import com.zurrtum.create.compat.computercraft.events.TrainPassEvent;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlock;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class TrackObserverBlockEntity extends SmartBlockEntity implements TransformableBlockEntity {

    public TrackTargetingBehaviour<TrackObserver> edgePoint;

    private ServerFilteringBehaviour filtering;

    public AbstractComputerBehaviour computerBehaviour;
    public @org.jetbrains.annotations.Nullable UUID passingTrainUUID;

    public TrackObserverBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.TRACK_OBSERVER, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(edgePoint = new TrackTargetingBehaviour<>(this, EdgePointType.OBSERVER));
        behaviours.add(filtering = new ServerFilteringBehaviour(this).withCallback(this::onFilterChanged));
        behaviours.add(computerBehaviour = ComputerCraftProxy.behaviour(this));
    }

    private void onFilterChanged(class_1799 newFilter) {
        if (field_11863.method_8608())
            return;
        TrackObserver observer = getObserver();
        if (observer != null)
            observer.setFilterAndNotify(field_11863, newFilter);
    }

    @Override
    public void tick() {
        super.tick();

        if (field_11863.method_8608())
            return;

        boolean shouldBePowered = false;
        TrackObserver observer = getObserver();
        if (observer != null)
            shouldBePowered = observer.isActivated();
        if (isBlockPowered() == shouldBePowered)
            return;

        if (observer != null && computerBehaviour.hasAttachedComputer()) {
            if (shouldBePowered)
                passingTrainUUID = observer.getCurrentTrain();
            if (passingTrainUUID != null) {
                computerBehaviour.prepareComputerEvent(new TrainPassEvent(Create.RAILWAYS.trains.get(passingTrainUUID), shouldBePowered));
                if (!shouldBePowered)
                    passingTrainUUID = null;
            }
        }

        class_2680 blockState = method_11010();
        if (blockState.method_28498(TrackObserverBlock.POWERED))
            field_11863.method_8652(field_11867, blockState.method_11657(TrackObserverBlock.POWERED, shouldBePowered), class_2248.field_31036);
        DisplayLinkBlock.notifyGatherers(field_11863, field_11867);
    }

    @Nullable
    public TrackObserver getObserver() {
        return edgePoint.getEdgePoint();
    }

    public class_1799 getFilter() {
        return filtering.getFilter();
    }

    public boolean isBlockPowered() {
        return method_11010().method_61767(TrackObserverBlock.POWERED, false);
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(class_243.method_24954(field_11867), class_243.method_24954(edgePoint.getGlobalPosition())).method_1014(2);
    }

    @Override
    public void transform(class_2586 be, StructureTransform transform) {
        edgePoint.transform(be, transform);
    }
}
