package com.zurrtum.create.content.trains.schedule.condition;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.AllSchedules;
import com.zurrtum.create.Create;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.schedule.ScheduleDataEntry;
import com.zurrtum.create.content.trains.schedule.destination.NbtReadContext;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_8942;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public abstract class ScheduleWaitCondition extends ScheduleDataEntry {
    public static final class_9139<class_9129, ScheduleWaitCondition> STREAM_CODEC = class_9139.method_56437(
        ScheduleWaitCondition::encode,
        ScheduleWaitCondition::decode
    );

    public ScheduleWaitCondition(class_2960 id) {
        super(id);
    }

    public abstract boolean tickCompletion(class_1937 level, Train train, class_2487 context);

    protected void requestStatusToUpdate(class_2487 context) {
        context.method_10569("StatusVersion", context.method_68083("StatusVersion", 0) + 1);
    }

    public final void write(class_11372 view) {
        view.method_71468("Id", class_2960.field_25139, id);
        try (class_8942.class_11340 logging = new class_8942.class_11340(() -> "ScheduleWaitCondition", Create.LOGGER)) {
            class_11362 writeView = new class_11362(logging, ((class_11362) view).field_60403, data);
            writeAdditional(writeView);
            view.method_71468("Data", class_2487.field_25128, writeView.method_71475());
        }
    }

    @SuppressWarnings("unchecked")
    public static <T> DataResult<T> encode(final ScheduleWaitCondition input, final DynamicOps<T> ops, final T empty) {
        RecordBuilder<T> map = ops.mapBuilder();
        map.add("Id", input.id, class_2960.field_25139);
        try (class_8942.class_11340 logging = new class_8942.class_11340(() -> "ScheduleWaitCondition", Create.LOGGER)) {
            class_11362 view = new class_11362(logging, (DynamicOps<class_2520>) ops, input.data);
            input.writeAdditional(view);
            map.add("Data", view.method_71475(), class_2487.field_25128);
        }
        return map.build(empty);
    }

    public static ScheduleWaitCondition read(class_11368 view) {
        class_2960 location = view.method_71426("Id", class_2960.field_25139).orElse(null);
        ScheduleWaitCondition condition = AllSchedules.createScheduleWaitCondition(location);
        if (condition == null) {
            return fallback(location);
        }
        class_11368 data = view.method_71434("Data");
        condition.readAdditional(data);
        condition.data = view.method_71426("Data", class_2487.field_25128).orElseGet(class_2487::new);
        return condition;
    }

    public static <T> ScheduleWaitCondition decode(DynamicOps<T> ops, T input) {
        MapLike<T> map = ops.getMap(input).getOrThrow();
        class_2960 location = class_2960.field_25139.parse(ops, map.get("Id")).result().orElse(null);
        ScheduleWaitCondition condition = AllSchedules.createScheduleWaitCondition(location);
        if (condition == null) {
            return fallback(location);
        }
        condition.data = class_2487.field_25128.parse(ops, map.get("Data")).result().orElseGet(class_2487::new);
        try (class_8942.class_11340 logging = new class_8942.class_11340(() -> "ScheduleWaitCondition", Create.LOGGER)) {
            class_11352 view = new class_11352(logging, new NbtReadContext(ops), condition.data);
            condition.readAdditional(view);
        }
        return condition;
    }

    private static ScheduleWaitCondition fallback(class_2960 location) {
        Create.LOGGER.warn("Could not parse waiting condition type: {}", location);
        return null;
    }

    private static void encode(class_9129 buf, ScheduleWaitCondition value) {
        try (class_8942.class_11340 logging = new class_8942.class_11340(() -> "ScheduleWaitCondition", Create.LOGGER)) {
            class_11362 view = class_11362.method_71459(logging, buf.method_56349());
            value.write(view);
            buf.method_10794(view.method_71475());
        }
    }

    private static ScheduleWaitCondition decode(class_9129 buf) {
        try (class_8942.class_11340 logging = new class_8942.class_11340(() -> "ScheduleWaitCondition", Create.LOGGER)) {
            class_11368 view = class_11352.method_71417(logging, buf.method_56349(), buf.method_10798());
            return ScheduleWaitCondition.read(view);
        }
    }

    public abstract class_5250 getWaitingStatus(class_1937 level, Train train, class_2487 tag);

}
