package com.zurrtum.create.content.trains.station;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.logistics.depot.SharedDepotBlockMethods;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class StationBlock extends class_2248 implements IBE<StationBlockEntity>, ItemInventoryProvider<StationBlockEntity>, IWrenchable, ProperWaterloggedBlock {

    public static final class_2746 ASSEMBLING = class_2746.method_11825("assembling");

    public StationBlock(class_2251 p_54120_) {
        super(p_54120_);
        method_9590(method_9564().method_11657(ASSEMBLING, false).method_11657(WATERLOGGED, false));
    }

    @Override
    public class_1263 getInventory(class_1936 world, class_2338 pos, class_2680 state, StationBlockEntity blockEntity, class_2350 context) {
        return blockEntity.depotBehaviour.itemHandler;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515(pBuilder.method_11667(ASSEMBLING, WATERLOGGED));
    }

    @Override
    public class_2680 method_9605(class_1750 pContext) {
        return withWater(super.method_9605(pContext), pContext);
    }

    @Override
    public class_2680 method_9559(
        class_2680 pState,
        class_4538 pLevel,
        class_10225 tickView,
        class_2338 pCurrentPos,
        class_2350 pDirection,
        class_2338 pNeighborPos,
        class_2680 pNeighborState,
        class_5819 random
    ) {
        updateWater(pLevel, tickView, pState, pCurrentPos);
        return pState;
    }

    @Override
    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1309 pPlacer, class_1799 pStack) {
        super.method_9567(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    @Override
    public class_3610 method_9545(class_2680 pState) {
        return fluidState(pState);
    }

    @Override
    public boolean method_9498(class_2680 pState) {
        return true;
    }

    @Override
    public int method_9572(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2350 direction) {
        return getBlockEntityOptional(pLevel, pPos).map(ste -> ste.trainPresent ? 15 : 0).orElse(0);
    }

    @Override
    public void method_9502(class_1922 worldIn, class_1297 entityIn) {
        super.method_9502(worldIn, entityIn);
        SharedDepotBlockMethods.onLanded(worldIn, entityIn);
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (player == null || player.method_5715())
            return class_1269.field_52423;
        if (stack.method_31574(AllItems.WRENCH))
            return class_1269.field_52423;

        if (stack.method_7909() == class_1802.field_8204) {
            return onBlockEntityUseItemOn(
                level, pos, station -> {
                    if (level.method_8608())
                        return class_1269.field_5812;

                    if (station.getStation() == null || station.getStation().getId() == null)
                        return class_1269.field_5814;

                    class_22 savedData = class_1806.method_8001(stack, level);
                    if (!(savedData instanceof StationMapData stationMapData))
                        return class_1269.field_5814;

                    if (!stationMapData.create$toggleStation(level, pos, station))
                        return class_1269.field_5814;

                    return class_1269.field_5812;
                }
            );
        }

        class_1269 result = onBlockEntityUse(
            level, pos, station -> {
                class_1799 autoSchedule = station.getAutoSchedule();
                if (autoSchedule.method_7960())
                    return class_1269.field_5811;
                if (level.method_8608())
                    return class_1269.field_5812;
                player.method_31548().method_7398(autoSchedule.method_7972());
                station.depotBehaviour.removeHeldItem();
                station.notifyUpdate();
                player.method_73183().method_8396(
                    null,
                    player.method_24515(),
                    class_3417.field_15197,
                    class_3419.field_15248,
                    .2f,
                    1f + player.method_73183().field_9229.method_43057()
                );
                return class_1269.field_5812;
            }
        );

        if (result == class_1269.field_5811)
            AllClientHandle.INSTANCE.openStationScreen(level, pos, player);
        return class_1269.field_5812;
    }

    @Override
    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return AllShapes.STATION;
    }

    @Override
    public Class<StationBlockEntity> getBlockEntityClass() {
        return StationBlockEntity.class;
    }

    @Override
    public class_2591<? extends StationBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.TRACK_STATION;
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

}
