package com.zurrtum.create.content.trains.station;

import com.zurrtum.create.*;
import com.zurrtum.create.api.contraption.transformable.TransformableBlockEntity;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.WorldAttached;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.compat.computercraft.AbstractComputerBehaviour;
import com.zurrtum.create.compat.computercraft.ComputerCraftProxy;
import com.zurrtum.create.compat.computercraft.events.StationTrainPresenceEvent;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.decoration.slidingDoor.DoorControlBehaviour;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.logistics.depot.DepotBehaviour;
import com.zurrtum.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.zurrtum.create.content.logistics.packagePort.postbox.PostboxBlockEntity;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlock;
import com.zurrtum.create.content.trains.bogey.AbstractBogeyBlock;
import com.zurrtum.create.content.trains.bogey.AbstractBogeyBlockEntity;
import com.zurrtum.create.content.trains.entity.*;
import com.zurrtum.create.content.trains.graph.*;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation.DiscoveredLocation;
import com.zurrtum.create.content.trains.schedule.Schedule;
import com.zurrtum.create.content.trains.schedule.ScheduleItem;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.packet.s2c.AddTrainPacket;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4844;
import net.minecraft.class_8824;
import net.minecraft.util.math.*;
import org.jetbrains.annotations.Nullable;

import java.lang.ref.WeakReference;
import java.util.*;
import java.util.function.Consumer;

public class StationBlockEntity extends SmartBlockEntity implements TransformableBlockEntity {

    public TrackTargetingBehaviour<GlobalStation> edgePoint;
    public DoorControlBehaviour doorControls;
    public LerpedFloat flag;

    public int failedCarriageIndex;
    public AssemblyException lastException;
    public DepotBehaviour depotBehaviour;
    public AbstractComputerBehaviour computerBehaviour;

    // for display
    public UUID imminentTrain;
    public boolean trainPresent;
    public boolean trainBackwards;
    public boolean trainCanDisassemble;
    public boolean trainHasSchedule;
    public boolean trainHasAutoSchedule;

    public int flagYRot = -1;
    public boolean flagFlipped;

    public class_2561 lastDisassembledTrainName;
    public int lastDisassembledMapColorIndex;

    public StationBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.TRACK_STATION, pos, state);
        setLazyTickRate(20);
        lastException = null;
        failedCarriageIndex = -1;
        flag = LerpedFloat.linear().startWithValue(0);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(edgePoint = new TrackTargetingBehaviour<>(this, EdgePointType.STATION));
        behaviours.add(doorControls = new DoorControlBehaviour(this));
        behaviours.add(depotBehaviour = new DepotBehaviour(this).onlyAccepts(stack -> stack.method_31574(AllItems.SCHEDULE))
            .withCallback(s -> applyAutoSchedule()));
        depotBehaviour.addSubBehaviours(behaviours);
        behaviours.add(computerBehaviour = ComputerCraftProxy.behaviour(this));
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.CONTRAPTION_ACTORS, AllAdvancements.TRAIN, AllAdvancements.LONG_TRAIN, AllAdvancements.CONDUCTOR);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        lastException = AssemblyException.read(view);
        failedCarriageIndex = view.method_71424("FailedCarriageIndex", 0);
        super.read(view, clientPacket);
        invalidateRenderBoundingBox();

        trainPresent = view.method_71433("ForceFlag", false);
        lastDisassembledTrainName = view.method_71426("PrevTrainName", class_8824.field_46597).orElse(null);
        lastDisassembledMapColorIndex = view.method_71424("PrevTrainColor", 0);

        if (!clientPacket)
            return;
        view.method_71426("ImminentTrain", class_4844.field_25122).ifPresentOrElse(
            uuid -> {
                imminentTrain = uuid;
                trainPresent = view.method_71433("TrainPresent", false);
                trainCanDisassemble = view.method_71433("TrainCanDisassemble", false);
                trainBackwards = view.method_71433("TrainBackwards", false);
                trainHasSchedule = view.method_71433("TrainHasSchedule", false);
                trainHasAutoSchedule = view.method_71433("TrainHasAutoSchedule", false);
            }, () -> {
                imminentTrain = null;
                trainPresent = false;
                trainCanDisassemble = false;
                trainBackwards = false;
            }
        );
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        AssemblyException.write(view, lastException);
        view.method_71465("FailedCarriageIndex", failedCarriageIndex);

        if (lastDisassembledTrainName != null)
            view.method_71468("PrevTrainName", class_8824.field_46597, lastDisassembledTrainName);
        view.method_71465("PrevTrainColor", lastDisassembledMapColorIndex);

        super.write(view, clientPacket);

        if (!clientPacket)
            return;
        if (imminentTrain == null)
            return;

        view.method_71468("ImminentTrain", class_4844.field_25122, imminentTrain);

        if (trainPresent)
            view.method_71472("TrainPresent", true);
        if (trainCanDisassemble)
            view.method_71472("TrainCanDisassemble", true);
        if (trainBackwards)
            view.method_71472("TrainBackwards", true);
        if (trainHasSchedule)
            view.method_71472("TrainHasSchedule", true);
        if (trainHasAutoSchedule)
            view.method_71472("TrainHasAutoSchedule", true);
    }

    @Nullable
    public GlobalStation getStation() {
        return edgePoint.getEdgePoint();
    }

    // Train Assembly

    public static WorldAttached<Map<class_2338, class_3341>> assemblyAreas = new WorldAttached<>(w -> new HashMap<>());

    public class_2350 assemblyDirection;
    public int assemblyLength;
    public int[] bogeyLocations;
    AbstractBogeyBlock<?>[] bogeyTypes;
    boolean[] upsideDownBogeys;
    public int bogeyCount;

    @Override
    public void lazyTick() {
        if (isAssembling() && !field_11863.method_8608())
            refreshAssemblyInfo();
        super.lazyTick();
    }

    @Override
    public void tick() {
        if (isAssembling() && field_11863.method_8608())
            refreshAssemblyInfo();
        super.tick();

        if (field_11863.method_8608()) {
            float currentTarget = flag.getChaseTarget();
            if (currentTarget == 0 || flag.settled()) {
                int target = trainPresent || isAssembling() ? 1 : 0;
                if (target != currentTarget) {
                    flag.chase(target, 0.1f, Chaser.LINEAR);
                    if (target == 1)
                        AllSoundEvents.CONTRAPTION_DISASSEMBLE.playAt(field_11863, field_11867, 1, 2, true);
                }
            }
            boolean settled = flag.getValue() > .15f;
            flag.tickChaser();
            if (currentTarget == 0 && settled != flag.getValue() > .15f)
                AllSoundEvents.CONTRAPTION_ASSEMBLE.playAt(field_11863, field_11867, 0.75f, 1.5f, true);
            return;
        }

        GlobalStation station = getStation();
        if (station == null)
            return;

        Train imminentTrain = station.getImminentTrain();
        boolean trainPresent = imminentTrain != null && imminentTrain.getCurrentStation() == station;
        boolean canDisassemble = trainPresent && imminentTrain.canDisassemble();
        UUID imminentID = imminentTrain != null ? imminentTrain.id : null;
        boolean trainHasSchedule = trainPresent && imminentTrain.runtime.getSchedule() != null;
        boolean trainHasAutoSchedule = trainHasSchedule && imminentTrain.runtime.isAutoSchedule;
        boolean newlyArrived = this.trainPresent != trainPresent;

        if (trainPresent && imminentTrain.runtime.displayLinkUpdateRequested) {
            DisplayLinkBlock.notifyGatherers(field_11863, field_11867);
            imminentTrain.runtime.displayLinkUpdateRequested = false;
        }

        if (!field_11863.method_8608() && computerBehaviour.hasAttachedComputer()) {
            if (this.imminentTrain == null && imminentTrain != null)
                computerBehaviour.prepareComputerEvent(new StationTrainPresenceEvent(StationTrainPresenceEvent.Type.IMMINENT, imminentTrain));
            if (newlyArrived) {
                if (trainPresent)
                    computerBehaviour.prepareComputerEvent(new StationTrainPresenceEvent(StationTrainPresenceEvent.Type.ARRIVAL, imminentTrain));
                else
                    computerBehaviour.prepareComputerEvent(new StationTrainPresenceEvent(
                        StationTrainPresenceEvent.Type.DEPARTURE,
                        Create.RAILWAYS.trains.get(this.imminentTrain)
                    ));
            }
        }

        if (newlyArrived)
            applyAutoSchedule();

        if (newlyArrived || this.trainCanDisassemble != canDisassemble || !Objects.equals(
            imminentID,
            this.imminentTrain
        ) || this.trainHasSchedule != trainHasSchedule || this.trainHasAutoSchedule != trainHasAutoSchedule) {

            this.imminentTrain = imminentID;
            this.trainPresent = trainPresent;
            this.trainCanDisassemble = canDisassemble;
            this.trainBackwards = imminentTrain != null && imminentTrain.currentlyBackwards;
            this.trainHasSchedule = trainHasSchedule;
            this.trainHasAutoSchedule = trainHasAutoSchedule;

            notifyUpdate();
        }
    }

    public boolean trackClicked(class_1657 player, class_1268 hand, ITrackBlock track, class_2680 state, class_2338 pos) {
        refreshAssemblyInfo();
        class_3341 bb = assemblyAreas.get(field_11863).get(this.field_11867);
        if (bb == null || !bb.method_14662(pos))
            return false;

        class_2338 up = class_2338.method_49638(track.getUpNormal(field_11863, pos, state));
        class_2338 down = class_2338.method_49638(track.getUpNormal(field_11863, pos, state).method_1021(-1));
        int bogeyOffset = pos.method_65076(edgePoint.getGlobalPosition()) - 1;

        if (!isValidBogeyOffset(bogeyOffset)) {
            for (boolean upsideDown : Iterate.falseAndTrue) {
                for (int i = -1; i <= 1; i++) {
                    class_2338 bogeyPos = pos.method_10079(assemblyDirection, i).method_10081(upsideDown ? down : up);
                    class_2680 blockState = field_11863.method_8320(bogeyPos);
                    if (!(blockState.method_26204() instanceof AbstractBogeyBlock<?> bogey))
                        continue;
                    class_2586 be = field_11863.method_8321(bogeyPos);
                    if (!(be instanceof AbstractBogeyBlockEntity oldBE))
                        continue;
                    class_2487 oldData = oldBE.getBogeyData();
                    class_2680 newBlock = bogey.getNextSize(oldBE);
                    if (newBlock.method_26204() == bogey)
                        player.method_7353(class_2561.method_43471("create.bogey.style.no_other_sizes").method_27692(class_124.field_1061), true);
                    field_11863.method_8652(bogeyPos, newBlock, class_2248.field_31036);
                    class_2586 newEntity = field_11863.method_8321(bogeyPos);
                    if (!(newEntity instanceof AbstractBogeyBlockEntity newBE))
                        continue;
                    newBE.setBogeyData(oldData);
                    IWrenchable.playRotateSound(field_11863, bogeyPos);
                    return true;
                }
            }

            return false;
        }

        class_1799 handItem = player.method_5998(hand);
        if (!player.method_68878() && !handItem.method_31574(AllItems.RAILWAY_CASING)) {
            player.method_7353(class_2561.method_43471("create.train_assembly.requires_casing"), true);
            return false;
        }

        boolean upsideDown = (player.method_61414(1.0F) < 0 && (track.getBogeyAnchor(
            field_11863,
            pos,
            state
        )).method_26204() instanceof AbstractBogeyBlock<?> bogey && bogey.canBeUpsideDown());

        class_2338 targetPos = upsideDown ? pos.method_10081(down) : pos.method_10081(up);
        if (field_11863.method_8320(targetPos).method_26214(field_11863, targetPos) == -1) {
            return false;
        }

        field_11863.method_22352(targetPos, true);

        class_2680 bogeyAnchor = track.getBogeyAnchor(field_11863, pos, state);
        if (bogeyAnchor.method_26204() instanceof AbstractBogeyBlock<?> bogey) {
            bogeyAnchor = bogey.getVersion(bogeyAnchor, upsideDown);
        }
        bogeyAnchor = ProperWaterloggedBlock.withWater(field_11863, bogeyAnchor, pos);
        field_11863.method_8652(targetPos, bogeyAnchor, class_2248.field_31036);
        player.method_7353(class_2561.method_43471("create.train_assembly.bogey_created"), true);
        class_2498 soundtype = bogeyAnchor.method_26231();
        field_11863.method_8396(
            null,
            pos,
            soundtype.method_10598(),
            class_3419.field_15245,
            (soundtype.method_10597() + 1.0F) / 2.0F,
            soundtype.method_10599() * 0.8F
        );

        if (!player.method_68878()) {
            class_1799 itemInHand = player.method_5998(hand);
            itemInHand.method_7934(1);
            if (itemInHand.method_7960())
                player.method_6122(hand, class_1799.field_8037);
        }

        return true;
    }

    public boolean enterAssemblyMode(@Nullable class_3222 sender) {
        if (isAssembling())
            return false;

        tryDisassembleTrain(sender);
        if (!tryEnterAssemblyMode())
            return false;

        // Check the station wasn't destroyed
        if (!(field_11863.method_8320(field_11867).method_26204() instanceof StationBlock))
            return true;

        class_2680 newState = method_11010().method_11657(StationBlock.ASSEMBLING, true);
        field_11863.method_8652(method_11016(), newState, class_2248.field_31036);
        refreshBlockState();
        refreshAssemblyInfo();

        updateStationState(station -> station.assembling = true);
        GlobalStation station = getStation();
        if (station != null) {
            for (Train train : Create.RAILWAYS.sided(field_11863).trains.values()) {
                if (train.navigation.destination != station)
                    continue;

                DiscoveredPath preferredPath = train.runtime.startCurrentInstruction(field_11863);
                train.navigation.startNavigation(preferredPath != null ? preferredPath : train.navigation.findPathTo(station, Double.MAX_VALUE));
            }
        }

        return true;
    }

    public boolean exitAssemblyMode() {
        if (!isAssembling())
            return false;

        cancelAssembly();
        class_2680 newState = method_11010().method_11657(StationBlock.ASSEMBLING, false);
        field_11863.method_8652(method_11016(), newState, class_2248.field_31036);
        refreshBlockState();

        return updateStationState(station -> station.assembling = false);
    }

    public boolean tryDisassembleTrain(@Nullable class_3222 sender) {
        GlobalStation station = getStation();
        if (station == null)
            return false;

        Train train = station.getPresentTrain();
        if (train == null)
            return false;

        class_2338 trackPosition = edgePoint.getGlobalPosition();
        if (!train.disassemble(sender, getAssemblyDirection(), trackPosition.method_10084()))
            return false;

        dropSchedule(sender, train);
        return true;
    }

    public boolean isAssembling() {
        class_2680 state = method_11010();
        return state.method_28498(StationBlock.ASSEMBLING) && state.method_11654(StationBlock.ASSEMBLING);
    }

    public boolean tryEnterAssemblyMode() {
        if (!edgePoint.hasValidTrack())
            return false;

        class_2338 targetPosition = edgePoint.getGlobalPosition();
        class_2680 trackState = edgePoint.getTrackBlockState();
        ITrackBlock track = edgePoint.getTrack();
        class_243 trackAxis = track.getTrackAxes(field_11863, targetPosition, trackState).get(0);

        boolean axisFound = false;
        for (class_2351 axis : Iterate.axes) {
            if (trackAxis.method_18043(axis) == 0)
                continue;
            if (axisFound)
                return false;
            axisFound = true;
        }

        return true;
    }

    public void dropSchedule(@Nullable class_3222 sender, @Nullable Train train) {
        GlobalStation station = getStation();
        if (station == null)
            return;
        if (train == null)
            return;

        class_1799 schedule = train.runtime.returnSchedule(field_11863.method_30349());
        if (schedule.method_7960())
            return;
        if (sender != null && sender.method_6047().method_7960()) {
            sender.method_31548().method_7398(schedule);
            return;
        }

        class_243 v = VecHelper.getCenterOf(method_11016());
        class_1542 itemEntity = new class_1542(method_10997(), v.field_1352, v.field_1351, v.field_1350, schedule);
        itemEntity.method_18799(class_243.field_1353);
        method_10997().method_8649(itemEntity);
    }

    public void updateMapColor(int color) {
        GlobalStation station = getStation();
        if (station == null)
            return;

        Train train = station.getPresentTrain();
        if (train == null)
            return;

        train.mapColorIndex = color;
    }

    private boolean updateStationState(Consumer<GlobalStation> updateState) {
        GlobalStation station = getStation();
        TrackGraphLocation graphLocation = edgePoint.determineGraphLocation();
        if (station == null || graphLocation == null)
            return false;

        updateState.accept(station);
        Create.RAILWAYS.sync.pointAdded(graphLocation.graph, station);
        Create.RAILWAYS.markTracksDirty();
        return true;
    }

    public void refreshAssemblyInfo() {
        if (!edgePoint.hasValidTrack())
            return;

        if (!isVirtual()) {
            GlobalStation station = getStation();
            if (station == null || station.getPresentTrain() != null)
                return;
        }

        int prevLength = assemblyLength;
        class_2338 targetPosition = edgePoint.getGlobalPosition();
        class_2680 trackState = edgePoint.getTrackBlockState();
        ITrackBlock track = edgePoint.getTrack();
        getAssemblyDirection();

        class_2338.class_2339 currentPos = targetPosition.method_25503();
        currentPos.method_10098(assemblyDirection);

        class_2338 bogeyOffset = class_2338.method_49638(track.getUpNormal(field_11863, targetPosition, trackState));

        int MAX_LENGTH = AllConfigs.server().trains.maxAssemblyLength.get();
        int MAX_BOGEY_COUNT = AllConfigs.server().trains.maxBogeyCount.get();

        int bogeyIndex = 0;
        int maxBogeyCount = MAX_BOGEY_COUNT;
        if (bogeyLocations == null)
            bogeyLocations = new int[maxBogeyCount];
        if (bogeyTypes == null)
            bogeyTypes = new AbstractBogeyBlock[maxBogeyCount];
        if (upsideDownBogeys == null)
            upsideDownBogeys = new boolean[maxBogeyCount];
        Arrays.fill(bogeyLocations, -1);
        Arrays.fill(bogeyTypes, null);
        Arrays.fill(upsideDownBogeys, false);

        for (int i = 0; i < MAX_LENGTH; i++) {
            if (i == MAX_LENGTH - 1) {
                assemblyLength = i;
                break;
            }
            if (!track.trackEquals(trackState, field_11863.method_8320(currentPos))) {
                assemblyLength = Math.max(0, i - 1);
                break;
            }

            class_2680 potentialBogeyState = field_11863.method_8320(bogeyOffset.method_10081(currentPos));
            class_2338 upsideDownBogeyOffset = new class_2338(bogeyOffset.method_10263(), bogeyOffset.method_10264() * -1, bogeyOffset.method_10260());
            if (bogeyIndex < bogeyLocations.length) {
                if (potentialBogeyState.method_26204() instanceof AbstractBogeyBlock<?> bogey && !bogey.isUpsideDown(potentialBogeyState)) {
                    bogeyTypes[bogeyIndex] = bogey;
                    bogeyLocations[bogeyIndex] = i;
                    upsideDownBogeys[bogeyIndex] = false;
                    bogeyIndex++;
                } else if ((potentialBogeyState = field_11863.method_8320(upsideDownBogeyOffset.method_10081(currentPos))).method_26204() instanceof AbstractBogeyBlock<?> bogey && bogey.isUpsideDown(
                    potentialBogeyState)) {
                    bogeyTypes[bogeyIndex] = bogey;
                    bogeyLocations[bogeyIndex] = i;
                    upsideDownBogeys[bogeyIndex] = true;
                    bogeyIndex++;
                }
            }

            currentPos.method_10098(assemblyDirection);
        }

        bogeyCount = bogeyIndex;

        if (field_11863.method_8608())
            return;
        if (prevLength == assemblyLength)
            return;
        if (isVirtual())
            return;

        Map<class_2338, class_3341> map = assemblyAreas.get(field_11863);
        class_2338 startPosition = targetPosition.method_10093(assemblyDirection);
        class_2338 trackEnd = startPosition.method_10079(assemblyDirection, assemblyLength - 1);
        map.put(field_11867, class_3341.method_34390(startPosition, trackEnd));
    }

    public boolean updateName(String name) {
        if (!updateStationState(station -> station.name = name))
            return false;
        notifyUpdate();

        return true;
    }

    public boolean isValidBogeyOffset(int i) {
        if ((i < 3 || bogeyCount == 0) && i != 0)
            return false;
        for (int j : bogeyLocations) {
            if (j == -1)
                break;
            if (i >= j - 2 && i <= j + 2)
                return false;
        }
        return true;
    }

    public class_2350 getAssemblyDirection() {
        if (assemblyDirection != null)
            return assemblyDirection;
        if (!edgePoint.hasValidTrack())
            return null;
        class_2338 targetPosition = edgePoint.getGlobalPosition();
        class_2680 trackState = edgePoint.getTrackBlockState();
        ITrackBlock track = edgePoint.getTrack();
        class_2352 axisDirection = edgePoint.getTargetDirection();
        class_243 axis = track.getTrackAxes(field_11863, targetPosition, trackState).get(0).method_1029().method_1021(axisDirection.method_10181());
        return assemblyDirection = class_2350.method_10142(axis.field_1352, axis.field_1351, axis.field_1350);
    }

    @Override
    public void remove() {
        assemblyAreas.get(field_11863).remove(field_11867);
        super.remove();
    }

    public void assemble(UUID playerUUID) {
        refreshAssemblyInfo();

        if (bogeyLocations == null)
            return;

        if (bogeyLocations[0] != 0) {
            exception(new AssemblyException(class_2561.method_43471("create.train_assembly.frontmost_bogey_at_station")), -1);
            return;
        }

        if (!edgePoint.hasValidTrack())
            return;

        class_2338 trackPosition = edgePoint.getGlobalPosition();
        class_2680 trackState = edgePoint.getTrackBlockState();
        ITrackBlock track = edgePoint.getTrack();
        class_2338 bogeyOffset = class_2338.method_49638(track.getUpNormal(field_11863, trackPosition, trackState));

        TrackNodeLocation location = null;
        class_243 center = class_243.method_24955(trackPosition).method_1031(0, track.getElevationAtCenter(field_11863, trackPosition, trackState), 0);
        Collection<DiscoveredLocation> ends = track.getConnected(field_11863, trackPosition, trackState, true, null);
        class_243 targetOffset = class_243.method_24954(assemblyDirection.method_62675());
        for (DiscoveredLocation end : ends)
            if (class_3532.method_20390(0, targetOffset.method_1025(end.getLocation().method_1020(center).method_1029())))
                location = end;
        if (location == null)
            return;

        List<Double> pointOffsets = new ArrayList<>();
        int iPrevious = -100;
        for (int i = 0; i < bogeyLocations.length; i++) {
            int loc = bogeyLocations[i];
            if (loc == -1)
                break;

            if (loc - iPrevious < 3) {
                exception(new AssemblyException(class_2561.method_43469("create.train_assembly.bogeys_too_close", i, i + 1)), -1);
                return;
            }

            double bogeySize = bogeyTypes[i].getWheelPointSpacing();
            pointOffsets.add(loc + .5 - bogeySize / 2);
            pointOffsets.add(loc + .5 + bogeySize / 2);
            iPrevious = loc;
        }

        List<TravellingPoint> points = new ArrayList<>();
        class_243 directionVec = class_243.method_24954(assemblyDirection.method_62675());
        TrackGraph graph = null;
        TrackNode secondNode = null;

        for (int j = 0; j < assemblyLength * 2 + 40; j++) {
            double i = j / 2d;
            if (points.size() == pointOffsets.size())
                break;

            TrackNodeLocation currentLocation = location;
            location = new TrackNodeLocation(location.getLocation().method_1019(directionVec.method_1021(.5))).in(location.dimension);

            if (graph == null)
                graph = Create.RAILWAYS.getGraph(currentLocation);
            if (graph == null)
                continue;
            TrackNode node = graph.locateNode(currentLocation);
            if (node == null)
                continue;

            for (int pointIndex = points.size(); pointIndex < pointOffsets.size(); pointIndex++) {
                double offset = pointOffsets.get(pointIndex);
                if (offset > i)
                    break;
                double positionOnEdge = i - offset;

                Map<TrackNode, TrackEdge> connectionsFromNode = graph.getConnectionsFrom(node);

                if (secondNode == null)
                    for (Map.Entry<TrackNode, TrackEdge> entry : connectionsFromNode.entrySet()) {
                        TrackEdge edge = entry.getValue();
                        TrackNode otherNode = entry.getKey();
                        if (edge.isTurn())
                            continue;
                        class_243 edgeDirection = edge.getDirection(true);
                        if (class_3532.method_20390(edgeDirection.method_1029().method_1026(directionVec), -1d))
                            secondNode = otherNode;
                    }

                if (secondNode == null) {
                    Create.LOGGER.warn("Cannot assemble: No valid starting node found");
                    return;
                }

                TrackEdge edge = connectionsFromNode.get(secondNode);

                if (edge == null) {
                    Create.LOGGER.warn("Cannot assemble: Missing graph edge");
                    return;
                }

                points.add(new TravellingPoint(node, secondNode, edge, positionOnEdge, false));
            }

            secondNode = node;
        }

        if (points.size() != pointOffsets.size()) {
            Create.LOGGER.warn("Cannot assemble: Not all Points created");
            return;
        }

        if (points.size() == 0) {
            exception(new AssemblyException(class_2561.method_43471("create.train_assembly.no_bogeys")), -1);
            return;
        }

        List<CarriageContraption> contraptions = new ArrayList<>();
        List<Carriage> carriages = new ArrayList<>();
        List<Integer> spacing = new ArrayList<>();
        boolean atLeastOneForwardControls = false;

        for (int bogeyIndex = 0; bogeyIndex < bogeyCount; bogeyIndex++) {
            int pointIndex = bogeyIndex * 2;
            if (bogeyIndex > 0)
                spacing.add(bogeyLocations[bogeyIndex] - bogeyLocations[bogeyIndex - 1]);
            CarriageContraption contraption = new CarriageContraption(assemblyDirection);
            class_2338 bogeyPosOffset = trackPosition.method_10081(bogeyOffset);
            class_2338 upsideDownBogeyPosOffset = trackPosition.method_10081(new class_2338(bogeyOffset.method_10263(), bogeyOffset.method_10264() * -1, bogeyOffset.method_10260()));

            try {
                int offset = bogeyLocations[bogeyIndex] + 1;
                boolean success = contraption.assemble(
                    field_11863,
                    upsideDownBogeys[bogeyIndex] ? upsideDownBogeyPosOffset.method_10079(assemblyDirection, offset) : bogeyPosOffset.method_10079(
                        assemblyDirection,
                        offset
                    )
                );
                atLeastOneForwardControls |= contraption.hasForwardControls();
                contraption.setSoundQueueOffset(offset);
                if (!success) {
                    exception(new AssemblyException(class_2561.method_43469("create.train_assembly.nothing_attached", bogeyIndex + 1)), -1);
                    return;
                }
            } catch (AssemblyException e) {
                exception(e, contraptions.size() + 1);
                return;
            }

            AbstractBogeyBlock<?> typeOfFirstBogey = bogeyTypes[bogeyIndex];
            boolean firstBogeyIsUpsideDown = upsideDownBogeys[bogeyIndex];
            class_2338 firstBogeyPos = contraption.anchor;
            AbstractBogeyBlockEntity firstBogeyBlockEntity = (AbstractBogeyBlockEntity) field_11863.method_8321(firstBogeyPos);
            CarriageBogey firstBogey = new CarriageBogey(
                typeOfFirstBogey,
                firstBogeyIsUpsideDown,
                firstBogeyBlockEntity.getBogeyData(),
                points.get(pointIndex),
                points.get(pointIndex + 1)
            );
            CarriageBogey secondBogey = null;
            class_2338 secondBogeyPos = contraption.getSecondBogeyPos();
            int bogeySpacing = 0;

            if (secondBogeyPos != null) {
                if (bogeyIndex == bogeyCount - 1 || !secondBogeyPos.equals((upsideDownBogeys[bogeyIndex + 1] ? upsideDownBogeyPosOffset : bogeyPosOffset).method_10079(assemblyDirection,
                    bogeyLocations[bogeyIndex + 1] + 1
                ))) {
                    exception(new AssemblyException(class_2561.method_43471("create.train_assembly.not_connected_in_order")), contraptions.size() + 1);
                    return;
                }
                AbstractBogeyBlockEntity secondBogeyBlockEntity = (AbstractBogeyBlockEntity) field_11863.method_8321(secondBogeyPos);
                bogeySpacing = bogeyLocations[bogeyIndex + 1] - bogeyLocations[bogeyIndex];
                secondBogey = new CarriageBogey(
                    bogeyTypes[bogeyIndex + 1],
                    upsideDownBogeys[bogeyIndex + 1],
                    secondBogeyBlockEntity.getBogeyData(),
                    points.get(pointIndex + 2),
                    points.get(pointIndex + 3)
                );
                bogeyIndex++;

            } else if (!typeOfFirstBogey.allowsSingleBogeyCarriage()) {
                exception(new AssemblyException(class_2561.method_43471("create.train_assembly.single_bogey_carriage")), contraptions.size() + 1);
                return;
            }

            contraptions.add(contraption);
            carriages.add(new Carriage(firstBogey, secondBogey, bogeySpacing));
        }

        if (!atLeastOneForwardControls) {
            exception(new AssemblyException(class_2561.method_43471("create.train_assembly.no_controls")), -1);
            return;
        }

        for (CarriageContraption contraption : contraptions) {
            contraption.removeBlocksFromWorld(field_11863, class_2338.field_10980);
            contraption.expandBoundsAroundAxis(class_2351.field_11052);
        }

        Train train = new Train(
            UUID.randomUUID(),
            playerUUID,
            graph,
            carriages,
            spacing,
            contraptions.stream().anyMatch(CarriageContraption::hasBackwardControls),
            0
        );

        if (lastDisassembledTrainName != null) {
            train.name = lastDisassembledTrainName;
            train.mapColorIndex = lastDisassembledMapColorIndex;
            lastDisassembledTrainName = null;
            lastDisassembledMapColorIndex = 0;
        }

        for (int i = 0; i < contraptions.size(); i++) {
            CarriageContraption contraption = contraptions.get(i);
            Carriage carriage = carriages.get(i);
            carriage.setContraption(field_11863, contraption);
            if (contraption.containsBlockBreakers())
                award(AllAdvancements.CONTRAPTION_ACTORS);
        }

        GlobalStation station = getStation();
        if (station != null) {
            train.setCurrentStation(station);
            station.reserveFor(train);
        }

        train.collectInitiallyOccupiedSignalBlocks();
        Create.RAILWAYS.addTrain(train);
        field_11863.method_8503().method_3760().method_14581(new AddTrainPacket(train));
        clearException();

        award(AllAdvancements.TRAIN);
        if (contraptions.size() >= 6)
            award(AllAdvancements.LONG_TRAIN);
    }

    public void cancelAssembly() {
        assemblyLength = 0;
        assemblyAreas.get(field_11863).remove(field_11867);
        clearException();
    }

    private void clearException() {
        exception(null, -1);
    }

    private void exception(AssemblyException exception, int carriage) {
        failedCarriageIndex = carriage;
        lastException = exception;
        sendData();
    }

    //TODO
    //    @Override
    //    @OnlyIn(Dist.CLIENT)
    //    public AABB getRenderBoundingBox() {
    //        if (isAssembling())
    //            return AABB.INFINITE;
    //        return super.getRenderBoundingBox();
    //    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(class_243.method_24954(field_11867), class_243.method_24954(edgePoint.getGlobalPosition())).method_1014(2);
    }

    public class_1799 getAutoSchedule() {
        return depotBehaviour.getHeldItemStack();
    }

    private void applyAutoSchedule() {
        class_1799 stack = getAutoSchedule();
        if (!stack.method_31574(AllItems.SCHEDULE))
            return;
        Schedule schedule = ScheduleItem.getSchedule(field_11863.method_30349(), stack);
        if (schedule == null || schedule.entries.isEmpty())
            return;
        GlobalStation station = getStation();
        if (station == null)
            return;
        Train imminentTrain = station.getImminentTrain();
        if (imminentTrain == null || imminentTrain.getCurrentStation() != station)
            return;

        award(AllAdvancements.CONDUCTOR);
        imminentTrain.runtime.setSchedule(schedule, true);
        AllSoundEvents.CONFIRM.playOnServer(field_11863, field_11867, 1, 1);

        if (!(field_11863 instanceof class_3218 server))
            return;

        class_243 v = class_243.method_24955(field_11867.method_10084());
        server.method_65096(class_2398.field_11211, v.field_1352, v.field_1351, v.field_1350, 8, 0.35, 0.05, 0.35, 1);
        server.method_65096(class_2398.field_11207, v.field_1352, v.field_1351 + .25f, v.field_1350, 10, 0.05, 1, 0.05, 0.005f);
    }

    public boolean resolveFlagAngle() {
        if (flagYRot != -1)
            return true;

        class_2680 target = edgePoint.getTrackBlockState();
        if (!(target.method_26204() instanceof ITrackBlock def))
            return false;

        class_243 axis = null;
        class_2338 trackPos = edgePoint.getGlobalPosition();
        for (class_243 vec3 : def.getTrackAxes(field_11863, trackPos, target))
            axis = vec3.method_1021(edgePoint.getTargetDirection().method_10181());
        if (axis == null)
            return false;

        class_2350 nearest = class_2350.method_10142(axis.field_1352, 0, axis.field_1350);
        flagYRot = (int) (-nearest.method_10144() - 90);

        class_243 diff = class_243.method_24954(trackPos.method_10059(field_11867)).method_18805(1, 0, 1);
        if (diff.method_1027() == 0)
            return true;

        flagFlipped = diff.method_1026(class_243.method_24954(nearest.method_10170().method_62675())) > 0;

        return true;
    }

    @Override
    public void transform(class_2586 be, StructureTransform transform) {
        edgePoint.transform(be, transform);
    }

    // Package port integration

    public void attachPackagePort(PackagePortBlockEntity ppbe) {
        GlobalStation station = getStation();
        if (station == null || field_11863.method_8608())
            return;

        if (ppbe instanceof PostboxBlockEntity pbe)
            pbe.trackedGlobalStation = new WeakReference<>(station);

        GlobalPackagePort globalPackagePort = station.connectedPorts.get(ppbe.method_11016());

        if (globalPackagePort == null) {
            globalPackagePort = new GlobalPackagePort();
            globalPackagePort.address = ppbe.addressFilter;
            station.connectedPorts.put(ppbe.method_11016(), globalPackagePort);
        } else {
            globalPackagePort.restoreOfflineBuffer(ppbe.inventory);
        }
    }

    public void removePackagePort(PackagePortBlockEntity ppbe) {
        GlobalStation station = getStation();
        if (station == null)
            return;

        station.connectedPorts.remove(ppbe.method_11016());
    }

}
