package com.zurrtum.create.foundation.blockEntity;

import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour.TankSegment;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_3532;

public class ComparatorUtil {

    public static int fractionToRedstoneLevel(double frac) {
        return class_3532.method_15357(class_3532.method_15350(frac * 14 + (frac > 0 ? 1 : 0), 0, 15));
    }

    public static int levelOfSmartFluidTank(class_1922 world, class_2338 pos) {
        SmartFluidTankBehaviour fluidBehaviour = BlockEntityBehaviour.get(world, pos, SmartFluidTankBehaviour.TYPE);
        if (fluidBehaviour == null)
            return 0;
        TankSegment primaryHandler = fluidBehaviour.getPrimaryHandler();
        double fillFraction = (double) primaryHandler.getFluid().getAmount() / primaryHandler.getMaxAmountPerStack();
        return fractionToRedstoneLevel(fillFraction);
    }

}
