package com.zurrtum.create.foundation.blockEntity.behaviour.inventory;

import com.google.common.base.Predicates;
import com.zurrtum.create.api.packager.InventoryIdentifier;
import com.zurrtum.create.content.logistics.packager.IdentifiedInventory;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.foundation.item.ItemHelper.ExtractionCountMode;
import org.jetbrains.annotations.Nullable;

import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;

public class InvManipulationBehaviour extends CapManipulationBehaviourBase<class_1263, InvManipulationBehaviour> {

    // Extra types available for multibehaviour
    public static final BehaviourType<InvManipulationBehaviour>

        TYPE = new BehaviourType<>(), EXTRACT = new BehaviourType<>(), INSERT = new BehaviourType<>();

    private final BehaviourType<InvManipulationBehaviour> behaviourType;

    public static InvManipulationBehaviour forExtraction(SmartBlockEntity be, InterfaceProvider target) {
        return new InvManipulationBehaviour(EXTRACT, be, target);
    }

    public static InvManipulationBehaviour forInsertion(SmartBlockEntity be, InterfaceProvider target) {
        return new InvManipulationBehaviour(INSERT, be, target);
    }

    public InvManipulationBehaviour(SmartBlockEntity be, InterfaceProvider target) {
        this(TYPE, be, target);
    }

    private InvManipulationBehaviour(BehaviourType<InvManipulationBehaviour> type, SmartBlockEntity be, InterfaceProvider target) {
        super(be, target);
        behaviourType = type;
    }

    @Nullable
    public IdentifiedInventory getIdentifiedInventory() {
        class_1263 inventory = this.getInventory();
        if (inventory == null)
            return null;

        InventoryIdentifier identifier = InventoryIdentifier.get(this.getWorld(), this.getTarget().getOpposite());
        return new IdentifiedInventory(identifier, inventory);
    }

    @Override
    protected class_1263 getCapability(class_1937 world, class_2338 pos, class_2586 blockEntity, @Nullable class_2350 side) {
        return ItemHelper.getInventory(world, pos, null, blockEntity, side);
    }

    public class_1799 extract() {
        return extract(getModeFromFilter(), getAmountFromFilter());
    }

    public class_1799 extract(ExtractionCountMode mode, int amount) {
        return extract(mode, amount, Predicates.alwaysTrue());
    }

    public class_1799 extract(ExtractionCountMode mode, int amount, Predicate<class_1799> filter) {
        boolean shouldSimulate = simulateNext;
        simulateNext = false;

        if (getWorld().method_8608())
            return class_1799.field_8037;
        class_1263 inventory = targetCapability;
        if (inventory == null)
            return class_1799.field_8037;

        Predicate<class_1799> test = getFilterTest(filter);
        if (shouldSimulate) {
            class_1799 extract = inventory.count(test, amount);
            int count = extract.method_7947();
            if (mode == ExtractionCountMode.EXACTLY && count != amount) {
                return class_1799.field_8037;
            }
            int maxCount = extract.method_7914();
            if (count > maxCount) {
                extract.method_7939(maxCount);
            }
            return extract;
        } else if (mode == ExtractionCountMode.UPTO) {
            class_1799 extract = inventory.count(test, amount);
            if (extract.method_7960()) {
                return extract;
            }
            int count = inventory.extract(extract, Math.min(extract.method_7947(), extract.method_7914()));
            extract.method_7939(count);
            return extract;
        } else {
            return inventory.preciseExtract(test, amount);
        }
    }

    public class_1799 insert(class_1799 stack) {
        boolean shouldSimulate = simulateNext;
        simulateNext = false;
        class_1263 inventory = targetCapability;
        if (inventory == null)
            return stack;
        int insert;
        if (shouldSimulate) {
            insert = inventory.countSpace(stack);
        } else {
            insert = inventory.insertExist(stack);
        }
        int count = stack.method_7947();
        if (insert == count) {
            return class_1799.field_8037;
        } else if (insert == 0) {
            return stack;
        } else {
            return stack.method_46651(count - insert);
        }
    }

    protected Predicate<class_1799> getFilterTest(Predicate<class_1799> customFilter) {
        Predicate<class_1799> test = customFilter;
        ServerFilteringBehaviour filter = blockEntity.getBehaviour(ServerFilteringBehaviour.TYPE);
        if (filter != null)
            test = customFilter.and(filter::test);
        return test;
    }

    @Override
    public BehaviourType<?> getType() {
        return behaviourType;
    }

}