package com.zurrtum.create.foundation.blockEntity.behaviour.simple;

import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.function.Supplier;
import net.minecraft.class_11368;
import net.minecraft.class_11372;

public class DeferralBehaviour extends BlockEntityBehaviour {

    public static final BehaviourType<DeferralBehaviour> TYPE = new BehaviourType<>();

    private boolean needsUpdate;
    private Supplier<Boolean> callback;

    public DeferralBehaviour(SmartBlockEntity be, Supplier<Boolean> callback) {
        super(be);
        this.callback = callback;
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71472("NeedsUpdate", needsUpdate);
        super.write(view, clientPacket);
    }

    @Override
    public void read(class_11368 view, boolean clientPacket) {
        needsUpdate = view.method_71433("NeedsUpdate", false);
        super.read(view, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        if (needsUpdate && callback.get())
            needsUpdate = false;
    }

    public void scheduleUpdate() {
        needsUpdate = true;
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

}
