package com.zurrtum.create.foundation.collision;

import static java.lang.Math.abs;
import static java.lang.Math.signum;

import net.minecraft.class_243;

public class ContinuousOBBCollider extends OBBCollider {

    public static ContinuousSeparationManifold separateBBs(class_243 cA, class_243 cB, class_243 eA, class_243 eB, Matrix3d m, class_243 motion) {
        ContinuousSeparationManifold mf = new ContinuousSeparationManifold();

        class_243 diff = cB.method_1020(cA);

        m.transpose();
        class_243 diff2 = m.transform(diff);
        class_243 motion2 = m.transform(motion);
        m.transpose();

        double a00 = abs(m.m00);
        double a01 = abs(m.m01);
        double a02 = abs(m.m02);
        double a10 = abs(m.m10);
        double a11 = abs(m.m11);
        double a12 = abs(m.m12);
        double a20 = abs(m.m20);
        double a21 = abs(m.m21);
        double a22 = abs(m.m22);

        class_243 uB0 = new class_243(m.m00, m.m10, m.m20);
        class_243 uB1 = new class_243(m.m01, m.m11, m.m21);
        class_243 uB2 = new class_243(m.m02, m.m12, m.m22);

        checkCount = 0;
        mf.stepSeparationAxis = uB1;
        mf.stepSeparation = Double.MAX_VALUE;
        mf.normalSeparation = Double.MAX_VALUE;

        if (
            // Separate along A's local axes (global XYZ)
            !(separate(mf, uA0, diff.field_1352, eA.field_1352, a00 * eB.field_1352 + a01 * eB.field_1351 + a02 * eB.field_1350, motion.field_1352, true) || separate(
                mf,
                uA1,
                diff.field_1351,
                eA.field_1351,
                a10 * eB.field_1352 + a11 * eB.field_1351 + a12 * eB.field_1350,
                motion.field_1351,
                true
            ) || separate(mf, uA2, diff.field_1350, eA.field_1350, a20 * eB.field_1352 + a21 * eB.field_1351 + a22 * eB.field_1350, motion.field_1350, true)

                // Separate along B's local axes
                || separate(mf, uB0, diff2.field_1352, eA.field_1352 * a00 + eA.field_1351 * a10 + eA.field_1350 * a20, eB.field_1352, motion2.field_1352, false) || separate(
                mf,
                uB1,
                diff2.field_1351,
                eA.field_1352 * a01 + eA.field_1351 * a11 + eA.field_1350 * a21,
                eB.field_1351,
                motion2.field_1351,
                false
            ) || separate(mf, uB2, diff2.field_1350, eA.field_1352 * a02 + eA.field_1351 * a12 + eA.field_1350 * a22, eB.field_1350, motion2.field_1350, false)))
            return mf;

        return null;
    }

    static boolean separate(
        ContinuousSeparationManifold mf,
        class_243 axis,
        double TL,
        double rA,
        double rB,
        double projectedMotion,
        boolean axisOfObjA
    ) {
        checkCount++;
        double distance = abs(TL);
        double diff = distance - (rA + rB);

        boolean discreteCollision = diff <= 0;
        if (!discreteCollision && signum(projectedMotion) == signum(TL))
            return true;

        double sTL = signum(TL);
        double seperation = sTL * abs(diff);

        double entryTime = 0;
        double exitTime = Double.MAX_VALUE;
        if (!discreteCollision) {
            mf.isDiscreteCollision = false;

            if (abs(seperation) > abs(projectedMotion))
                return true;

            entryTime = abs(seperation) / abs(projectedMotion);
            exitTime = (diff + abs(rA) + abs(rB)) / abs(projectedMotion);
            mf.latestCollisionEntryTime = Math.max(entryTime, mf.latestCollisionEntryTime);
            mf.earliestCollisionExitTime = Math.min(exitTime, mf.earliestCollisionExitTime);
        }

        class_243 normalizedAxis = axis.method_1029();

        boolean isBestSeperation = distance != 0 && -(diff) <= abs(mf.separation);
        // boolean isBestSeperation = discreteCollision && checkCount == 5; // Debug specific separations

        if (axisOfObjA && distance != 0 && -(diff) <= abs(mf.normalSeparation)) {
            mf.normalAxis = normalizedAxis;
            mf.normalSeparation = seperation;
        }

        double dot = mf.stepSeparationAxis.method_1026(axis);
        if (dot != 0 && discreteCollision) {
            class_243 cross = axis.method_1036(mf.stepSeparationAxis);
            double dotSeparation = signum(dot) * TL - (rA + rB);
            double stepSeparation = -dotSeparation;
            class_243 stepSeparationVec = axis;

            if (!cross.equals(class_243.field_1353)) {
                class_243 sepVec = normalizedAxis.method_1021(dotSeparation);
                class_243 axisPlane = axis.method_1036(cross);
                class_243 stepPlane = mf.stepSeparationAxis.method_1036(cross);
                stepSeparationVec = sepVec.method_1020(axisPlane.method_1021(sepVec.method_1026(stepPlane) / axisPlane.method_1026(stepPlane)));
                stepSeparation = stepSeparationVec.method_1033();
                if (abs(mf.stepSeparation) > abs(stepSeparation) && stepSeparation != 0)
                    mf.stepSeparation = stepSeparation;

            } else {
                if (abs(mf.stepSeparation) > stepSeparation)
                    mf.stepSeparation = stepSeparation;
            }
        }

        if (isBestSeperation) {
            mf.axis = normalizedAxis;
            mf.separation = seperation;
            mf.collisionPosition = normalizedAxis.method_1021(signum(TL) * (axisOfObjA ? -rB : -rB) - signum(seperation) * .125f);
        }

        return false;
    }

    public static class ContinuousSeparationManifold extends SeparationManifold {

        static final double UNDEFINED = -1;
        double latestCollisionEntryTime = UNDEFINED;
        double earliestCollisionExitTime = Double.MAX_VALUE;
        boolean isDiscreteCollision = true;
        class_243 collisionPosition;

        class_243 stepSeparationAxis;
        double stepSeparation;

        class_243 normalAxis;
        double normalSeparation;

        public double getTimeOfImpact() {
            if (latestCollisionEntryTime == UNDEFINED)
                return UNDEFINED;
            if (latestCollisionEntryTime > earliestCollisionExitTime)
                return UNDEFINED;
            return latestCollisionEntryTime;
        }

        public boolean isSurfaceCollision() {
            return true;
        }

        public class_243 getCollisionNormal() {
            return normalAxis == null ? null : createSeparationVec(normalSeparation, normalAxis);
        }

        public class_243 getCollisionPosition() {
            return collisionPosition;
        }

        public class_243 asSeparationVec(double obbStepHeight) {
            if (isDiscreteCollision) {
                if (stepSeparation <= obbStepHeight)
                    return createSeparationVec(stepSeparation, stepSeparationAxis);
                return super.asSeparationVec();
            }
            double t = getTimeOfImpact();
            if (t == UNDEFINED)
                return null;
            return class_243.field_1353;
        }

        @Override
        public class_243 asSeparationVec() {
            return asSeparationVec(0);
        }

    }

}
