package com.zurrtum.create.foundation.collision;

import static java.lang.Math.abs;
import static java.lang.Math.signum;

import net.minecraft.class_243;

public class OBBCollider {

    static final class_243 uA0 = new class_243(1, 0, 0);
    static final class_243 uA1 = new class_243(0, 1, 0);
    static final class_243 uA2 = new class_243(0, 0, 1);

    public static class_243 separateBBs(class_243 cA, class_243 cB, class_243 eA, class_243 eB, Matrix3d m) {
        SeparationManifold mf = new SeparationManifold();

        class_243 t = cB.method_1020(cA);

        double a00 = abs(m.m00);
        double a01 = abs(m.m01);
        double a02 = abs(m.m02);
        double a10 = abs(m.m10);
        double a11 = abs(m.m11);
        double a12 = abs(m.m12);
        double a20 = abs(m.m20);
        double a21 = abs(m.m21);
        double a22 = abs(m.m22);

        class_243 uB0 = new class_243(m.m00, m.m10, m.m20);
        class_243 uB1 = new class_243(m.m01, m.m11, m.m21);
        class_243 uB2 = new class_243(m.m02, m.m12, m.m22);

        checkCount = 0;

        if (
            // Separate along A's local axes (global XYZ)
            !(isSeparatedAlong(mf, uA0, t.field_1352, eA.field_1352, a00 * eB.field_1352 + a01 * eB.field_1351 + a02 * eB.field_1350) || isSeparatedAlong(
                mf,
                uA1,
                t.field_1351,
                eA.field_1351,
                a10 * eB.field_1352 + a11 * eB.field_1351 + a12 * eB.field_1350
            ) || isSeparatedAlong(mf, uA2, t.field_1350, eA.field_1350, a20 * eB.field_1352 + a21 * eB.field_1351 + a22 * eB.field_1350)

                // Separate along B's local axes
                || isSeparatedAlong(
                mf,
                uB0,
                (t.field_1352 * m.m00 + t.field_1351 * m.m10 + t.field_1350 * m.m20),
                eA.field_1352 * a00 + eA.field_1351 * a10 + eA.field_1350 * a20,
                eB.field_1352
            ) || isSeparatedAlong(mf, uB1, (t.field_1352 * m.m01 + t.field_1351 * m.m11 + t.field_1350 * m.m21), eA.field_1352 * a01 + eA.field_1351 * a11 + eA.field_1350 * a21, eB.field_1351) || isSeparatedAlong(mf,
                uB2,
                (t.field_1352 * m.m02 + t.field_1351 * m.m12 + t.field_1350 * m.m22),
                eA.field_1352 * a02 + eA.field_1351 * a12 + eA.field_1350 * a22,
                eB.field_1350
            )))
            return mf.asSeparationVec();

        return null;
    }

    static int checkCount = 0;

    static boolean isSeparatedAlong(SeparationManifold mf, class_243 axis, double TL, double rA, double rB) {
        checkCount++;
        double distance = abs(TL);
        double diff = distance - (rA + rB);
        if (diff > 0)
            return true;

        boolean isBestSeperation = checkCount == 2; // Debug specific separations

        if (isBestSeperation) {
            double sTL = signum(TL);
            double value = sTL * abs(diff);
            mf.axis = axis.method_1029();
            mf.separation = value;
        }

        return false;
    }

    static class SeparationManifold {
        class_243 axis;
        double separation;

        public SeparationManifold() {
            axis = class_243.field_1353;
            separation = Double.MAX_VALUE;
        }

        public class_243 asSeparationVec() {
            double sep = separation;
            class_243 axis = this.axis;
            return createSeparationVec(sep, axis);
        }

        protected class_243 createSeparationVec(double sep, class_243 axis) {
            return axis.method_1029().method_1021(signum(sep) * (abs(sep) + 1E-4));
        }
    }

}
