package com.zurrtum.create.foundation.recipe;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5348;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6903;
import net.minecraft.class_7417;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_8824;
import net.minecraft.text.*;

import java.util.List;
import java.util.Optional;

public class IngredientTextContent implements class_7417 {
    private static final Codec<class_6862<class_1792>> TAG_CODEC = class_6862.method_40093(class_7924.field_41197);
    private static final Codec<List<class_6880<class_1792>>> ENTRY_CODEC = class_1792.field_54952.listOf();
    private static final Codec<class_1856> INGREDIENT_CODEC = new Codec<>() {
        @Override
        public <T> DataResult<Pair<class_1856, T>> decode(DynamicOps<T> ops, T input) {
            if (ops instanceof class_6903<T> registryOps) {
                Optional<class_7871<class_1792>> entryLookup = registryOps.method_46634(class_7924.field_41197);
                if (entryLookup.isPresent()) {
                    DataResult<Pair<class_6862<class_1792>, T>> tag = TAG_CODEC.decode(ops, input);
                    if (tag.isSuccess()) {
                        Optional<class_6885.class_6888<class_1792>> list = entryLookup.get().method_46733(tag.getOrThrow().getFirst());
                        if (list.isPresent()) {
                            return tag.map(pair -> pair.mapFirst(i -> new class_1856(list.get())));
                        }
                    }
                }
            }
            DataResult<Pair<class_6880<class_1792>, T>> entry = class_1792.field_54952.decode(ops, input);
            if (entry.isSuccess()) {
                return entry.map(pair -> pair.mapFirst(value -> new class_1856(class_6885.method_40246(value))));
            }
            return ENTRY_CODEC.decode(ops, input).map(pair -> pair.mapFirst(value -> new class_1856(class_6885.method_40242(value))));
        }

        @Override
        public <T> DataResult<T> encode(class_1856 input, DynamicOps<T> ops, T prefix) {
            class_6885<class_1792> entries = input.field_9019;
            if (ops instanceof class_6903<T>) {
                Optional<class_6862<class_1792>> tag = entries.method_45925();
                if (tag.isPresent()) {
                    DataResult<T> result = TAG_CODEC.encode(tag.get(), ops, prefix);
                    if (result.isSuccess()) {
                        return result;
                    }
                }
            }
            List<class_6880<class_1792>> list = entries.method_40239().toList();
            if (list.size() == 1) {
                return class_1792.field_54952.encode(list.getFirst(), ops, prefix);
            }
            return ENTRY_CODEC.encode(list, ops, prefix);
        }
    };
    public static final MapCodec<IngredientTextContent> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
        INGREDIENT_CODEC.optionalFieldOf("ingredient").forGetter(i -> Optional.ofNullable(i.ingredient)),
        class_8824.field_46597.optionalFieldOf("name").forGetter(i -> Optional.ofNullable(i.name))
    ).apply(instance, IngredientTextContent::new));

    public class_1856 ingredient;
    public class_2561 name;

    @Override
    public MapCodec<? extends class_7417> method_74063() {
        return CODEC;
    }

    public IngredientTextContent(class_1856 ingredient) {
        this.ingredient = ingredient;
    }

    @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
    public IngredientTextContent(Optional<class_1856> ingredient, Optional<class_2561> name) {
        name.ifPresentOrElse(value -> this.name = value, () -> this.ingredient = ingredient.orElse(null));
    }

    @Override
    public <T> Optional<T> method_27659(class_5348.class_5245<T> visitor) {
        if (name != null) {
            return name.method_27657(visitor);
        }
        return findName().flatMap(text -> text.method_27657(visitor));
    }

    @Override
    public <T> Optional<T> method_27660(class_5348.class_5246<T> visitor, class_2583 style) {
        if (name != null) {
            return name.method_27658(visitor, style);
        }
        return findName().flatMap(text -> text.method_27658(visitor, style));
    }

    private Optional<class_2561> findName() {
        if (ingredient != null && ingredient.field_9019.method_62680()) {
            Optional<class_6880<class_1792>> first = ingredient.field_9019.method_40239().findFirst();
            if (first.isPresent()) {
                name = first.get().comp_349().method_63680();
                ingredient = null;
                return Optional.of(name);
            }
        }
        return Optional.empty();
    }

    public Optional<class_2561> getName() {
        if (name != null) {
            return Optional.of(name);
        }
        return findName();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IngredientTextContent other) {
            Optional<class_2561> name = getName();
            Optional<class_2561> otherName = other.getName();
            if (name.isPresent() && otherName.isPresent()) {
                return name.get().equals(otherName.get());
            } else {
                return true;
            }
        }
        return false;
    }
}
