package com.zurrtum.create.impl.effect;

import com.zurrtum.create.api.effect.OpenPipeEffectHandler;
import com.zurrtum.create.content.fluids.potion.PotionFluidHandler;
import com.zurrtum.create.infrastructure.fluids.BottleFluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_3218;
import net.minecraft.class_9334;

public class PotionEffectHandler implements OpenPipeEffectHandler {
    @Override
    public void apply(class_1937 level, class_238 area, FluidStack fluid) {
        class_1844 contents = getContents(fluid);
        if (contents == class_1844.field_49274)
            return;

        List<class_1309> entities = level.method_8390(class_1309.class, area, class_1309::method_6086);
        for (class_1309 entity : entities) {
            contents.method_57402(
                effectInstance -> {
                    class_1291 effect = effectInstance.method_5579().comp_349();
                    if (effect.method_5561()) {
                        if (level instanceof class_3218 serverWorld) {
                            effect.method_5564(serverWorld, null, null, entity, effectInstance.method_5578(), 0.5D);
                        }
                    } else {
                        entity.method_6092(new class_1293(effectInstance));
                    }
                }, 1
            );
        }
    }

    private static class_1844 getContents(FluidStack fluid) {
        FluidStack copy = fluid.copy();
        copy.setAmount(BottleFluidInventory.CAPACITY);
        class_1799 bottle = PotionFluidHandler.fillBottle(new class_1799(class_1802.field_8469), copy);
        return bottle.method_58695(class_9334.field_49651, class_1844.field_49274);
    }
}
