package com.zurrtum.create.infrastructure.component;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.CrossPlaneMirror;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.EmptyMirror;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.PlaneMirror;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.TriplePlaneMirror;
import java.util.*;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_3542;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public abstract class SymmetryMirror {
    public static final String EMPTY = "empty";
    public static final String PLANE = "plane";
    public static final String CROSS_PLANE = "cross_plane";
    public static final String TRIPLE_PLANE = "triple_plane";

    public static final Codec<SymmetryMirror> CODEC = RecordCodecBuilder.create(i -> i.group(
        Codec.INT.fieldOf("orientation_index").forGetter(SymmetryMirror::getOrientationIndex),
        class_243.field_38277.fieldOf("position").forGetter(SymmetryMirror::getPosition),
        Codec.STRING.fieldOf("type").forGetter(SymmetryMirror::typeName),
        Codec.BOOL.fieldOf("enable").forGetter(m -> m.enable)
    ).apply(i, SymmetryMirror::create));

    public static final class_9139<class_2540, SymmetryMirror> STREAM_CODEC = class_9139.method_56905(
        class_9135.field_49675,
        SymmetryMirror::getOrientationIndex,
        class_243.field_52694,
        SymmetryMirror::getPosition,
        class_9135.field_48554,
        SymmetryMirror::typeName,
        class_9135.field_48547,
        m -> m.enable,
        SymmetryMirror::create
    );

    protected class_243 position;
    public class_3542 orientation;
    protected int orientationIndex;
    public boolean enable;

    public SymmetryMirror(class_243 pos) {
        position = pos;
        enable = true;
        orientationIndex = 0;
    }

    private static SymmetryMirror create(Integer orientationIndex, class_243 position, String type, Boolean enable) {
        SymmetryMirror element = switch (type) {
            case PLANE -> new PlaneMirror(position);
            case CROSS_PLANE -> new CrossPlaneMirror(position);
            case TRIPLE_PLANE -> new TriplePlaneMirror(position);
            default -> new EmptyMirror(position);
        };

        element.setOrientation(orientationIndex);
        element.enable = enable;

        return element;
    }

    public class_3542 getOrientation() {
        return orientation;
    }

    public class_243 getPosition() {
        return position;
    }

    public int getOrientationIndex() {
        return orientationIndex;
    }

    public void rotate(boolean forward) {
        orientationIndex += forward ? 1 : -1;
        setOrientation();
    }

    public void process(Map<class_2338, Pair<class_2350, class_2680>> blocks) {
        Map<class_2338, Pair<class_2350, class_2680>> result = new HashMap<>();
        for (class_2338 pos : blocks.keySet()) {
            result.putAll(process(pos, blocks.get(pos)));
        }
        blocks.putAll(result);
    }

    public void process(Set<class_2338> positions) {
        Set<class_2338> result = new HashSet<>();
        for (class_2338 pos : positions) {
            result.addAll(process(pos));
        }
        positions.addAll(result);
    }

    public abstract Map<class_2338, Pair<class_2350, class_2680>> process(class_2338 position, Pair<class_2350, class_2680> block);

    public abstract Set<class_2338> process(class_2338 position);

    protected abstract void setOrientation();

    public abstract void setOrientation(int index);

    public abstract String typeName();

    protected class_243 getDiff(class_2338 position) {
        return this.position.method_1021(-1).method_1031(position.method_10263(), position.method_10264(), position.method_10260());
    }

    protected class_2338 getIDiff(class_2338 position) {
        class_243 diff = getDiff(position);
        return new class_2338((int) diff.field_1352, (int) diff.field_1351, (int) diff.field_1350);
    }

    protected class_2680 flipX(class_2680 in) {
        return in.method_26185(class_2415.field_11301);
    }

    protected class_2680 flipZ(class_2680 in) {
        return in.method_26185(class_2415.field_11300);
    }

    @SuppressWarnings("deprecation")
    protected class_2680 flipD1(class_2680 in) {
        return in.method_26186(class_2470.field_11465).method_26185(class_2415.field_11301);
    }

    @SuppressWarnings("deprecation")
    protected class_2680 flipD2(class_2680 in) {
        return in.method_26186(class_2470.field_11465).method_26185(class_2415.field_11300);
    }

    protected class_2338 flipX(class_2338 position) {
        class_2338 diff = getIDiff(position);
        return new class_2338(position.method_10263() - 2 * diff.method_10263(), position.method_10264(), position.method_10260());
    }

    protected class_2338 flipY(class_2338 position) {
        class_2338 diff = getIDiff(position);
        return new class_2338(position.method_10263(), position.method_10264() - 2 * diff.method_10264(), position.method_10260());
    }

    protected class_2338 flipZ(class_2338 position) {
        class_2338 diff = getIDiff(position);
        return new class_2338(position.method_10263(), position.method_10264(), position.method_10260() - 2 * diff.method_10260());
    }

    protected class_2338 flipD2(class_2338 position) {
        class_2338 diff = getIDiff(position);
        return new class_2338(position.method_10263() - diff.method_10263() + diff.method_10260(), position.method_10264(), position.method_10260() - diff.method_10260() + diff.method_10263());
    }

    protected class_2338 flipD1(class_2338 position) {
        class_2338 diff = getIDiff(position);
        return new class_2338(position.method_10263() - diff.method_10263() - diff.method_10260(), position.method_10264(), position.method_10260() - diff.method_10260() - diff.method_10263());
    }

    protected class_2350 flipZ(class_2350 side) {
        return switch (side) {
            case field_11036, field_11033, field_11034, field_11039 -> side;
            case field_11043 -> class_2350.field_11035;
            case field_11035 -> class_2350.field_11043;
        };
    }

    protected class_2350 flipX(class_2350 side) {
        return switch (side) {
            case field_11036, field_11033, field_11043, field_11035 -> side;
            case field_11034 -> class_2350.field_11039;
            case field_11039 -> class_2350.field_11034;
        };
    }

    protected class_2350 flipXZ(class_2350 side) {
        return switch (side) {
            case field_11036, field_11033 -> side;
            case field_11043 -> class_2350.field_11035;
            case field_11035 -> class_2350.field_11043;
            case field_11034 -> class_2350.field_11039;
            case field_11039 -> class_2350.field_11034;
        };
    }

    protected class_2350 flipD1(class_2350 side) {
        return switch (side) {
            case field_11036, field_11033 -> side;
            case field_11043 -> class_2350.field_11034;
            case field_11034 -> class_2350.field_11043;
            case field_11035 -> class_2350.field_11039;
            case field_11039 -> class_2350.field_11035;
        };
    }

    protected class_2350 flipD2(class_2350 side) {
        return switch (side) {
            case field_11036, field_11033 -> side;
            case field_11043 -> class_2350.field_11039;
            case field_11039 -> class_2350.field_11043;
            case field_11035 -> class_2350.field_11034;
            case field_11034 -> class_2350.field_11035;
        };
    }

    protected class_2350 flipD1D2(class_2350 side) {
        return switch (side) {
            case field_11036, field_11033 -> side;
            case field_11043 -> class_2350.field_11035;
            case field_11035 -> class_2350.field_11043;
            case field_11034 -> class_2350.field_11039;
            case field_11039 -> class_2350.field_11034;
        };
    }

    protected class_2350 flipD1X(class_2350 side) {
        return switch (side) {
            case field_11036, field_11033 -> side;
            case field_11043, field_11034, field_11035, field_11039 -> side.method_10170();
        };
    }

    protected class_2350 flipD1Z(class_2350 side) {
        return switch (side) {
            case field_11036, field_11033 -> side;
            case field_11043, field_11034, field_11035, field_11039 -> side.method_10160();
        };
    }

    protected class_2350 flipD1XZ(class_2350 side) {
        return switch (side) {
            case field_11036, field_11033 -> side;
            case field_11043 -> class_2350.field_11039;
            case field_11034 -> class_2350.field_11035;
            case field_11035 -> class_2350.field_11034;
            case field_11039 -> class_2350.field_11043;
        };
    }

    public void setPosition(class_243 pos3d) {
        this.position = pos3d;
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o)
            return true;
        if (!(o instanceof SymmetryMirror that))
            return false;

        return getOrientationIndex() == that.getOrientationIndex() && enable == that.enable && Objects.equals(
            getPosition(),
            that.getPosition()
        ) && Objects.equals(getOrientation(), that.getOrientation());
    }

    @Override
    public int hashCode() {
        int result = Objects.hashCode(getPosition());
        result = 31 * result + Objects.hashCode(getOrientation());
        result = 31 * result + getOrientationIndex();
        result = 31 * result + Boolean.hashCode(enable);
        return result;
    }
}
