package com.zurrtum.create.infrastructure.fluids;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllFluids;
import com.zurrtum.create.content.fluids.potion.PotionFluidHandler;
import com.zurrtum.create.infrastructure.component.BottleType;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import net.minecraft.class_156;
import net.minecraft.class_1844;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9322;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9335;
import net.minecraft.component.*;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import java.util.Optional;

import static com.zurrtum.create.Create.LOGGER;

public class FluidStack implements class_9322 {
    public static final FluidStack EMPTY = new FluidStack(null);
    @SuppressWarnings("deprecation")
    public static final Codec<class_6880<class_3611>> FLUID_ENTRY_CODEC = class_7923.field_41173.method_40294()
        .validate(entry -> entry.method_55838(class_3612.field_15906.method_40178()) ? DataResult.error(() -> "Fluid must not be minecraft:empty") : DataResult.success(
            entry));
    public static final class_9139<class_9129, class_6880<class_3611>> FLUID_ENTRY_PACKET_CODEC = class_9135.method_56383(class_7924.field_41270);
    public static final MapCodec<FluidStack> MAP_CODEC = MapCodec.recursive(
        "FluidStack", codec -> RecordCodecBuilder.mapCodec(instance -> instance.group(
            FLUID_ENTRY_CODEC.fieldOf("id").forGetter(FluidStack::getRegistryEntry),
            class_5699.field_33442.fieldOf("amount").orElse(1).forGetter(FluidStack::getAmount),
            class_9326.field_49589.optionalFieldOf("components", class_9326.field_49588).forGetter(stack -> stack.components.method_57940())
        ).apply(instance, FluidStack::new))
    );
    public static final Codec<FluidStack> CODEC = Codec.lazyInitialized(MAP_CODEC::codec);
    public static final Codec<FluidStack> OPTIONAL_CODEC = class_5699.method_57155(CODEC)
        .xmap(optional -> optional.orElse(FluidStack.EMPTY), stack -> stack.isEmpty() ? Optional.empty() : Optional.of(stack));
    public static final class_9139<class_9129, FluidStack> OPTIONAL_PACKET_CODEC = new class_9139<class_9129, FluidStack>() {
        public FluidStack decode(class_9129 registryByteBuf) {
            int i = registryByteBuf.method_10816();
            if (i <= 0) {
                return FluidStack.EMPTY;
            } else {
                class_6880<class_3611> registryEntry = FLUID_ENTRY_PACKET_CODEC.decode(registryByteBuf);
                class_9326 componentChanges = class_9326.field_49590.decode(registryByteBuf);
                return new FluidStack(registryEntry, i, componentChanges);
            }
        }

        public void encode(class_9129 registryByteBuf, FluidStack fluidStack) {
            if (fluidStack.isEmpty()) {
                registryByteBuf.method_10804(0);
            } else {
                registryByteBuf.method_10804(fluidStack.getAmount());
                FLUID_ENTRY_PACKET_CODEC.encode(registryByteBuf, fluidStack.getRegistryEntry());
                class_9326.field_49590.encode(registryByteBuf, fluidStack.components.method_57940());
            }
        }
    };
    public static final class_9139<class_9129, FluidStack> PACKET_CODEC = new class_9139<class_9129, FluidStack>() {
        public FluidStack decode(class_9129 registryByteBuf) {
            FluidStack fluidStack = FluidStack.OPTIONAL_PACKET_CODEC.decode(registryByteBuf);
            if (fluidStack.isEmpty()) {
                throw new DecoderException("Empty FluidStack not allowed");
            } else {
                return fluidStack;
            }
        }

        public void encode(class_9129 registryByteBuf, FluidStack fluidStack) {
            if (fluidStack.isEmpty()) {
                throw new EncoderException("Empty FluidStack not allowed");
            } else {
                FluidStack.OPTIONAL_PACKET_CODEC.encode(registryByteBuf, fluidStack);
            }
        }
    };
    private final class_9335 components;
    private final class_3611 fluid;
    private int amount;

    public FluidStack(class_3611 fluid, int amount) {
        this(fluid, amount, new class_9335(class_9323.field_49584));
    }

    public FluidStack(class_3611 fluid, int amount, class_9335 components) {
        this.fluid = fluid;
        this.amount = amount;
        this.components = components;
    }

    private FluidStack(@Nullable Void v) {
        fluid = null;
        components = new class_9335(class_9323.field_49584);
    }

    public FluidStack(class_6880<class_3611> fluid, int amount, class_9326 changes) {
        this(fluid.comp_349(), amount, class_9335.method_57935(class_9323.field_49584, changes));
    }

    public FluidStack(class_3611 fluid, int amount, class_9326 changes) {
        this(fluid, amount, class_9335.method_57935(class_9323.field_49584, changes));
    }

    public FluidStack(class_3611 fluid, long amount, class_9326 changes) {
        this(fluid, (int) amount, class_9335.method_57935(class_9323.field_49584, changes));
    }

    public static boolean areFluidsAndComponentsEqual(FluidStack stack, FluidStack otherStack) {
        if (!stack.isOf(otherStack.getFluid())) {
            return false;
        } else {
            return stack.isEmpty() && otherStack.isEmpty() || Objects.equals(stack.components, otherStack.components);
        }
    }

    public static boolean areFluidsAndComponentsEqualIgnoreCapacity(FluidStack stack, FluidStack otherStack) {
        if (stack.isOf(otherStack.getFluid())) {
            class_9335 stackComponents = stack.directComponents();
            class_9335 otherStackComponents = otherStack.directComponents();
            if (stackComponents == otherStackComponents) {
                return true;
            }
            Reference2ObjectMap<class_9331<?>, Optional<?>> stackComponentMap = stackComponents.field_49655;
            Reference2ObjectMap<class_9331<?>, Optional<?>> otherStackComponentMap = otherStackComponents.field_49655;
            if (stackComponentMap == otherStackComponentMap) {
                return true;
            }
            int stackComponentCount = stackComponentMap.size();
            if (stackComponentMap.containsKey(AllDataComponents.FLUID_MAX_CAPACITY)) {
                stackComponentCount--;
            }
            int otherStackComponentCount = otherStackComponentMap.size();
            boolean hasMaxCapacityComponent = false;
            if (otherStackComponentMap.containsKey(AllDataComponents.FLUID_MAX_CAPACITY)) {
                otherStackComponentCount--;
                hasMaxCapacityComponent = true;
            }
            if (stackComponentCount != otherStackComponentCount) {
                return false;
            }
            if (hasMaxCapacityComponent) {
                ObjectSet<Reference2ObjectMap.Entry<class_9331<?>, Optional<?>>> stackComponentSet = stackComponentMap.reference2ObjectEntrySet();
                for (Reference2ObjectMap.Entry<class_9331<?>, Optional<?>> componentEntry : otherStackComponentMap.reference2ObjectEntrySet()) {
                    if (!stackComponentSet.contains(componentEntry) && componentEntry.getKey() != AllDataComponents.FLUID_MAX_CAPACITY) {
                        return false;
                    }
                }
                return true;
            }
            return stackComponentMap.reference2ObjectEntrySet().containsAll(otherStackComponentMap.reference2ObjectEntrySet());
        }
        return false;
    }

    public static Optional<FluidStack> fromNbt(class_7225.class_7874 registries, class_2520 nbt) {
        return CODEC.parse(registries.method_57093(class_2509.field_11560), nbt)
            .resultOrPartial(error -> LOGGER.error("Tried to load invalid fluid: '{}'", error));
    }

    @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
    public static FluidStack fromNbt(class_7225.class_7874 registries, Optional<class_2487> nbt) {
        return nbt.flatMap(n -> fromNbt(registries, n)).orElse(FluidStack.EMPTY);
    }

    public static int hashCode(@Nullable FluidStack stack) {
        if (stack != null) {
            int i = 31 + stack.getFluid().hashCode();
            return 31 * i + stack.method_57353().hashCode();
        } else {
            return 0;
        }
    }

    public void applyComponentsFrom(class_9323 map) {
        components.method_57933(map);
    }

    public void capAmount(int maxCount) {
        if (!isEmpty() && getAmount() > maxCount) {
            setAmount(maxCount);
        }
    }

    public FluidStack copy() {
        if (isEmpty()) {
            return EMPTY;
        } else {
            return new FluidStack(fluid, amount, components.method_57941());
        }
    }

    public FluidStack copyWithAmount(int amount) {
        if (isEmpty()) {
            return EMPTY;
        } else {
            return new FluidStack(fluid, amount, components.method_57941());
        }
    }

    public void decrement(int amount) {
        increment(-amount);
    }

    public class_9335 directComponents() {
        return components;
    }

    public FluidStack directCopy(int amount) {
        return new FluidStack(fluid, amount, components.method_57941());
    }

    public int getAmount() {
        return isEmpty() ? 0 : amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public class_9326 getComponentChanges() {
        return !isEmpty() ? components.method_57940() : class_9326.field_49588;
    }

    @Override
    public class_9323 method_57353() {
        return !isEmpty() ? components : class_9323.field_49584;
    }

    public class_3611 getFluid() {
        return isEmpty() ? class_3612.field_15906 : fluid;
    }

    public int getMaxAmount() {
        return method_58695(AllDataComponents.FLUID_MAX_CAPACITY, Integer.MAX_VALUE);
    }

    public class_2561 getName() {
        if (fluid == AllFluids.POTION) {
            class_1844 contents = method_58695(class_9334.field_49651, class_1844.field_49274);
            class_1935 itemFromBottleType = PotionFluidHandler.itemFromBottleType(method_58695(
                AllDataComponents.POTION_FLUID_BOTTLE_TYPE,
                BottleType.REGULAR
            ));
            return contents.method_64195(itemFromBottleType.method_8389().method_7876() + ".effect.");
        }
        class_2248 block = fluid.method_15785().method_15759().method_26204();
        if (fluid != class_3612.field_15906 && block == class_2246.field_10124) {
            return class_2561.method_43471(class_156.method_646("block", class_7923.field_41173.method_10221(fluid)));
        } else {
            return block.method_9518();
        }
    }

    @SuppressWarnings("deprecation")
    public class_6880<class_3611> getRegistryEntry() {
        return getFluid().method_40178();
    }

    public void increment(int amount) {
        setAmount(getAmount() + amount);
    }

    public boolean isEmpty() {
        return this == EMPTY || fluid == class_3612.field_15906 || amount <= 0;
    }

    @SuppressWarnings("deprecation")
    public boolean isIn(class_6862<class_3611> tag) {
        return getFluid().method_40178().method_40220(tag);
    }

    public boolean isOf(class_3611 fluid) {
        return getFluid() == fluid;
    }

    @Nullable
    public <T> T remove(class_9331<? extends T> type) {
        return this.components.method_57939(type);
    }

    @Nullable
    public <T> T set(class_9331<T> type, @Nullable T value) {
        return components.method_57938(type, value);
    }

    public FluidStack split(int amount) {
        int i = Math.min(amount, getAmount());
        FluidStack stack = copyWithAmount(i);
        decrement(i);
        return stack;
    }

    public class_2520 toNbt(class_7225.class_7874 registries) {
        if (isEmpty()) {
            throw new IllegalStateException("Cannot encode empty FluidStack");
        } else {
            return CODEC.encodeStart(registries.method_57093(class_2509.field_11560), this).getOrThrow();
        }
    }

    public String toString() {
        return getAmount() + " " + class_7923.field_41173.method_47983(getFluid()).method_55840();
    }
}
