package com.zurrtum.create.infrastructure.items;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.*;
import org.jetbrains.annotations.NotNull;

import java.util.*;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9335;

public interface BaseInventory extends Iterable<class_1799> {
    Hash.Strategy<class_1799> ITEM_STACK_HASH_STRATEGY = new Hash.Strategy<>() {
        public boolean equals(class_1799 stack, class_1799 other) {
            return stack == other || stack != null && other != null && class_1799.method_31577(stack, other);
        }

        public int hashCode(class_1799 stack) {
            return class_1799.method_57355(stack);
        }
    };

    default void create$setStack(int slot, class_1799 stack) {
        throw new RuntimeException("Implemented via Mixin");
    }

    default int create$size() {
        throw new RuntimeException("Implemented via Mixin");
    }

    default int create$getMaxCount(class_1799 stack) {
        throw new RuntimeException("Implemented via Mixin");
    }

    default class_1799 create$getStack(int slot) {
        throw new RuntimeException("Implemented via Mixin");
    }

    default boolean create$isValid(int slot, class_1799 stack) {
        throw new RuntimeException("Implemented via Mixin");
    }

    default void create$markDirty() {
        throw new RuntimeException("Implemented via Mixin");
    }

    default int count(class_1799 stack, class_2350 side) {
        return count(stack);
    }

    default int count(class_1799 stack) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return 0;
        }
        return count(stack, maxAmount);
    }

    default int count(class_1799 stack, int maxAmount, class_2350 side) {
        return count(stack, maxAmount);
    }

    default int count(class_1799 stack, int maxAmount) {
        int count = 0;
        for (int i = 0, size = create$size(); i < size; i++) {
            class_1799 target = create$getStack(i);
            if (target.method_7960()) {
                continue;
            }
            if (matches(target, stack)) {
                count += target.method_7947();
                if (count >= maxAmount) {
                    return maxAmount;
                }
            }
        }
        return count;
    }

    default class_1799 count(Predicate<class_1799> predicate, class_2350 side) {
        return count(predicate);
    }

    default class_1799 count(Predicate<class_1799> predicate) {
        for (int i = 0, size = create$size(); i < size; i++) {
            class_1799 stack = create$getStack(i);
            if (stack.method_7960()) {
                continue;
            }
            if (predicate.test(stack)) {
                return onExtract(stack);
            }
        }
        return class_1799.field_8037;
    }

    default class_1799 count(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
        return count(predicate, maxAmount);
    }

    default class_1799 count(Predicate<class_1799> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        for (int i = 0, size = create$size(); i < size; i++) {
            class_1799 findStack = create$getStack(i);
            if (findStack.method_7960()) {
                continue;
            }
            if (predicate.test(findStack)) {
                int count = findStack.method_7947();
                if (count >= maxAmount) {
                    return onExtract(directCopy(findStack, maxAmount));
                }
                for (i = i + 1; i < size; i++) {
                    class_1799 stack = create$getStack(i);
                    if (stack.method_7960()) {
                        continue;
                    }
                    if (matches(stack, findStack)) {
                        count += stack.method_7947();
                        if (count < maxAmount) {
                            continue;
                        }
                        return onExtract(directCopy(findStack, maxAmount));
                    }
                }
                return onExtract(directCopy(findStack, count));
            }
        }
        return class_1799.field_8037;
    }

    default int countAll(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
        return countAll(predicate, maxAmount);
    }

    default int countAll(Predicate<class_1799> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return 0;
        }
        int count = 0;
        for (int i = 0, size = create$size(); i < size; i++) {
            class_1799 stack = create$getStack(i);
            if (stack.method_7960()) {
                continue;
            }
            if (predicate.test(stack)) {
                count += stack.method_7947();
                if (count >= maxAmount) {
                    return maxAmount;
                }
            }
        }
        return count;
    }

    default class_1799 countAny(class_2350 side) {
        return countAny();
    }

    default class_1799 countAny() {
        for (int i = 0, size = create$size(); i < size; i++) {
            class_1799 target = create$getStack(i);
            if (target.method_7960()) {
                continue;
            }
            return onExtract(directCopy(target, target.method_7947()));
        }
        return class_1799.field_8037;
    }

    default class_1799 countAny(int maxAmount, class_2350 side) {
        return extractAny(maxAmount);
    }

    default class_1799 countAny(int maxAmount) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        for (int i = 0, size = create$size(); i < size; i++) {
            class_1799 findStack = create$getStack(i);
            if (findStack.method_7960()) {
                continue;
            }
            int count = findStack.method_7947();
            if (count >= maxAmount) {
                return onExtract(directCopy(findStack, maxAmount));
            }
            for (i = i + 1; i < size; i++) {
                class_1799 stack = create$getStack(i);
                if (stack.method_7960()) {
                    continue;
                }
                if (matches(stack, findStack)) {
                    count += stack.method_7947();
                    if (count < maxAmount) {
                        continue;
                    }
                    return onExtract(directCopy(findStack, maxAmount));
                }
            }
            return onExtract(directCopy(findStack, count));
        }
        return class_1799.field_8037;
    }

    default int countSpace(class_1799 stack, class_2350 side) {
        return countSpace(stack);
    }

    default int countSpace(class_1799 stack) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return 0;
        }
        return countSpace(stack, maxAmount);
    }

    default int countSpace(class_1799 stack, int maxAmount, class_2350 side) {
        return countSpace(stack, maxAmount);
    }

    default int countSpace(class_1799 stack, int maxAmount) {
        int count = 0;
        for (int i = 0, size = create$size(); i < size; i++) {
            if (create$isValid(i, stack)) {
                class_1799 target = create$getStack(i);
                if (target.method_7960()) {
                    count += create$getMaxCount(stack);
                    if (count >= maxAmount) {
                        return maxAmount;
                    }
                } else if (matches(target, stack)) {
                    count += target.method_7914() - target.method_7947();
                    if (count >= maxAmount) {
                        return maxAmount;
                    }
                }
            }
        }
        return count;
    }

    default int countSpace(class_1799 stack, int maxAmount, int start, int end, class_2350 side) {
        return countSpace(stack, maxAmount, start, end);
    }

    default int countSpace(class_1799 stack, int maxAmount, int start, int end) {
        int count = 0;
        for (int i = start; i <= end; i++) {
            if (create$isValid(i, stack)) {
                class_1799 target = create$getStack(i);
                if (target.method_7960()) {
                    count += create$getMaxCount(stack);
                    if (count >= maxAmount) {
                        return maxAmount;
                    }
                } else if (matches(target, stack)) {
                    count += target.method_7914() - target.method_7947();
                    if (count >= maxAmount) {
                        return maxAmount;
                    }
                }
            }
        }
        return count;
    }

    default boolean countSpace(List<class_1799> stacks, class_2350 side) {
        return countSpace(stacks);
    }

    default boolean countSpace(List<class_1799> stacks) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return true;
        }
        if (listSize == 1) {
            class_1799 stack = stacks.getFirst();
            int count = stack.method_7947();
            return countSpace(stack, count) == count;
        }
        Object2IntLinkedOpenCustomHashMap<class_1799> map = new Object2IntLinkedOpenCustomHashMap<>(ITEM_STACK_HASH_STRATEGY);
        for (class_1799 stack : stacks) {
            map.merge(stack, stack.method_7947(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet<class_1799> entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            Object2IntMap.Entry<class_1799> entry = entries.first();
            class_1799 stack = entry.getKey();
            int count = entry.getIntValue();
            return countSpace(stack, count) == count;
        }
        for (int i = 0, size = create$size(); i < size; i++) {
            class_1799 target = create$getStack(i);
            boolean empty = target.method_7960();
            ObjectIterator<Object2IntMap.Entry<class_1799>> iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry<class_1799> entry = iterator.next();
                class_1799 stack = entry.getKey();
                if (create$isValid(i, stack)) {
                    if (empty) {
                        int remaining = entry.getIntValue();
                        int insert = Math.min(remaining, create$getMaxCount(stack));
                        if (remaining == insert) {
                            iterator.remove();
                            if (entries.isEmpty()) {
                                return true;
                            }
                        } else {
                            entry.setValue(remaining - insert);
                        }
                        break;
                    } else if (matches(target, stack)) {
                        int maxCount = target.method_7914();
                        int count = target.method_7947();
                        if (count != maxCount) {
                            int remaining = entry.getIntValue();
                            int insert = Math.min(remaining, maxCount - count);
                            if (remaining == insert) {
                                iterator.remove();
                                if (entries.isEmpty()) {
                                    return true;
                                }
                            } else {
                                entry.setValue(remaining - insert);
                            }
                        }
                        break;
                    }
                }
            } while (iterator.hasNext());
        }
        return false;
    }

    default boolean countSpace(List<class_1799> stacks, int start, int end, class_2350 side) {
        return countSpace(stacks, start, end);
    }

    default boolean countSpace(List<class_1799> stacks, int start, int end) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return true;
        }
        if (listSize == 1) {
            class_1799 stack = stacks.getFirst();
            int count = stack.method_7947();
            return countSpace(stack, count, start, end) == count;
        }
        Object2IntLinkedOpenCustomHashMap<class_1799> map = new Object2IntLinkedOpenCustomHashMap<>(ITEM_STACK_HASH_STRATEGY);
        for (class_1799 stack : stacks) {
            map.merge(stack, stack.method_7947(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet<class_1799> entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            Object2IntMap.Entry<class_1799> entry = entries.first();
            class_1799 stack = entry.getKey();
            int count = entry.getIntValue();
            return countSpace(stack, count, start, end) == count;
        }
        for (int i = start; i <= end; i++) {
            class_1799 target = create$getStack(i);
            boolean empty = target.method_7960();
            ObjectIterator<Object2IntMap.Entry<class_1799>> iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry<class_1799> entry = iterator.next();
                class_1799 stack = entry.getKey();
                if (create$isValid(i, stack)) {
                    if (empty) {
                        int remaining = entry.getIntValue();
                        int insert = Math.min(remaining, create$getMaxCount(stack));
                        if (remaining == insert) {
                            iterator.remove();
                            if (entries.isEmpty()) {
                                return true;
                            }
                        } else {
                            entry.setValue(remaining - insert);
                        }
                        break;
                    } else if (matches(target, stack)) {
                        int maxCount = target.method_7914();
                        int count = target.method_7947();
                        if (count != maxCount) {
                            int remaining = entry.getIntValue();
                            int insert = Math.min(remaining, maxCount - count);
                            if (remaining == insert) {
                                iterator.remove();
                                if (entries.isEmpty()) {
                                    return true;
                                }
                            } else {
                                entry.setValue(remaining - insert);
                            }
                        }
                        break;
                    }
                }
            } while (iterator.hasNext());
        }
        return false;
    }

    @SuppressWarnings("deprecation")
    default class_1799 directCopy(class_1799 stack, int count) {
        assert stack.field_8038 != null;
        class_1799 copy = new class_1799(stack.field_8038, count, stack.field_49270.method_57941());
        copy.method_7912(stack.method_7965());
        return copy;
    }

    default int extract(class_1799 stack, class_2350 side) {
        return extract(stack);
    }

    default int extract(class_1799 stack) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return 0;
        }
        return extract(stack, maxAmount);
    }

    default int extract(class_1799 stack, int maxAmount, class_2350 side) {
        return extract(stack, maxAmount);
    }

    default int extract(class_1799 stack, int maxAmount) {
        int remaining = maxAmount;
        for (int i = 0, size = create$size(); i < size; i++) {
            class_1799 target = create$getStack(i);
            if (target.method_7960()) {
                continue;
            }
            if (matches(target, stack)) {
                int count = target.method_7947();
                if (count > remaining) {
                    target.method_7939(count - remaining);
                    create$markDirty();
                    return maxAmount;
                }
                create$setStack(i, class_1799.field_8037);
                if (count == remaining) {
                    create$markDirty();
                    return maxAmount;
                }
                remaining -= count;
            }
        }
        if (remaining == maxAmount) {
            return 0;
        }
        create$markDirty();
        return maxAmount - remaining;
    }

    default class_1799 extract(Predicate<class_1799> predicate, class_2350 side) {
        return extract(predicate);
    }

    default class_1799 extract(Predicate<class_1799> predicate) {
        for (int i = 0, size = create$size(); i < size; i++) {
            class_1799 target = create$getStack(i);
            if (target.method_7960()) {
                continue;
            }
            if (predicate.test(target)) {
                create$setStack(i, class_1799.field_8037);
                create$markDirty();
                return onExtract(target);
            }
        }
        return class_1799.field_8037;
    }

    default class_1799 extract(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
        return extract(predicate, maxAmount);
    }

    default class_1799 extract(Predicate<class_1799> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        for (int i = 0, size = create$size(); i < size; i++) {
            class_1799 findStack = create$getStack(i);
            if (findStack.method_7960()) {
                continue;
            }
            if (predicate.test(findStack)) {
                int count = findStack.method_7947();
                if (count > maxAmount) {
                    findStack.method_7939(count - maxAmount);
                    create$markDirty();
                    return onExtract(directCopy(findStack, maxAmount));
                }
                create$setStack(i, class_1799.field_8037);
                if (count == maxAmount) {
                    create$markDirty();
                    return onExtract(findStack);
                }
                int remaining = maxAmount - count;
                for (i = i + 1; i < size; i++) {
                    class_1799 stack = create$getStack(i);
                    if (stack.method_7960()) {
                        continue;
                    }
                    if (matches(stack, findStack)) {
                        count = stack.method_7947();
                        if (count < remaining) {
                            create$setStack(i, class_1799.field_8037);
                            remaining -= count;
                            continue;
                        }
                        if (count == remaining) {
                            create$setStack(i, class_1799.field_8037);
                        } else {
                            stack.method_7939(count - remaining);
                        }
                        create$markDirty();
                        findStack.method_7939(maxAmount);
                        return onExtract(findStack);
                    }
                }
                create$markDirty();
                findStack.method_7939(maxAmount - remaining);
                return onExtract(findStack);
            }
        }
        return class_1799.field_8037;
    }

    default List<class_1799> extract(List<class_1799> stacks, class_2350 side) {
        return extract(stacks);
    }

    default List<class_1799> extract(List<class_1799> stacks) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return stacks;
        }
        if (listSize == 1) {
            class_1799 stack = stacks.getFirst();
            int count = stack.method_7947();
            int extract = extract(stack);
            if (count == extract) {
                return List.of();
            }
            if (extract == 0) {
                return stacks;
            }
            return List.of(directCopy(stack, count - extract));
        }
        Object2IntLinkedOpenCustomHashMap<class_1799> map = new Object2IntLinkedOpenCustomHashMap<>(ITEM_STACK_HASH_STRATEGY);
        for (class_1799 stack : stacks) {
            map.merge(stack, stack.method_7947(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet<class_1799> entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            Object2IntMap.Entry<class_1799> entry = entries.first();
            class_1799 stack = entry.getKey();
            int count = entry.getIntValue();
            int extract = extract(stack, count);
            if (count == extract) {
                return List.of();
            }
            if (extract == 0) {
                return stacks;
            }
            return List.of(directCopy(stack, count - extract));
        }
        boolean dirty = false;
        for (int i = 0, size = create$size(); i < size; i++) {
            class_1799 target = create$getStack(i);
            if (target.method_7960()) {
                continue;
            }
            ObjectIterator<Object2IntMap.Entry<class_1799>> iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry<class_1799> entry = iterator.next();
                class_1799 stack = entry.getKey();
                if (matches(target, stack)) {
                    int count = target.method_7947();
                    int remaining = entry.getIntValue();
                    if (count < remaining) {
                        create$setStack(i, class_1799.field_8037);
                        entry.setValue(remaining - count);
                        break;
                    }
                    if (count == remaining) {
                        create$setStack(i, class_1799.field_8037);
                    } else {
                        target.method_7939(count - remaining);
                    }
                    iterator.remove();
                    if (entries.isEmpty()) {
                        create$markDirty();
                        return List.of();
                    }
                    dirty = true;
                    break;
                }
            } while (iterator.hasNext());
        }
        if (dirty) {
            List<class_1799> result = new ArrayList<>(entries.size());
            for (Object2IntMap.Entry<class_1799> entry : entries) {
                class_1799 stack = entry.getKey();
                int count = entry.getIntValue();
                if (stack.method_7947() == count) {
                    result.add(stack);
                } else {
                    result.add(directCopy(stack, count));
                }
            }
            create$markDirty();
            return result;
        } else {
            return stacks;
        }
    }

    default int extractAll(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
        return extractAll(predicate, maxAmount);
    }

    default int extractAll(Predicate<class_1799> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return 0;
        }
        int remaining = maxAmount;
        for (int i = 0, size = create$size(); i < size; i++) {
            class_1799 stack = create$getStack(i);
            if (stack.method_7960()) {
                continue;
            }
            if (predicate.test(stack)) {
                int count = stack.method_7947();
                if (count < remaining) {
                    create$setStack(i, class_1799.field_8037);
                    remaining -= count;
                    continue;
                }
                if (count == remaining) {
                    create$setStack(i, class_1799.field_8037);
                } else {
                    stack.method_7939(count - remaining);
                }
                create$markDirty();
                return maxAmount;
            }
        }
        if (remaining == maxAmount) {
            return 0;
        }
        create$markDirty();
        return maxAmount - remaining;
    }

    default class_1799 extractAny(class_2350 side) {
        return extractAny();
    }

    default class_1799 extractAny() {
        for (int i = 0, size = create$size(); i < size; i++) {
            class_1799 target = create$getStack(i);
            if (target.method_7960()) {
                continue;
            }
            create$setStack(i, class_1799.field_8037);
            create$markDirty();
            return onExtract(target);
        }
        return class_1799.field_8037;
    }

    default class_1799 extractAny(int maxAmount, class_2350 side) {
        return extractAny(maxAmount);
    }

    default class_1799 extractAny(int maxAmount) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        for (int i = 0, size = create$size(); i < size; i++) {
            class_1799 findStack = create$getStack(i);
            if (findStack.method_7960()) {
                continue;
            }
            int count = findStack.method_7947();
            if (count > maxAmount) {
                findStack.method_7939(count - maxAmount);
                create$markDirty();
                return onExtract(directCopy(findStack, maxAmount));
            }
            create$setStack(i, class_1799.field_8037);
            if (count == maxAmount) {
                create$markDirty();
                return onExtract(findStack);
            }
            int remaining = maxAmount - count;
            for (i = i + 1; i < size; i++) {
                class_1799 stack = create$getStack(i);
                if (stack.method_7960()) {
                    continue;
                }
                if (matches(stack, findStack)) {
                    count = stack.method_7947();
                    if (count < remaining) {
                        create$setStack(i, class_1799.field_8037);
                        remaining -= count;
                        continue;
                    }
                    if (count == remaining) {
                        create$setStack(i, class_1799.field_8037);
                    } else {
                        stack.method_7939(count - remaining);
                    }
                    create$markDirty();
                    findStack.method_7939(maxAmount);
                    return onExtract(findStack);
                }
            }
            create$markDirty();
            findStack.method_7939(maxAmount - remaining);
            return onExtract(findStack);
        }
        return class_1799.field_8037;
    }

    default int forceInsert(class_1799 stack) {
        return BaseInventory.this.insert(stack);
    }

    default int forceInsert(class_1799 stack, int maxAmount) {
        return BaseInventory.this.insert(stack, maxAmount);
    }

    default boolean forcePreciseInsert(class_1799 stack) {
        return BaseInventory.this.preciseInsert(stack);
    }

    default boolean forcePreciseInsert(class_1799 stack, int maxAmount) {
        return BaseInventory.this.preciseInsert(stack, maxAmount);
    }

    default int insert(class_1799 stack, class_2350 side) {
        return insert(stack);
    }

    default int insert(class_1799 stack) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return 0;
        }
        return insert(stack, maxAmount);
    }

    default int insert(class_1799 stack, int maxAmount, class_2350 side) {
        return insert(stack, maxAmount);
    }

    default int insert(class_1799 stack, int maxAmount) {
        int remaining = maxAmount;
        for (int i = 0, size = create$size(); i < size; i++) {
            if (create$isValid(i, stack)) {
                class_1799 target = create$getStack(i);
                if (target.method_7960()) {
                    int insert = Math.min(remaining, create$getMaxCount(stack));
                    create$setStack(i, directCopy(stack, insert));
                    if (remaining == insert) {
                        create$markDirty();
                        return maxAmount;
                    }
                    remaining -= insert;
                } else if (matches(target, stack)) {
                    int maxCount = target.method_7914();
                    int count = target.method_7947();
                    if (count != maxCount) {
                        int insert = Math.min(remaining, maxCount - count);
                        target.method_7939(count + insert);
                        if (remaining == insert) {
                            create$markDirty();
                            return maxAmount;
                        }
                        remaining -= insert;
                    }
                }
            }
        }
        if (remaining == maxAmount) {
            return 0;
        }
        create$markDirty();
        return maxAmount - remaining;
    }

    default int insert(class_1799 stack, int maxAmount, int start, int end, class_2350 side) {
        return insert(stack, maxAmount, start, end);
    }

    default int insert(class_1799 stack, int maxAmount, int start, int end) {
        int remaining = maxAmount;
        for (int i = start; i < end; i++) {
            if (create$isValid(i, stack)) {
                class_1799 target = create$getStack(i);
                if (target.method_7960()) {
                    int insert = Math.min(remaining, create$getMaxCount(stack));
                    create$setStack(i, directCopy(stack, insert));
                    if (remaining == insert) {
                        create$markDirty();
                        return maxAmount;
                    }
                    remaining -= insert;
                } else if (matches(target, stack)) {
                    int maxCount = target.method_7914();
                    int count = target.method_7947();
                    if (count != maxCount) {
                        int insert = Math.min(remaining, maxCount - count);
                        target.method_7939(count + insert);
                        if (remaining == insert) {
                            create$markDirty();
                            return maxAmount;
                        }
                        remaining -= insert;
                    }
                }
            }
        }
        if (remaining == maxAmount) {
            return 0;
        }
        create$markDirty();
        return maxAmount - remaining;
    }

    default List<class_1799> insert(List<class_1799> stacks, class_2350 side) {
        return insert(stacks);
    }

    default List<class_1799> insert(List<class_1799> stacks) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return stacks;
        }
        if (listSize == 1) {
            class_1799 stack = stacks.getFirst();
            int count = stack.method_7947();
            int insert = insert(stack);
            if (count == insert) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(directCopy(stack, count - insert));
        }
        Object2IntLinkedOpenCustomHashMap<class_1799> map = new Object2IntLinkedOpenCustomHashMap<>(ITEM_STACK_HASH_STRATEGY);
        for (class_1799 stack : stacks) {
            map.merge(stack, stack.method_7947(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet<class_1799> entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            Object2IntMap.Entry<class_1799> entry = entries.first();
            class_1799 stack = entry.getKey();
            int count = entry.getIntValue();
            int insert = insert(stack, count);
            if (count == insert) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(directCopy(stack, count - insert));
        }
        boolean dirty = false;
        for (int i = 0, size = create$size(); i < size; i++) {
            class_1799 target = create$getStack(i);
            boolean empty = target.method_7960();
            ObjectIterator<Object2IntMap.Entry<class_1799>> iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry<class_1799> entry = iterator.next();
                class_1799 stack = entry.getKey();
                if (create$isValid(i, stack)) {
                    if (empty) {
                        int remaining = entry.getIntValue();
                        int insert = Math.min(remaining, create$getMaxCount(stack));
                        create$setStack(i, directCopy(stack, insert));
                        if (remaining == insert) {
                            iterator.remove();
                            if (entries.isEmpty()) {
                                create$markDirty();
                                return List.of();
                            }
                        } else {
                            entry.setValue(remaining - insert);
                        }
                        dirty = true;
                        break;
                    } else if (matches(target, stack)) {
                        int maxCount = target.method_7914();
                        int count = target.method_7947();
                        if (count != maxCount) {
                            int remaining = entry.getIntValue();
                            int insert = Math.min(remaining, maxCount - count);
                            target.method_7939(count + insert);
                            if (remaining == insert) {
                                iterator.remove();
                                if (entries.isEmpty()) {
                                    create$markDirty();
                                    return List.of();
                                }
                            } else {
                                entry.setValue(remaining - insert);
                            }
                            dirty = true;
                        }
                        break;
                    }
                }
            } while (iterator.hasNext());
        }
        if (dirty) {
            List<class_1799> result = new ArrayList<>(entries.size());
            for (Object2IntMap.Entry<class_1799> entry : entries) {
                class_1799 stack = entry.getKey();
                int count = entry.getIntValue();
                if (stack.method_7947() == count) {
                    result.add(stack);
                } else {
                    result.add(directCopy(stack, count));
                }
            }
            create$markDirty();
            return result;
        } else {
            return stacks;
        }
    }

    default List<class_1799> insert(List<class_1799> stacks, int start, int end, class_2350 side) {
        return insert(stacks, start, end);
    }

    default List<class_1799> insert(List<class_1799> stacks, int start, int end) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return stacks;
        }
        if (listSize == 1) {
            class_1799 stack = stacks.getFirst();
            int count = stack.method_7947();
            int insert = insert(stack, count, start, end);
            if (count == insert) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(directCopy(stack, count - insert));
        }
        Object2IntLinkedOpenCustomHashMap<class_1799> map = new Object2IntLinkedOpenCustomHashMap<>(ITEM_STACK_HASH_STRATEGY);
        for (class_1799 stack : stacks) {
            map.merge(stack, stack.method_7947(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet<class_1799> entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            Object2IntMap.Entry<class_1799> entry = entries.first();
            class_1799 stack = entry.getKey();
            int count = entry.getIntValue();
            int insert = insert(stack, count, start, end);
            if (count == insert) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(directCopy(stack, count - insert));
        }
        boolean dirty = false;
        for (int i = start; i < end; i++) {
            class_1799 target = create$getStack(i);
            boolean empty = target.method_7960();
            ObjectIterator<Object2IntMap.Entry<class_1799>> iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry<class_1799> entry = iterator.next();
                class_1799 stack = entry.getKey();
                if (create$isValid(i, stack)) {
                    if (empty) {
                        int remaining = entry.getIntValue();
                        int insert = Math.min(remaining, create$getMaxCount(stack));
                        create$setStack(i, directCopy(stack, insert));
                        if (remaining == insert) {
                            iterator.remove();
                            if (entries.isEmpty()) {
                                create$markDirty();
                                return List.of();
                            }
                        } else {
                            entry.setValue(remaining - insert);
                        }
                        dirty = true;
                        break;
                    } else if (matches(target, stack)) {
                        int maxCount = target.method_7914();
                        int count = target.method_7947();
                        if (count != maxCount) {
                            int remaining = entry.getIntValue();
                            int insert = Math.min(remaining, maxCount - count);
                            target.method_7939(count + insert);
                            if (remaining == insert) {
                                iterator.remove();
                                if (entries.isEmpty()) {
                                    create$markDirty();
                                    return List.of();
                                }
                            } else {
                                entry.setValue(remaining - insert);
                            }
                            dirty = true;
                        }
                        break;
                    }
                }
            } while (iterator.hasNext());
        }
        if (dirty) {
            List<class_1799> result = new ArrayList<>(entries.size());
            for (Object2IntMap.Entry<class_1799> entry : entries) {
                class_1799 stack = entry.getKey();
                int count = entry.getIntValue();
                if (stack.method_7947() == count) {
                    result.add(stack);
                } else {
                    result.add(directCopy(stack, count));
                }
            }
            create$markDirty();
            return result;
        } else {
            return stacks;
        }
    }

    default int insertExist(class_1799 stack, class_2350 side) {
        return insertExist(stack);
    }

    default int insertExist(class_1799 stack, int maxAmount, class_2350 side) {
        return insertExist(stack);
    }

    default int insertExist(class_1799 stack) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return 0;
        }
        return insertExist(stack, maxAmount);
    }

    default int insertExist(class_1799 stack, int maxAmount) {
        int remaining = maxAmount;
        List<Integer> emptys = new ArrayList<>();
        for (int i = 0, size = create$size(); i < size; i++) {
            if (create$isValid(i, stack)) {
                class_1799 target = create$getStack(i);
                if (target.method_7960()) {
                    emptys.add(i);
                } else if (matches(target, stack)) {
                    int maxCount = target.method_7914();
                    int count = target.method_7947();
                    if (count != maxCount) {
                        int insert = Math.min(remaining, maxCount - count);
                        target.method_7939(count + insert);
                        if (remaining == insert) {
                            create$markDirty();
                            return maxAmount;
                        }
                        remaining -= insert;
                    }
                }
            }
        }
        for (int i : emptys) {
            int insert = Math.min(remaining, create$getMaxCount(stack));
            create$setStack(i, directCopy(stack, insert));
            if (remaining == insert) {
                create$markDirty();
                return maxAmount;
            }
            remaining -= insert;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        create$markDirty();
        return maxAmount - remaining;
    }

    @NotNull
    default Iterator<class_1799> iterator(class_2350 side) {
        return iterator();
    }

    default boolean matches(class_1799 stack, class_1799 otherStack) {
        if (stack.method_31574(otherStack.method_7909())) {
            class_9335 stackComponents = stack.field_49270;
            class_9335 otherStackComponents = otherStack.field_49270;
            if (stackComponents == otherStackComponents) {
                return true;
            }
            Reference2ObjectMap<class_9331<?>, Optional<?>> stackComponentMap = stackComponents.field_49655;
            Reference2ObjectMap<class_9331<?>, Optional<?>> otherStackComponentMap = otherStackComponents.field_49655;
            if (stackComponentMap == otherStackComponentMap) {
                return true;
            }
            int stackComponentCount = stackComponentMap.size();
            if (stackComponentMap.containsKey(class_9334.field_50071)) {
                stackComponentCount--;
            }
            int otherStackComponentCount = otherStackComponentMap.size();
            boolean hasMaxCapacityComponent = false;
            if (otherStackComponentMap.containsKey(class_9334.field_50071)) {
                otherStackComponentCount--;
                hasMaxCapacityComponent = true;
            }
            if (stackComponentCount != otherStackComponentCount) {
                return false;
            }
            if (hasMaxCapacityComponent) {
                ObjectSet<Reference2ObjectMap.Entry<class_9331<?>, Optional<?>>> stackComponentSet = stackComponentMap.reference2ObjectEntrySet();
                for (Reference2ObjectMap.Entry<class_9331<?>, Optional<?>> componentEntry : otherStackComponentMap.reference2ObjectEntrySet()) {
                    if (!stackComponentSet.contains(componentEntry) && componentEntry.getKey() != class_9334.field_50071) {
                        return false;
                    }
                }
                return true;
            }
            return stackComponentMap.reference2ObjectEntrySet().containsAll(otherStackComponentMap.reference2ObjectEntrySet());
        }
        return false;
    }

    default class_1799 onExtract(class_1799 stack) {
        return stack;
    }

    default boolean preciseExtract(class_1799 stack, class_2350 side) {
        return preciseExtract(stack);
    }

    default boolean preciseExtract(class_1799 stack) {
        if (stack.method_7960()) {
            return true;
        }
        int remaining = stack.method_7947();
        List<Runnable> changes = new ArrayList<>();
        for (int i = 0, size = create$size(); i < size; i++) {
            class_1799 target = create$getStack(i);
            if (target.method_7960()) {
                continue;
            }
            if (matches(target, stack)) {
                int count = target.method_7947();
                if (count > remaining) {
                    changes.forEach(Runnable::run);
                    target.method_7939(count - remaining);
                    create$markDirty();
                    return true;
                }
                if (count == remaining) {
                    changes.forEach(Runnable::run);
                    create$setStack(i, class_1799.field_8037);
                    create$markDirty();
                    return true;
                }
                int slot = i;
                changes.add(() -> create$setStack(slot, class_1799.field_8037));
                remaining -= count;
            }
        }
        return false;
    }

    default class_1799 preciseExtract(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
        return preciseExtract(predicate, maxAmount);
    }

    default class_1799 preciseExtract(Predicate<class_1799> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        int size = create$size();
        List<Integer> buffer = new ArrayList<>(size);
        for (int i = 0; i < size; i++) {
            class_1799 findStack = create$getStack(i);
            if (findStack.method_7960()) {
                continue;
            }
            if (predicate.test(findStack)) {
                int count = findStack.method_7947();
                if (count > maxAmount) {
                    findStack.method_7939(count - maxAmount);
                    create$markDirty();
                    return onExtract(directCopy(findStack, maxAmount));
                }
                if (count == maxAmount) {
                    create$setStack(i, class_1799.field_8037);
                    create$markDirty();
                    return onExtract(findStack);
                }
                buffer.add(i);
                int remaining = maxAmount - count;
                for (i = i + 1; i < size; i++) {
                    class_1799 stack = create$getStack(i);
                    if (stack.method_7960()) {
                        continue;
                    }
                    if (matches(stack, findStack)) {
                        count = stack.method_7947();
                        if (count < remaining) {
                            buffer.add(i);
                            remaining -= count;
                            continue;
                        }
                        buffer.forEach(slot -> create$setStack(slot, class_1799.field_8037));
                        if (count == remaining) {
                            create$setStack(i, class_1799.field_8037);
                        } else {
                            stack.method_7939(count - remaining);
                        }
                        create$markDirty();
                        findStack.method_7939(maxAmount);
                        return onExtract(findStack);
                    }
                }
            }
        }
        return class_1799.field_8037;
    }

    default boolean preciseInsert(class_1799 stack, class_2350 side) {
        return preciseInsert(stack);
    }

    default boolean preciseInsert(class_1799 stack) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return true;
        }
        return preciseInsert(stack, maxAmount);
    }

    default boolean preciseInsert(class_1799 stack, int maxAmount, class_2350 side) {
        return preciseInsert(stack, maxAmount);
    }

    default boolean preciseInsert(class_1799 stack, int maxAmount) {
        List<Runnable> changes = new ArrayList<>();
        for (int i = 0, size = create$size(); i < size; i++) {
            if (create$isValid(i, stack)) {
                class_1799 target = create$getStack(i);
                if (target.method_7960()) {
                    int insert = Math.min(maxAmount, create$getMaxCount(stack));
                    if (maxAmount == insert) {
                        changes.forEach(Runnable::run);
                        create$setStack(i, directCopy(stack, insert));
                        create$markDirty();
                        return true;
                    }
                    int slot = i;
                    changes.add(() -> create$setStack(slot, directCopy(stack, insert)));
                    maxAmount -= insert;
                } else if (matches(target, stack)) {
                    int maxCount = target.method_7914();
                    int count = target.method_7947();
                    if (count != maxCount) {
                        int insert = Math.min(maxAmount, maxCount - count);
                        if (maxAmount == insert) {
                            changes.forEach(Runnable::run);
                            target.method_7939(count + insert);
                            create$markDirty();
                            return true;
                        }
                        changes.add(() -> target.method_7939(count + insert));
                        maxAmount -= insert;
                    }
                }
            }
        }
        return false;
    }

    default boolean preciseInsert(List<class_1799> stacks, class_2350 side) {
        return preciseInsert(stacks);
    }

    default boolean preciseInsert(List<class_1799> stacks) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return true;
        }
        if (listSize == 1) {
            return preciseInsert(stacks.getFirst());
        }
        Object2IntLinkedOpenCustomHashMap<class_1799> map = new Object2IntLinkedOpenCustomHashMap<>(ITEM_STACK_HASH_STRATEGY);
        for (class_1799 stack : stacks) {
            map.merge(stack, stack.method_7947(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet<class_1799> entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            Object2IntMap.Entry<class_1799> entry = entries.first();
            return preciseInsert(entry.getKey(), entry.getIntValue());
        }
        List<Runnable> changes = new ArrayList<>();
        for (int i = 0, size = create$size(); i < size; i++) {
            class_1799 target = create$getStack(i);
            boolean empty = target.method_7960();
            ObjectIterator<Object2IntMap.Entry<class_1799>> iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry<class_1799> entry = iterator.next();
                class_1799 stack = entry.getKey();
                if (create$isValid(i, stack)) {
                    if (empty) {
                        int remaining = entry.getIntValue();
                        int insert = Math.min(remaining, create$getMaxCount(stack));
                        if (remaining == insert) {
                            iterator.remove();
                            if (entries.isEmpty()) {
                                changes.forEach(Runnable::run);
                                create$setStack(i, directCopy(stack, insert));
                                create$markDirty();
                                return true;
                            }
                        } else {
                            int slot = i;
                            changes.add(() -> create$setStack(slot, directCopy(stack, insert)));
                            entry.setValue(remaining - insert);
                        }
                        break;
                    } else if (matches(target, stack)) {
                        int maxCount = target.method_7914();
                        int count = target.method_7947();
                        if (count != maxCount) {
                            int remaining = entry.getIntValue();
                            int insert = Math.min(remaining, maxCount - count);
                            if (remaining == insert) {
                                iterator.remove();
                                if (entries.isEmpty()) {
                                    changes.forEach(Runnable::run);
                                    target.method_7939(count + insert);
                                    create$markDirty();
                                    return true;
                                }
                            } else {
                                changes.add(() -> target.method_7939(count + insert));
                                entry.setValue(remaining - insert);
                            }
                        }
                        break;
                    }
                }
            } while (iterator.hasNext());
        }
        return false;
    }

    default boolean update(Predicate<class_1799> predicate, Function<class_1799, class_1799> update, class_2350 side) {
        return update(predicate, update);
    }

    default boolean update(Predicate<class_1799> predicate, Function<class_1799, class_1799> update) {
        for (int i = 0, size = create$size(); i < size; i++) {
            class_1799 stack = create$getStack(i);
            if (stack.method_7960()) {
                continue;
            }
            if (predicate.test(stack)) {
                class_1799 replace = update.apply(stack);
                if (replace != stack) {
                    create$setStack(i, replace);
                }
                create$markDirty();
                return true;
            }
        }
        return false;
    }

    @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
    default class_1799 removeMaxSize(class_1799 stack, Optional<Integer> max) {
        class_9335 components = stack.field_49270;
        components.method_57942();
        components.field_49655.remove(class_9334.field_50071, max);
        return stack;
    }

    @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
    default void setMaxSize(class_1799 stack, Optional<Integer> max) {
        class_9335 components = stack.field_49270;
        components.method_57942();
        components.field_49655.put(class_9334.field_50071, max);
    }

    default Stream<class_1799> stream(class_2350 side) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator(side), Spliterator.ORDERED), false);
    }

    default Stream<class_1799> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator(), Spliterator.ORDERED), false);
    }
}
