package com.zurrtum.create.infrastructure.particle;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllParticleTypes;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_3611;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9326;

public record FluidParticleData(class_2396<FluidParticleData> type, class_3611 fluid, class_9326 components) implements class_2394 {

    private static final RecordCodecBuilder<FluidParticleData, class_3611> FLUID_CODEC = class_7923.field_41173.method_39673().fieldOf("fluid")
        .forGetter(FluidParticleData::fluid);
    private static final RecordCodecBuilder<FluidParticleData, class_9326> COMPONENTS_CODEC = class_9326.field_49589.fieldOf("components")
        .forGetter(FluidParticleData::components);
    public static final MapCodec<FluidParticleData> CODEC = RecordCodecBuilder.mapCodec(i -> i.group(FLUID_CODEC, COMPONENTS_CODEC)
        .apply(i, FluidParticleData::particle));
    public static final MapCodec<FluidParticleData> BASIN_CODEC = RecordCodecBuilder.mapCodec(i -> i.group(FLUID_CODEC, COMPONENTS_CODEC)
        .apply(i, FluidParticleData::basin));
    public static final MapCodec<FluidParticleData> DRIP_CODEC = RecordCodecBuilder.mapCodec(i -> i.group(FLUID_CODEC, COMPONENTS_CODEC)
        .apply(i, FluidParticleData::drip));

    private static final class_9139<class_9129, class_3611> FLUID_STREAM_CODEC = class_9135.method_56365(class_7924.field_41270);
    public static final class_9139<class_9129, FluidParticleData> STREAM_CODEC = class_9139.method_56435(
        FLUID_STREAM_CODEC,
        FluidParticleData::fluid,
        class_9326.field_49590,
        FluidParticleData::components,
        FluidParticleData::particle
    );
    public static final class_9139<class_9129, FluidParticleData> BASIN_STREAM_CODEC = class_9139.method_56435(
        FLUID_STREAM_CODEC,
        FluidParticleData::fluid,
        class_9326.field_49590,
        FluidParticleData::components,
        FluidParticleData::basin
    );
    public static final class_9139<class_9129, FluidParticleData> DRIP_STREAM_CODEC = class_9139.method_56435(
        FLUID_STREAM_CODEC,
        FluidParticleData::fluid,
        class_9326.field_49590,
        FluidParticleData::components,
        FluidParticleData::drip
    );

    public FluidParticleData(class_2396<FluidParticleData> type, class_3611 fluid) {
        this(type, fluid, class_9326.field_49588);
    }

    public static FluidParticleData particle(class_3611 fluid, class_9326 components) {
        return new FluidParticleData(AllParticleTypes.FLUID_PARTICLE, fluid, components);
    }

    public static FluidParticleData basin(class_3611 fluid, class_9326 components) {
        return new FluidParticleData(AllParticleTypes.BASIN_FLUID, fluid, components);
    }

    public static FluidParticleData drip(class_3611 fluid, class_9326 components) {
        return new FluidParticleData(AllParticleTypes.FLUID_DRIP, fluid, components);
    }

    @Override
    public class_2396<FluidParticleData> method_10295() {
        return type;
    }
}
