package com.zurrtum.create.mixin;

import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.content.contraptions.minecart.capability.MinecartController;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1688;

@Mixin(class_1688.class)
public class AbstractMinecartEntityMixin {
    @Inject(method = "readCustomData(Lnet/minecraft/storage/ReadView;)V", at = @At("TAIL"))
    private void readCustomData(class_11368 input, CallbackInfo ci) {
        input.method_71426("create:minecart_controller", MinecartController.CODEC).ifPresent(controller -> {
            class_1688 minecart = (class_1688) (Object) this;
            controller.setCart(minecart);
            AllSynchedDatas.MINECART_CONTROLLER.set(minecart, Optional.of(controller));
        });
    }

    @Inject(method = "writeCustomData(Lnet/minecraft/storage/WriteView;)V", at = @At("TAIL"))
    private void writeCustomData(class_11372 output, CallbackInfo ci) {
        AllSynchedDatas.MINECART_CONTROLLER.get((class_1688) (Object) this).ifPresent(controller -> {
            output.method_71468("create:minecart_controller", MinecartController.CODEC, controller);
        });
    }
}
