package com.zurrtum.create.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.content.contraptions.minecart.MinecartCouplingItem;
import com.zurrtum.create.content.contraptions.mounted.MinecartContraptionItem;
import com.zurrtum.create.content.equipment.extendoGrip.ExtendoGripItem;
import com.zurrtum.create.foundation.item.CustomAttackSoundItem;
import com.zurrtum.create.foundation.item.DamageControlItem;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1657.class)
public abstract class PlayerEntityMixin {
    @Shadow
    public abstract @NotNull class_1799 getWeaponStack();

    @Inject(method = "interact(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/ActionResult;", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/player/PlayerEntity;getStackInHand(Lnet/minecraft/util/Hand;)Lnet/minecraft/item/ItemStack;", ordinal = 0), cancellable = true)
    private void interact(class_1297 entity, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        class_1657 player = (class_1657) (Object) this;
        class_1269 result = MinecartCouplingItem.handleInteractionWithMinecart(player, hand, entity);
        if (result != null) {
            cir.setReturnValue(result);
        }
        result = MinecartContraptionItem.wrenchCanBeUsedToPickUpMinecartContraptions(player, hand, entity);
        if (result != null) {
            cir.setReturnValue(result);
        }
    }

    @Inject(method = "attack(Lnet/minecraft/entity/Entity;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;postHit(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/entity/LivingEntity;)Z"))
    private void attack(class_1297 target, CallbackInfo ci) {
        ExtendoGripItem.postDamageEntity((class_1657) (Object) this);
    }

    @WrapOperation(method = "attack(Lnet/minecraft/entity/Entity;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/Entity;sidedDamage(Lnet/minecraft/entity/damage/DamageSource;F)Z"))
    private boolean damage(
        class_1297 entity,
        class_1282 source,
        float amount,
        Operation<Boolean> original,
        @Local class_1799 stack,
        @Share("nodamage") LocalBooleanRef nodamage
    ) {
        if (stack.method_7909() instanceof DamageControlItem item) {
            if (!item.damage(entity)) {
                nodamage.set(true);
                return true;
            }
        }
        return original.call(entity, source, amount);
    }

    @WrapOperation(method = "attack(Lnet/minecraft/entity/Entity;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;postDamageEntity(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/entity/LivingEntity;)V"))
    private void postDamageEntity(
        class_1799 instance,
        class_1309 target,
        class_1309 user,
        Operation<Void> original,
        @Share("nodamage") LocalBooleanRef nodamage
    ) {
        if (nodamage.get()) {
            return;
        }
        original.call(instance, target, user);
    }

    @WrapOperation(method = "attack(Lnet/minecraft/entity/Entity;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/World;playSound(Lnet/minecraft/entity/Entity;DDDLnet/minecraft/sound/SoundEvent;Lnet/minecraft/sound/SoundCategory;FF)V"))
    private void playSound(
        class_1937 world,
        class_1297 source,
        double x,
        double y,
        double z,
        class_3414 sound,
        class_3419 category,
        float volume,
        float pitch,
        Operation<Void> original
    ) {
        class_1799 stack = getWeaponStack();
        if (stack.method_7909() instanceof CustomAttackSoundItem item) {
            item.playSound(world, (class_1657) (Object) this, x, y, z, sound, category, volume, pitch);
        } else {
            original.call(world, source, x, y, z, sound, category, volume, pitch);
        }
    }

    @Inject(method = "writeCustomData(Lnet/minecraft/storage/WriteView;)V", at = @At("TAIL"))
    private void writeCustomData(class_11372 view, CallbackInfo ci) {
        class_2487 compound = AllSynchedDatas.TOOLBOX.get((class_1657) (Object) this);
        if (!compound.method_33133()) {
            view.method_71468("CreateToolboxData", class_2487.field_25128, compound);
        }
    }

    @Inject(method = "readCustomData(Lnet/minecraft/storage/ReadView;)V", at = @At("TAIL"))
    private void readCustomData(class_11368 view, CallbackInfo ci) {
        view.method_71426("CreateToolboxData", class_2487.field_25128).ifPresent(compound -> AllSynchedDatas.TOOLBOX.set((class_1657) (Object) this, compound));
    }
}
